/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.Invokable;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.FrameStateAssignmentPhase;
import org.graalvm.compiler.phases.common.GuardLoweringPhase;
import org.graalvm.compiler.phases.common.LoweringPhase;
import org.graalvm.compiler.phases.common.RemoveValueProxyPhase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate", size=NodeSize.SIZE_UNKNOWN, sizeRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate")
public abstract class MacroNode
extends FixedWithNextNode
implements Lowerable,
Invokable {
    public static final NodeClass<MacroNode> TYPE = NodeClass.create(MacroNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> arguments;
    protected final int bci;
    protected final ResolvedJavaMethod callerMethod;
    protected final ResolvedJavaMethod targetMethod;
    protected final CallTargetNode.InvokeKind invokeKind;
    protected final StampPair returnStamp;

    protected MacroNode(NodeClass<? extends MacroNode> c, MacroParams p) {
        super((NodeClass<? extends FixedWithNextNode>)c, p.returnStamp != null ? p.returnStamp.getTrustedStamp() : null);
        this.assertArgumentCount(p.targetMethod, p.arguments);
        this.arguments = new NodeInputList((Node)this, (Node[])p.arguments);
        this.bci = p.bci;
        this.callerMethod = p.callerMethod;
        this.targetMethod = p.targetMethod;
        this.returnStamp = p.returnStamp;
        this.invokeKind = p.invokeKind;
        assert (!BytecodeFrame.isPlaceholderBci((int)p.bci));
    }

    @Override
    public ResolvedJavaMethod getContextMethod() {
        return this.callerMethod;
    }

    protected void assertArgumentCount(ResolvedJavaMethod method, ValueNode ... args) {
        assert (method.getSignature().getParameterCount(!method.isStatic()) == args.length);
    }

    public ValueNode getArgument(int i) {
        return (ValueNode)this.arguments.get(i);
    }

    public int getArgumentCount() {
        return this.arguments.size();
    }

    public ValueNode[] toArgumentArray() {
        return this.arguments.toArray((A[])new ValueNode[0]);
    }

    @Override
    public int bci() {
        return this.bci;
    }

    @Override
    public void setBci(int bci) {
    }

    @Override
    public ResolvedJavaMethod getTargetMethod() {
        return this.targetMethod;
    }

    public CallTargetNode.InvokeKind getInvokeKind() {
        return this.invokeKind;
    }

    protected FrameState stateAfter() {
        return null;
    }

    @Override
    protected void afterClone(Node other) {
        this.updateInliningLogAfterClone(other);
    }

    @Override
    public FixedNode asFixedNode() {
        return this;
    }

    protected StructuredGraph getLoweredSnippetGraph(LoweringTool tool) {
        return null;
    }

    protected StructuredGraph lowerReplacement(StructuredGraph replacementGraph, LoweringTool tool) {
        StructuredGraph.GuardsStage guardsStage;
        CoreProviders c = tool.getProviders();
        if (!this.graph().hasValueProxies()) {
            new RemoveValueProxyPhase().apply(replacementGraph);
        }
        if (!(guardsStage = this.graph().getGuardsStage()).allowsFloatingGuards()) {
            new GuardLoweringPhase().apply(replacementGraph, null);
            if (guardsStage.areFrameStatesAtDeopts()) {
                new FrameStateAssignmentPhase().apply(replacementGraph);
            }
        }
        DebugContext debug = replacementGraph.getDebug();
        try (DebugContext.Scope s = debug.scope((Object)"LoweringSnippetTemplate", replacementGraph);){
            new LoweringPhase(CanonicalizerPhase.create(), tool.getLoweringStage()).apply(replacementGraph, c);
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        return replacementGraph;
    }

    @Override
    public void lower(LoweringTool tool) {
        StructuredGraph replacementGraph = this.getLoweredSnippetGraph(tool);
        InvokeNode invoke = this.replaceWithInvoke();
        assert (invoke.verify());
        if (replacementGraph != null) {
            ValueNode nonNullReceiver;
            if (!this.targetMethod.isStatic() && (nonNullReceiver = InliningUtil.nonNullReceiver(invoke)) instanceof Lowerable) {
                ((Lowerable)((Object)nonNullReceiver)).lower(tool);
            }
            InliningUtil.inline(invoke, replacementGraph, false, this.targetMethod, "Replace with graph.", "LoweringPhase");
            replacementGraph.getDebug().dump(4, (Object)this.graph(), "After inlining replacement %s", replacementGraph);
        } else {
            if (BytecodeFrame.isPlaceholderBci((int)invoke.bci())) {
                throw new GraalError("%s: cannot lower to invoke with placeholder BCI: %s", this.graph(), this);
            }
            if (invoke.stateAfter() == null) {
                throw new GraalError("%s: cannot lower to invoke without state: %s", this.graph(), this);
            }
            invoke.lower(tool);
        }
    }

    public InvokeNode replaceWithInvoke() {
        try (DebugCloseable context = this.withNodeSourcePosition();){
            InvokeNode invoke = this.createInvoke();
            this.graph().replaceFixedWithFixed(this, invoke);
            InvokeNode invokeNode = invoke;
            return invokeNode;
        }
    }

    public LocationIdentity getLocationIdentity() {
        return LocationIdentity.any();
    }

    protected InvokeNode createInvoke() {
        MethodCallTargetNode callTarget = this.graph().add(new MethodCallTargetNode(this.invokeKind, this.targetMethod, this.arguments.toArray((A[])new ValueNode[this.arguments.size()]), this.returnStamp, null));
        InvokeNode invoke = this.graph().add(new InvokeNode((CallTargetNode)callTarget, this.bci, this.getLocationIdentity()));
        if (this.stateAfter() != null) {
            invoke.setStateAfter(this.stateAfter().duplicate());
            if (this.getStackKind() != JavaKind.Void) {
                invoke.stateAfter().replaceFirstInput(this, invoke);
            }
        }
        return invoke;
    }

    public static class MacroParams {
        public final CallTargetNode.InvokeKind invokeKind;
        public final ResolvedJavaMethod callerMethod;
        public final ResolvedJavaMethod targetMethod;
        public final int bci;
        public final StampPair returnStamp;
        public final ValueNode[] arguments;

        public MacroParams(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod callerMethod, ResolvedJavaMethod targetMethod, int bci, StampPair returnStamp, ValueNode ... arguments) {
            this.invokeKind = invokeKind;
            this.callerMethod = callerMethod;
            this.targetMethod = targetMethod;
            this.bci = bci;
            this.returnStamp = returnStamp;
            this.arguments = arguments;
        }

        public static MacroParams of(GraphBuilderContext b, ResolvedJavaMethod targetMethod, ValueNode ... arguments) {
            return new MacroParams(b.getInvokeKind(), b.getMethod(), targetMethod, b.bci(), b.getInvokeReturnStamp(b.getAssumptions()), arguments);
        }

        public static MacroParams of(GraphBuilderContext b, CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode ... arguments) {
            return new MacroParams(invokeKind, b.getMethod(), targetMethod, b.bci(), b.getInvokeReturnStamp(b.getAssumptions()), arguments);
        }

        public static MacroParams of(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod callerMethod, ResolvedJavaMethod targetMethod, int bci, StampPair returnStamp, ValueNode ... arguments) {
            return new MacroParams(invokeKind, callerMethod, targetMethod, bci, returnStamp, arguments);
        }
    }
}

