/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(allowedUsageTypes={InputType.Memory}, size=NodeSize.SIZE_512, cycles=NodeCycles.CYCLES_UNKNOWN)
public final class AMD64StringUTF16CompressNode
extends FixedWithNextNode
implements LIRLowerable,
MultiMemoryKill,
MemoryAccess {
    public static final NodeClass<AMD64StringUTF16CompressNode> TYPE = NodeClass.create(AMD64StringUTF16CompressNode.class);
    @Node.Input
    private ValueNode src;
    @Node.Input
    private ValueNode dst;
    @Node.Input
    private ValueNode len;
    final JavaKind readKind;
    @Node.OptionalInput(value=InputType.Memory)
    private MemoryKill lla;

    public AMD64StringUTF16CompressNode(ValueNode src, ValueNode dst, ValueNode len, JavaKind readKind) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, (Stamp)StampFactory.forInteger(32));
        this.src = src;
        this.dst = dst;
        this.len = len;
        this.readKind = readKind;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return NamedLocationIdentity.getArrayLocation(this.readKind);
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(JavaKind.Byte)};
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRGeneratorTool lgt = gen.getLIRGeneratorTool();
        Variable res = lgt.emitStringUTF16Compress(gen.operand(this.src), gen.operand(this.dst), gen.operand(this.len));
        gen.setResult(this, (Value)res);
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lla;
    }

    @Override
    public void setLastLocationAccess(MemoryKill newlla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lla), ValueNodeUtil.asNode(newlla));
        this.lla = newlla;
    }

    @Node.NodeIntrinsic
    public static native int compress(Pointer var0, Pointer var1, int var2, @Node.ConstantNodeParameter JavaKind var3);
}

