/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.StringSubstitutions;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayIndexOf;
import org.graalvm.compiler.replacements.nodes.ArrayCompareToNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;
import org.graalvm.compiler.word.Word;

@ClassSubstitution(value=String.class)
public class AMD64StringSubstitutions {
    static final MetaAccessProvider INJECTED = null;

    @MethodSubstitution(isStatic=true, optional=true)
    public static int indexOf(char[] source, int sourceOffset, int sourceCount, @Node.ConstantNodeParameter char[] target, int targetOffset, int targetCount, int origFromIndex) {
        int fromIndex = origFromIndex;
        if (GraalDirectives.injectBranchProbability(0.25, fromIndex >= sourceCount)) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (GraalDirectives.injectBranchProbability(0.25, fromIndex < 0)) {
            fromIndex = 0;
        }
        if (GraalDirectives.injectBranchProbability(0.25, targetCount == 0)) {
            return fromIndex;
        }
        int totalOffset = sourceOffset + fromIndex;
        if (GraalDirectives.injectBranchProbability(0.25, sourceCount - fromIndex < targetCount)) {
            return -1;
        }
        if (GraalDirectives.injectBranchProbability(0.25, targetCount == 1)) {
            return AMD64ArrayIndexOf.indexOf1Char(source, sourceCount, totalOffset, target[targetOffset]);
        }
        int haystackLength = sourceCount - (targetCount - 2);
        while (GraalDirectives.injectBranchProbability(0.75, totalOffset < haystackLength)) {
            Word targetPointer;
            int indexOfResult = AMD64ArrayIndexOf.indexOfTwoConsecutiveChars(source, haystackLength, totalOffset, target[targetOffset], target[targetOffset + 1]);
            if (GraalDirectives.injectBranchProbability(0.25, indexOfResult < 0)) {
                return -1;
            }
            totalOffset = indexOfResult;
            if (GraalDirectives.injectBranchProbability(0.25, targetCount == 2)) {
                return totalOffset;
            }
            Word cmpSourcePointer = Word.objectToTrackedPointer(source).add(ReplacementsUtil.charArrayBaseOffset(INJECTED)).add(totalOffset * ReplacementsUtil.charArrayIndexScale(INJECTED));
            if (GraalDirectives.injectBranchProbability(0.25, ArrayRegionEqualsNode.regionEquals(cmpSourcePointer, targetPointer = Word.objectToTrackedPointer(target).add(ReplacementsUtil.charArrayBaseOffset(INJECTED)).add(targetOffset * ReplacementsUtil.charArrayIndexScale(INJECTED)), targetCount, JavaKind.Char))) {
                return totalOffset;
            }
            ++totalOffset;
        }
        return -1;
    }

    @MethodSubstitution(isStatic=false, optional=true)
    public static int indexOf(String source, int ch, int origFromIndex) {
        int fromIndex = origFromIndex;
        int sourceCount = source.length();
        if (GraalDirectives.injectBranchProbability(0.25, fromIndex >= sourceCount)) {
            return -1;
        }
        if (GraalDirectives.injectBranchProbability(0.25, fromIndex < 0)) {
            fromIndex = 0;
        }
        if (GraalDirectives.injectBranchProbability(0.75, ch < 65536)) {
            char[] sourceArray = StringSubstitutions.getValue(source);
            return AMD64ArrayIndexOf.indexOf1Char(sourceArray, sourceCount, fromIndex, (char)ch);
        }
        return AMD64StringSubstitutions.indexOf(source, ch, origFromIndex);
    }

    @MethodSubstitution(isStatic=false)
    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"}, justification="reference equality on the receiver is what we want")
    public static int compareTo(String receiver, String anotherString) {
        if (receiver == anotherString) {
            return 0;
        }
        char[] value = StringSubstitutions.getValue(receiver);
        char[] other = StringSubstitutions.getValue(anotherString);
        return ArrayCompareToNode.compareTo(value, other, value.length << 1, other.length << 1, JavaKind.Char, JavaKind.Char);
    }
}

