/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import java.lang.reflect.Type;
import java.util.Arrays;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.lir.amd64.AMD64ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.PauseNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.java.AtomicReadAndAddNode;
import org.graalvm.compiler.nodes.java.AtomicReadAndWriteNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.IndexAddressNode;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.replacements.ArraysSubstitutions;
import org.graalvm.compiler.replacements.StandardGraphBuilderPlugins;
import org.graalvm.compiler.replacements.TargetGraphBuilderPlugins;
import org.graalvm.compiler.replacements.amd64.AMD64IntegerSubstitutions;
import org.graalvm.compiler.replacements.amd64.AMD64LongSubstitutions;
import org.graalvm.compiler.replacements.amd64.AMD64RoundNode;
import org.graalvm.compiler.replacements.amd64.AMD64StringLatin1Substitutions;
import org.graalvm.compiler.replacements.amd64.AMD64StringSubstitutions;
import org.graalvm.compiler.replacements.amd64.AMD64StringUTF16Substitutions;
import org.graalvm.compiler.replacements.nodes.ArrayCompareToNode;
import org.graalvm.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.BitCountNode;
import org.graalvm.compiler.replacements.nodes.FusedMultiplyAddNode;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import sun.misc.Unsafe;

public class AMD64GraphBuilderPlugins
implements TargetGraphBuilderPlugins {
    @Override
    public void register(GraphBuilderConfiguration.Plugins plugins, Replacements replacements, Architecture architecture, boolean explicitUnsafeNullChecks, boolean registerForeignCallMath, boolean emitJDK9StringSubstitutions, boolean useFMAIntrinsics) {
        AMD64GraphBuilderPlugins.register(plugins, replacements, (AMD64)architecture, explicitUnsafeNullChecks, emitJDK9StringSubstitutions, useFMAIntrinsics);
    }

    public static void register(GraphBuilderConfiguration.Plugins plugins, final Replacements replacements, final AMD64 arch, final boolean explicitUnsafeNullChecks, final boolean emitJDK9StringSubstitutions, final boolean useFMAIntrinsics) {
        final InvocationPlugins invocationPlugins = plugins.getInvocationPlugins();
        invocationPlugins.defer(new Runnable(){

            @Override
            public void run() {
                AMD64GraphBuilderPlugins.registerThreadPlugins(invocationPlugins, arch);
                AMD64GraphBuilderPlugins.registerIntegerLongPlugins(invocationPlugins, AMD64IntegerSubstitutions.class, JavaKind.Int, arch, replacements);
                AMD64GraphBuilderPlugins.registerIntegerLongPlugins(invocationPlugins, AMD64LongSubstitutions.class, JavaKind.Long, arch, replacements);
                StandardGraphBuilderPlugins.registerPlatformSpecificUnsafePlugins(invocationPlugins, replacements, explicitUnsafeNullChecks, new JavaKind[]{JavaKind.Int, JavaKind.Long, JavaKind.Object, JavaKind.Boolean, JavaKind.Byte, JavaKind.Short, JavaKind.Char, JavaKind.Float, JavaKind.Double});
                AMD64GraphBuilderPlugins.registerUnsafePlugins(invocationPlugins, replacements, explicitUnsafeNullChecks);
                AMD64GraphBuilderPlugins.registerStringPlugins(invocationPlugins, replacements);
                if (emitJDK9StringSubstitutions) {
                    AMD64GraphBuilderPlugins.registerStringLatin1Plugins(invocationPlugins, replacements);
                    AMD64GraphBuilderPlugins.registerStringUTF16Plugins(invocationPlugins, replacements);
                }
                AMD64GraphBuilderPlugins.registerMathPlugins(invocationPlugins, useFMAIntrinsics, arch, replacements);
                AMD64GraphBuilderPlugins.registerArraysEqualsPlugins(invocationPlugins, replacements);
            }
        });
    }

    private static void registerThreadPlugins(InvocationPlugins plugins, AMD64 arch) {
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            assert (arch.getFeatures().contains(AMD64.CPUFeature.SSE2));
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Thread.class));
            r.register0("onSpinWait", new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    b.append(new PauseNode());
                    return true;
                }
            });
        }
    }

    private static void registerIntegerLongPlugins(InvocationPlugins plugins, Class<?> substituteDeclaringClass, JavaKind kind, AMD64 arch, Replacements replacements) {
        Class declaringClass = kind.toBoxedJavaClass();
        Class type = kind.toJavaClass();
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, declaringClass, replacements);
        r.registerMethodSubstitution(substituteDeclaringClass, "numberOfLeadingZeros", type);
        r.registerMethodSubstitution(substituteDeclaringClass, "numberOfTrailingZeros", type);
        r.registerConditional1(arch.getFeatures().contains(AMD64.CPUFeature.POPCNT), "bitCount", type, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Int, b.append((ValueNode)new BitCountNode(value).canonical(null)));
                return true;
            }
        });
    }

    private static void registerMathPlugins(InvocationPlugins plugins, boolean useFMAIntrinsics, AMD64 arch, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Math.class), replacements);
        AMD64GraphBuilderPlugins.registerUnaryMath(r, "log", UnaryMathIntrinsicNode.UnaryOperation.LOG);
        AMD64GraphBuilderPlugins.registerUnaryMath(r, "log10", UnaryMathIntrinsicNode.UnaryOperation.LOG10);
        AMD64GraphBuilderPlugins.registerUnaryMath(r, "exp", UnaryMathIntrinsicNode.UnaryOperation.EXP);
        AMD64GraphBuilderPlugins.registerBinaryMath(r, "pow", BinaryMathIntrinsicNode.BinaryOperation.POW);
        AMD64GraphBuilderPlugins.registerUnaryMath(r, "sin", UnaryMathIntrinsicNode.UnaryOperation.SIN);
        AMD64GraphBuilderPlugins.registerUnaryMath(r, "cos", UnaryMathIntrinsicNode.UnaryOperation.COS);
        AMD64GraphBuilderPlugins.registerUnaryMath(r, "tan", UnaryMathIntrinsicNode.UnaryOperation.TAN);
        boolean roundEnabled = arch.getFeatures().contains(AMD64.CPUFeature.SSE4_1);
        AMD64GraphBuilderPlugins.registerRound(roundEnabled, r, "rint", AMD64ArithmeticLIRGeneratorTool.RoundingMode.NEAREST);
        AMD64GraphBuilderPlugins.registerRound(roundEnabled, r, "ceil", AMD64ArithmeticLIRGeneratorTool.RoundingMode.UP);
        AMD64GraphBuilderPlugins.registerRound(roundEnabled, r, "floor", AMD64ArithmeticLIRGeneratorTool.RoundingMode.DOWN);
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            AMD64GraphBuilderPlugins.registerFMA(r, useFMAIntrinsics && arch.getFeatures().contains(AMD64.CPUFeature.FMA));
        }
    }

    private static void registerFMA(InvocationPlugins.Registration r, boolean isEnabled) {
        r.registerConditional3(isEnabled, "fma", Double.TYPE, Double.TYPE, Double.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode na, ValueNode nb, ValueNode nc) {
                b.push(JavaKind.Double, b.append(new FusedMultiplyAddNode(na, nb, nc)));
                return true;
            }
        });
        r.registerConditional3(isEnabled, "fma", Float.TYPE, Float.TYPE, Float.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode na, ValueNode nb, ValueNode nc) {
                b.push(JavaKind.Float, b.append(new FusedMultiplyAddNode(na, nb, nc)));
                return true;
            }
        });
    }

    private static void registerUnaryMath(InvocationPlugins.Registration r, String name, final UnaryMathIntrinsicNode.UnaryOperation operation) {
        r.register1(name, Double.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Double, b.append(UnaryMathIntrinsicNode.create(value, operation)));
                return true;
            }
        });
    }

    private static void registerBinaryMath(InvocationPlugins.Registration r, String name, final BinaryMathIntrinsicNode.BinaryOperation operation) {
        r.register2(name, Double.TYPE, Double.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                b.push(JavaKind.Double, b.append(BinaryMathIntrinsicNode.create(x, y, operation)));
                return true;
            }
        });
    }

    private static void registerRound(boolean isEnabled, InvocationPlugins.Registration r, String name, final AMD64ArithmeticLIRGeneratorTool.RoundingMode mode) {
        r.registerConditional1(isEnabled, name, Double.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                b.push(JavaKind.Double, b.append(new AMD64RoundNode(arg, mode)));
                return true;
            }
        });
    }

    private static void registerStringPlugins(InvocationPlugins plugins, Replacements replacements) {
        if (JavaVersionUtil.JAVA_SPEC <= 8) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)String.class), replacements);
            r.setAllowOverwrite(true);
            r.registerMethodSubstitution(AMD64StringSubstitutions.class, "indexOf", new Type[]{char[].class, Integer.TYPE, Integer.TYPE, char[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE});
            r.registerMethodSubstitution(AMD64StringSubstitutions.class, "indexOf", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE, Integer.TYPE});
            r.registerMethodSubstitution(AMD64StringSubstitutions.class, "compareTo", new Type[]{InvocationPlugin.Receiver.class, String.class});
        }
    }

    private static void registerStringLatin1Plugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.lang.StringLatin1", replacements);
        r.setAllowOverwrite(true);
        r.register2("compareTo", (Type)((Object)byte[].class), (Type)((Object)byte[].class), new ArrayCompareToPlugin(JavaKind.Byte, JavaKind.Byte));
        r.register2("compareToUTF16", (Type)((Object)byte[].class), (Type)((Object)byte[].class), new ArrayCompareToPlugin(JavaKind.Byte, JavaKind.Char));
        r.registerMethodSubstitution(AMD64StringLatin1Substitutions.class, "inflate", new Type[]{byte[].class, Integer.TYPE, char[].class, Integer.TYPE, Integer.TYPE});
        r.registerMethodSubstitution(AMD64StringLatin1Substitutions.class, "inflate", new Type[]{byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE});
        r.registerMethodSubstitution(AMD64StringLatin1Substitutions.class, "indexOf", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE});
        r.registerMethodSubstitution(AMD64StringLatin1Substitutions.class, "indexOf", new Type[]{byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE});
    }

    private static void registerStringUTF16Plugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.lang.StringUTF16", replacements);
        r.setAllowOverwrite(true);
        r.register2("compareTo", (Type)((Object)byte[].class), (Type)((Object)byte[].class), new ArrayCompareToPlugin(JavaKind.Char, JavaKind.Char));
        r.register2("compareToLatin1", (Type)((Object)byte[].class), (Type)((Object)byte[].class), new ArrayCompareToPlugin(JavaKind.Char, JavaKind.Byte, true));
        r.registerMethodSubstitution(AMD64StringUTF16Substitutions.class, "compress", new Type[]{char[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE});
        r.registerMethodSubstitution(AMD64StringUTF16Substitutions.class, "compress", new Type[]{byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE});
        r.registerMethodSubstitution(AMD64StringUTF16Substitutions.class, "indexOfCharUnsafe", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        r.registerMethodSubstitution(AMD64StringUTF16Substitutions.class, "indexOfUnsafe", new Type[]{byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE});
        r.registerMethodSubstitution(AMD64StringUTF16Substitutions.class, "indexOfLatin1Unsafe", new Type[]{byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE});
        InvocationPlugins.Registration r2 = new InvocationPlugins.Registration(plugins, (Type)((Object)AMD64StringUTF16Substitutions.class), replacements);
        r2.register2("getChar", (Type)((Object)byte[].class), Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                b.addPush(JavaKind.Char, new JavaReadNode(JavaKind.Char, (AddressNode)new IndexAddressNode(arg1, new LeftShiftNode(arg2, ConstantNode.forInt(1)), JavaKind.Byte), NamedLocationIdentity.getArrayLocation(JavaKind.Byte), OnHeapMemoryAccess.BarrierType.NONE, false));
                return true;
            }
        });
    }

    private static void registerUnsafePlugins(InvocationPlugins plugins, Replacements replacements, boolean explicitUnsafeNullChecks) {
        AMD64GraphBuilderPlugins.registerUnsafePlugins(new InvocationPlugins.Registration(plugins, (Type)((Object)Unsafe.class)), explicitUnsafeNullChecks, new JavaKind[]{JavaKind.Int, JavaKind.Long, JavaKind.Object}, true);
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.misc.Unsafe", replacements);
            AMD64GraphBuilderPlugins.registerUnsafePlugins(r, explicitUnsafeNullChecks, new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long, JavaKind.Object}, JavaVersionUtil.JAVA_SPEC <= 11);
            AMD64GraphBuilderPlugins.registerUnsafeUnalignedPlugins(r, explicitUnsafeNullChecks);
        }
    }

    private static void registerUnsafeUnalignedPlugins(InvocationPlugins.Registration r, boolean explicitUnsafeNullChecks) {
        for (JavaKind kind : new JavaKind[]{JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long}) {
            Class javaClass = kind.toJavaClass();
            r.registerOptional3("get" + kind.name() + "Unaligned", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, new StandardGraphBuilderPlugins.UnsafeGetPlugin(kind, explicitUnsafeNullChecks));
            r.registerOptional4("put" + kind.name() + "Unaligned", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, javaClass, new StandardGraphBuilderPlugins.UnsafePutPlugin(kind, explicitUnsafeNullChecks));
        }
    }

    private static void registerUnsafePlugins(InvocationPlugins.Registration r, boolean explicitUnsafeNullChecks, JavaKind[] unsafeJavaKinds, boolean java11OrEarlier) {
        for (final JavaKind kind : unsafeJavaKinds) {
            Class javaClass = kind == JavaKind.Object ? Object.class : kind.toJavaClass();
            String kindName = kind == JavaKind.Object && !java11OrEarlier ? "Reference" : kind.name();
            r.register4("getAndSet" + kindName, (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, javaClass, new StandardGraphBuilderPlugins.UnsafeAccessPlugin(kind, explicitUnsafeNullChecks){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode object, ValueNode offset, ValueNode value) {
                    unsafe.get();
                    this.createUnsafeAccess(object, b, (obj, loc) -> new AtomicReadAndWriteNode(obj, offset, value, kind, loc));
                    return true;
                }
            });
            if (kind == JavaKind.Boolean || !kind.isNumericInteger()) continue;
            r.register4("getAndAdd" + kindName, (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, javaClass, new StandardGraphBuilderPlugins.UnsafeAccessPlugin(kind, explicitUnsafeNullChecks){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode object, ValueNode offset, ValueNode delta) {
                    unsafe.get();
                    this.createUnsafeAccess(object, b, (obj, loc) -> new AtomicReadAndAddNode(obj, offset, delta, kind, loc));
                    return true;
                }
            });
        }
    }

    private static void registerArraysEqualsPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Arrays.class), replacements);
        r.registerMethodSubstitution(ArraysSubstitutions.class, "equals", new Type[]{float[].class, float[].class});
        r.registerMethodSubstitution(ArraysSubstitutions.class, "equals", new Type[]{double[].class, double[].class});
    }

    private static final class ArrayCompareToPlugin
    implements InvocationPlugin {
        private final JavaKind valueKind;
        private final JavaKind otherKind;
        private final boolean swapped;

        private ArrayCompareToPlugin(JavaKind valueKind, JavaKind otherKind, boolean swapped) {
            this.valueKind = valueKind;
            this.otherKind = otherKind;
            this.swapped = swapped;
        }

        private ArrayCompareToPlugin(JavaKind valueKind, JavaKind otherKind) {
            this(valueKind, otherKind, false);
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value, ValueNode other) {
            ArrayLengthNode valueLength = b.add(new ArrayLengthNode(value));
            ArrayLengthNode otherLength = b.add(new ArrayLengthNode(other));
            if (this.swapped) {
                b.addPush(JavaKind.Int, new ArrayCompareToNode(other, value, otherLength, valueLength, this.valueKind, this.otherKind));
            } else {
                b.addPush(JavaKind.Int, new ArrayCompareToNode(value, other, valueLength, otherLength, this.valueKind, this.otherKind));
            }
            return true;
        }
    }
}

