/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.amd64.AMD64FloatConvertNode;
import org.graalvm.word.LocationIdentity;

public class AMD64ConvertSnippets
implements Snippets {
    @Snippet
    public static int f2i(float input, int result) {
        if (BranchProbabilityNode.probability(0.010000000000000009, result == Integer.MIN_VALUE)) {
            if (Float.isNaN(input)) {
                return 0;
            }
            if (input > 0.0f) {
                return Integer.MAX_VALUE;
            }
        }
        return result;
    }

    @Snippet
    public static long f2l(float input, long result) {
        if (BranchProbabilityNode.probability(0.010000000000000009, result == Long.MIN_VALUE)) {
            if (Float.isNaN(input)) {
                return 0L;
            }
            if (input > 0.0f) {
                return Long.MAX_VALUE;
            }
        }
        return result;
    }

    @Snippet
    public static int d2i(double input, int result) {
        if (BranchProbabilityNode.probability(0.010000000000000009, result == Integer.MIN_VALUE)) {
            if (Double.isNaN(input)) {
                return 0;
            }
            if (input > 0.0) {
                return Integer.MAX_VALUE;
            }
        }
        return result;
    }

    @Snippet
    public static long d2l(double input, long result) {
        if (BranchProbabilityNode.probability(0.010000000000000009, result == Long.MIN_VALUE)) {
            if (Double.isNaN(input)) {
                return 0L;
            }
            if (input > 0.0) {
                return Long.MAX_VALUE;
            }
        }
        return result;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo f2i = this.snippet(AMD64ConvertSnippets.class, "f2i", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo f2l = this.snippet(AMD64ConvertSnippets.class, "f2l", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo d2i = this.snippet(AMD64ConvertSnippets.class, "d2i", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo d2l = this.snippet(AMD64ConvertSnippets.class, "d2l", new LocationIdentity[0]);

        public Templates(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, TargetDescription target) {
            super(options, factories, providers, snippetReflection, target);
        }

        public void lower(FloatConvertNode convert, LoweringTool tool) {
            SnippetTemplate.SnippetInfo key;
            switch (convert.getFloatConvert()) {
                case F2I: {
                    key = this.f2i;
                    break;
                }
                case F2L: {
                    key = this.f2l;
                    break;
                }
                case D2I: {
                    key = this.d2i;
                    break;
                }
                case D2L: {
                    key = this.d2l;
                    break;
                }
                default: {
                    return;
                }
            }
            StructuredGraph graph = convert.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(key, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("input", convert.getValue());
            args.add("result", graph.unique(new AMD64FloatConvertNode(convert.getFloatConvert(), convert.getValue())));
            SnippetTemplate template = this.template(convert, args);
            convert.getDebug().log("Lowering %s in %s: node=%s, template=%s, arguments=%s", (Object)convert.getFloatConvert(), (Object)graph, (Object)convert, (Object)template, (Object)args);
            template.instantiate(this.providers.getMetaAccess(), convert, SnippetTemplate.DEFAULT_REPLACER, tool, args);
            convert.safeDelete();
        }
    }
}

