/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.replacements.nodes.ArrayEqualsNode;

@ClassSubstitution(value=String.class)
public class StringSubstitutions {
    @MethodSubstitution(isStatic=false)
    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"}, justification="reference equality on the receiver is what we want")
    public static boolean equals(String thisString, Object obj) {
        if (thisString == obj) {
            return true;
        }
        if (!(obj instanceof String)) {
            return false;
        }
        String thatString = (String)obj;
        if (thisString.length() != thatString.length()) {
            return false;
        }
        if (thisString.length() == 0) {
            return true;
        }
        char[] array1 = StringSubstitutions.getValue(thisString);
        char[] array2 = StringSubstitutions.getValue(thatString);
        return ArrayEqualsNode.equals(array1, array2, array1.length);
    }

    public static native char[] getValue(String var0);
}

