/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ValueNode;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate", size=NodeSize.SIZE_UNKNOWN, sizeRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate")
public class PartialIntrinsicCallTargetNode
extends CallTargetNode
implements IterableNodeType {
    public static final NodeClass<PartialIntrinsicCallTargetNode> TYPE = NodeClass.create(PartialIntrinsicCallTargetNode.class);
    private final String targetName;

    public PartialIntrinsicCallTargetNode(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod target, StampPair returnStamp, ValueNode ... arguments) {
        super(TYPE, arguments, null, invokeKind, returnStamp);
        this.targetName = PartialIntrinsicCallTargetNode.format(target);
    }

    @Override
    public String targetName() {
        return this.targetName;
    }

    public boolean checkName(ResolvedJavaMethod original) {
        assert (this.targetName.equals(PartialIntrinsicCallTargetNode.format(original))) : "expected " + this.targetName + " but got " + PartialIntrinsicCallTargetNode.format(original);
        return true;
    }

    private static String format(ResolvedJavaMethod method) {
        return method.format("%H.%n(%p)");
    }
}

