/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.util.EnumMap;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.FieldLocationIdentity;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.extended.AbstractBoxingNode;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.extended.UnboxNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public class BoxingSnippets
implements Snippets {
    @Snippet
    public static Object booleanValueOf(boolean value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static Object byteValueOf(byte value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static Object charValueOf(char value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(Character.valueOf(value));
    }

    @Snippet
    public static Object doubleValueOf(double value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static Object floatValueOf(float value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(Float.valueOf(value));
    }

    @Snippet
    public static Object intValueOf(int value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static Object longValueOf(long value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static Object shortValueOf(short value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static boolean booleanValue(Boolean value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    @Snippet
    public static byte byteValue(Byte value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    @Snippet
    public static char charValue(Character value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value.charValue();
    }

    @Snippet
    public static double doubleValue(Double value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    @Snippet
    public static float floatValue(Float value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value.floatValue();
    }

    @Snippet
    public static int intValue(Integer value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    @Snippet
    public static long longValue(Long value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    @Snippet
    public static short shortValue(Short value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final EnumMap<JavaKind, SnippetTemplate.SnippetInfo> boxSnippets = new EnumMap(JavaKind.class);
        private final EnumMap<JavaKind, SnippetTemplate.SnippetInfo> unboxSnippets = new EnumMap(JavaKind.class);
        private final SnippetCounter valueOfCounter;
        private final SnippetCounter valueCounter;

        public Templates(OptionValues options, Iterable<DebugHandlersFactory> factories, SnippetCounter.Group.Factory factory, Providers providers, SnippetReflectionProvider snippetReflection, TargetDescription target) {
            super(options, factories, providers, snippetReflection, target);
            for (JavaKind kind : new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Double, JavaKind.Float, JavaKind.Int, JavaKind.Long, JavaKind.Short}) {
                FieldLocationIdentity accessedLocation = null;
                LocationIdentity cacheLocation = null;
                switch (kind) {
                    case Byte: 
                    case Short: 
                    case Char: 
                    case Int: 
                    case Long: {
                        accessedLocation = new FieldLocationIdentity(AbstractBoxingNode.getValueField(providers.getMetaAccess().lookupJavaType(kind.toBoxedJavaClass())));
                        cacheLocation = Templates.getCacheLocation(providers, kind);
                        break;
                    }
                    case Boolean: 
                    case Float: 
                    case Double: {
                        accessedLocation = new FieldLocationIdentity(AbstractBoxingNode.getValueField(providers.getMetaAccess().lookupJavaType(kind.toBoxedJavaClass())));
                        break;
                    }
                    default: {
                        throw GraalError.unimplemented();
                    }
                }
                assert (accessedLocation != null);
                if (kind == JavaKind.Boolean) {
                    assert (cacheLocation == null);
                    FieldLocationIdentity trueField = null;
                    FieldLocationIdentity falseField = null;
                    for (ResolvedJavaField field : providers.getMetaAccess().lookupJavaType(kind.toBoxedJavaClass()).getStaticFields()) {
                        if (field.getName().equals("TRUE")) {
                            trueField = new FieldLocationIdentity(field);
                            continue;
                        }
                        if (!field.getName().equals("FALSE")) continue;
                        falseField = new FieldLocationIdentity(field);
                    }
                    this.boxSnippets.put(kind, this.snippet(BoxingSnippets.class, kind.getJavaName() + "ValueOf", trueField, falseField));
                } else if (cacheLocation != null) {
                    this.boxSnippets.put(kind, this.snippet(BoxingSnippets.class, kind.getJavaName() + "ValueOf", LocationIdentity.INIT_LOCATION, accessedLocation, cacheLocation, NamedLocationIdentity.getArrayLocation(JavaKind.Object)));
                } else {
                    this.boxSnippets.put(kind, this.snippet(BoxingSnippets.class, kind.getJavaName() + "ValueOf", LocationIdentity.INIT_LOCATION, accessedLocation, NamedLocationIdentity.getArrayLocation(JavaKind.Object)));
                }
                this.unboxSnippets.put(kind, this.snippet(BoxingSnippets.class, kind.getJavaName() + "Value", accessedLocation));
            }
            SnippetCounter.Group group = factory.createSnippetCounterGroup("Boxing");
            this.valueOfCounter = new SnippetCounter(group, "valueOf", "box intrinsification");
            this.valueCounter = new SnippetCounter(group, "<kind>Value", "unbox intrinsification");
        }

        private static LocationIdentity getCacheLocation(CoreProviders providers, JavaKind kind) {
            FieldLocationIdentity cacheLocation = null;
            Class<?>[] innerClasses = null;
            try {
                switch (kind) {
                    case Byte: {
                        innerClasses = Byte.class.getDeclaredClasses();
                        break;
                    }
                    case Short: {
                        innerClasses = Short.class.getDeclaredClasses();
                        break;
                    }
                    case Char: {
                        innerClasses = Character.class.getDeclaredClasses();
                        break;
                    }
                    case Int: {
                        innerClasses = Integer.class.getDeclaredClasses();
                        break;
                    }
                    case Long: {
                        innerClasses = Long.class.getDeclaredClasses();
                        break;
                    }
                }
            }
            catch (SecurityException e) {
                throw GraalError.shouldNotReachHere(e);
            }
            if (innerClasses != null && innerClasses.length > 0) {
                try {
                    cacheLocation = new FieldLocationIdentity(providers.getMetaAccess().lookupJavaField(innerClasses[0].getDeclaredField("cache")));
                }
                catch (NoSuchFieldException | SecurityException e) {
                    throw GraalError.shouldNotReachHere(e);
                }
            }
            return cacheLocation;
        }

        public void lower(BoxNode box, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.boxSnippets.get(box.getBoxingKind()), box.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("value", box.getValue());
            args.addConst("valueOfCounter", this.valueOfCounter);
            SnippetTemplate template = this.template(box, args);
            box.getDebug().log("Lowering integerValueOf in %s: node=%s, template=%s, arguments=%s", box.graph(), (Object)box, (Object)template, (Object)args);
            template.instantiate(this.providers.getMetaAccess(), box, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(UnboxNode unbox, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.unboxSnippets.get(unbox.getBoxingKind()), unbox.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("value", unbox.getValue());
            args.addConst("valueCounter", this.valueCounter);
            SnippetTemplate template = this.template(unbox, args);
            unbox.getDebug().log("Lowering integerValueOf in %s: node=%s, template=%s, arguments=%s", unbox.graph(), (Object)unbox, (Object)template, (Object)args);
            template.instantiate(this.providers.getMetaAccess(), unbox, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

