/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.printer;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.BytecodeDisassembler;
import org.graalvm.compiler.core.common.alloc.Trace;
import org.graalvm.compiler.core.common.alloc.TraceBuilderResult;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.gen.NodeLIRBuilder;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.Position;
import org.graalvm.compiler.java.BciBlockMapping;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.debug.IntervalDumper;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.printer.CompilationPrinter;

class CFGPrinter
extends CompilationPrinter {
    protected TargetDescription target;
    protected LIR lir;
    protected NodeLIRBuilder nodeLirGenerator;
    protected ControlFlowGraph cfg;
    protected StructuredGraph.ScheduleResult schedule;
    protected ResolvedJavaMethod method;
    protected LIRGenerationResult res;
    private NodeMap<Block> latestScheduling;
    private NodeBitMap printedNodes;
    IntervalDumper.IntervalVisitor intervalVisitor = new IntervalDumper.IntervalVisitor(){

        String getFormattedOperand(Value operand) {
            String s = operand.toString();
            int last = s.lastIndexOf(124);
            if (last != -1) {
                return s.substring(0, last) + "|" + operand.getPlatformKind().getTypeChar();
            }
            return s;
        }

        @Override
        public void visitIntervalStart(Value parentOperand, Value splitOperand, Value location, Value hint, String typeName) {
            CFGPrinter.this.out.printf("%s %s ", this.getFormattedOperand(splitOperand), typeName);
            if (location != null) {
                CFGPrinter.this.out.printf("\"[%s]\"", this.getFormattedOperand(location));
            } else {
                CFGPrinter.this.out.printf("\"[%s]\"", this.getFormattedOperand(splitOperand));
            }
            CFGPrinter.this.out.printf(" %s %s ", this.getFormattedOperand(parentOperand), hint != null ? this.getFormattedOperand(hint) : Integer.valueOf(-1));
        }

        @Override
        public void visitRange(int from, int to) {
            CFGPrinter.this.out.printf("[%d, %d[", from, to);
        }

        @Override
        public void visitUsePos(int usePos, Object registerPriority) {
            CFGPrinter.this.out.printf("%d %s ", usePos, registerPriority);
        }

        @Override
        public void visitIntervalEnd(Object spillState) {
            CFGPrinter.this.out.printf(" \"%s\"", spillState);
            CFGPrinter.this.out.println();
        }
    };

    CFGPrinter(OutputStream out) {
        super(out);
    }

    public void printCFG(String label, BciBlockMapping blockMap) {
        this.begin("cfg");
        this.out.print("name \"").print(label).println('\"');
        for (BciBlockMapping.BciBlock block : blockMap.getBlocks()) {
            this.begin("block");
            this.printBlock(block);
            this.end("block");
        }
        this.end("cfg");
    }

    private void printBlock(BciBlockMapping.BciBlock block) {
        this.out.print("name \"B").print(block.getStartBci()).println('\"');
        this.out.print("from_bci ").println(block.getStartBci());
        this.out.print("to_bci ").println(block.getEndBci());
        this.out.println("predecessors ");
        this.out.print("successors ");
        for (BciBlockMapping.BciBlock succ : block.getSuccessors()) {
            if (succ.isExceptionEntry()) continue;
            this.out.print("\"B").print(succ.getStartBci()).print("\" ");
        }
        this.out.println();
        this.out.print("xhandlers");
        for (BciBlockMapping.BciBlock succ : block.getSuccessors()) {
            if (!succ.isExceptionEntry()) continue;
            this.out.print("\"B").print(succ.getStartBci()).print("\" ");
        }
        this.out.println();
        this.out.print("flags ");
        if (block.isExceptionEntry()) {
            this.out.print("\"ex\" ");
        }
        if (block.isLoopHeader()) {
            this.out.print("\"plh\" ");
        }
        this.out.println();
        this.out.print("loop_depth ").println(Long.bitCount(block.getLoops()));
    }

    private boolean inFixedSchedule(Node node) {
        return this.lir != null || this.schedule != null || node.isDeleted() || this.cfg.getNodeToBlock().get(node) != null;
    }

    public void printCFG(String label, AbstractBlockBase<?>[] blocks, boolean printNodes) {
        if (this.lir == null) {
            this.latestScheduling = new NodeMap<Block>(this.cfg.getNodeToBlock());
            block0: for (AbstractBlockBase<?> abstractBlock : blocks) {
                if (abstractBlock == null) continue;
                Block block = (Block)abstractBlock;
                Node cur = block.getBeginNode();
                while (true) {
                    assert (this.inFixedSchedule(cur) && this.latestScheduling.get(cur) == block);
                    this.scheduleInputs(cur, block);
                    if (cur == block.getEndNode()) continue block0;
                    assert (cur.successors().count() == 1);
                    cur = cur.successors().first();
                }
            }
        }
        this.begin("cfg");
        this.out.print("name \"").print(label).println('\"');
        for (AbstractBlockBase<?> block : blocks) {
            this.printBlock(block, printNodes);
        }
        this.end("cfg");
        if (this.method != null) {
            this.printBytecodes(new BytecodeDisassembler(false).disassemble(this.method));
        }
        this.latestScheduling = null;
    }

    private void scheduleInputs(Node node, Block nodeBlock) {
        if (node instanceof ValuePhiNode) {
            PhiNode phi = (PhiNode)node;
            Block phiBlock = this.latestScheduling.get(phi.merge());
            assert (phiBlock != null);
            for (Block pred : (Block[])phiBlock.getPredecessors()) {
                this.schedule(phi.valueAt((AbstractEndNode)pred.getEndNode()), pred);
            }
        } else {
            for (Node input : node.inputs()) {
                this.schedule(input, nodeBlock);
            }
        }
    }

    private void schedule(Node input, Block block) {
        if (!this.inFixedSchedule(input)) {
            Block inputBlock = block;
            if (this.latestScheduling.get(input) != null) {
                inputBlock = (Block)AbstractControlFlowGraph.commonDominatorTyped(inputBlock, (AbstractBlockBase)this.latestScheduling.get(input));
            }
            if (inputBlock != this.latestScheduling.get(input)) {
                this.latestScheduling.set(input, inputBlock);
                this.scheduleInputs(input, inputBlock);
            }
        }
    }

    private void printBlock(AbstractBlockBase<?> block, boolean printNodes) {
        if (block == null) {
            return;
        }
        this.printBlockProlog(block);
        if (printNodes) {
            assert (block instanceof Block);
            this.printNodes((Block)block);
        }
        this.printBlockEpilog(block);
    }

    private void printBlockEpilog(AbstractBlockBase<?> block) {
        this.printLIR(block);
        this.end("block");
    }

    private void printBlockProlog(AbstractBlockBase<?> block) {
        this.begin("block");
        this.out.print("name \"").print(this.blockToString(block)).println('\"');
        this.out.println("from_bci -1");
        this.out.println("to_bci -1");
        this.out.print("predecessors ");
        for (AbstractBlockBase pred : block.getPredecessors()) {
            this.out.print("\"").print(this.blockToString(pred)).print("\" ");
        }
        this.out.println();
        this.out.print("successors ");
        for (AbstractBlockBase succ : block.getSuccessors()) {
            if (succ.isExceptionEntry()) continue;
            this.out.print("\"").print(this.blockToString(succ)).print("\" ");
        }
        this.out.println();
        this.out.print("xhandlers");
        for (AbstractBlockBase succ : block.getSuccessors()) {
            if (!succ.isExceptionEntry()) continue;
            this.out.print("\"").print(this.blockToString(succ)).print("\" ");
        }
        this.out.println();
        this.out.print("flags ");
        if (block.isLoopHeader()) {
            this.out.print("\"llh\" ");
        }
        if (block.isLoopEnd()) {
            this.out.print("\"lle\" ");
        }
        if (block.isExceptionEntry()) {
            this.out.print("\"ex\" ");
        }
        this.out.println();
        if (block.getLoop() != null) {
            this.out.print("loop_index ").println(block.getLoop().getIndex());
            this.out.print("loop_depth ").println(block.getLoop().getDepth());
        }
        this.out.print("probability ").println(Double.doubleToRawLongBits(block.getRelativeFrequency()));
    }

    private void printNodes(Block block) {
        this.printedNodes = new NodeBitMap(this.cfg.graph);
        this.begin("IR");
        this.out.println("HIR");
        this.out.disableIndentation();
        if (block.getBeginNode() instanceof AbstractMergeNode) {
            for (ValueNode valueNode : ((AbstractMergeNode)block.getBeginNode()).phis()) {
                this.printNode(valueNode, false);
            }
        }
        Node cur = block.getBeginNode();
        while (true) {
            this.printNode(cur, false);
            if (cur == block.getEndNode()) {
                MapCursor<Node, Block> mapCursor = this.latestScheduling.getEntries();
                while (mapCursor.advance()) {
                    if (mapCursor.getValue() != block || this.inFixedSchedule((Node)mapCursor.getKey()) || this.printedNodes.isMarked((Node)mapCursor.getKey())) continue;
                    this.printNode((Node)mapCursor.getKey(), true);
                }
                break;
            }
            assert (cur.successors().count() == 1);
            cur = cur.successors().first();
        }
        this.out.enableIndentation();
        this.end("IR");
        this.printedNodes = null;
    }

    private void printNode(Node node, boolean unscheduled) {
        StateSplit stateSplit;
        assert (!this.printedNodes.isMarked(node));
        this.printedNodes.mark(node);
        if (!(node instanceof ValuePhiNode)) {
            for (Node input : node.inputs()) {
                if (this.inFixedSchedule(input) || this.printedNodes.isMarked(input)) continue;
                this.printNode(input, true);
            }
        }
        if (unscheduled) {
            assert (this.lir == null && this.schedule == null) : "unscheduled nodes can only be present before LIR generation";
            this.out.print("f ").print("<@").print("u").print("|@").print("unscheduled").print(">@").println(" <|@");
        } else if (node instanceof FixedWithNextNode) {
            this.out.print("f ").print("<@").print("#").print("|@").print("fixed with next").print(">@").println(" <|@");
        } else if (node instanceof FixedNode) {
            this.out.print("f ").print("<@").print("*").print("|@").print("fixed").print(">@").println(" <|@");
        } else if (node instanceof FloatingNode) {
            this.out.print("f ").print("<@").print("~").print("|@").print("floating").print(">@").println(" <|@");
        }
        this.out.print("tid ").print(this.nodeToString(node)).println(" <|@");
        if (this.nodeLirGenerator != null) {
            Value operand;
            Value value = operand = this.nodeLirGenerator.hasOperand(node) ? this.nodeLirGenerator.operand(node) : null;
            if (operand != null) {
                this.out.print("result ").print(operand.toString()).println(" <|@");
            }
        }
        if (node instanceof StateSplit && (stateSplit = (StateSplit)((Object)node)).stateAfter() != null) {
            String state = this.stateToString(stateSplit.stateAfter());
            this.out.print("st ").print("<@").print("st").print("|@").print(state).print(">@").println(" <|@");
        }
        TreeMap<Object, Object> props = new TreeMap<Object, Object>(node.getDebugProperties());
        this.out.print("d ").print("<@").print("d").print("|@");
        this.out.println("=== Debug Properties ===");
        for (Map.Entry entry : props.entrySet()) {
            this.out.print(entry.getKey().toString()).print(": ").print(entry.getValue() == null ? "[null]" : entry.getValue().toString()).println();
        }
        this.out.println("=== Inputs ===");
        this.printNamedNodes(node, node.inputPositions().iterator(), "", "\n", null);
        this.out.println("=== Succesors ===");
        this.printNamedNodes(node, node.successorPositions().iterator(), "", "\n", null);
        this.out.println("=== Usages ===");
        if (!node.hasNoUsages()) {
            for (Node usage : node.usages()) {
                this.out.print(this.nodeToString(usage)).print(" ");
            }
            this.out.println();
        }
        this.out.println("=== Predecessor ===");
        this.out.print(this.nodeToString(node.predecessor())).print(" ");
        this.out.print(">@").println(" <|@");
        this.out.print("instruction ");
        this.out.print("<@").print(node.getNodeClass().shortName()).print("|@").print(node.getClass().getName()).print(">@").print(" ");
        this.printNamedNodes(node, node.inputPositions().iterator(), "", "", "#NDF");
        this.printNamedNodes(node, node.successorPositions().iterator(), "#", "", "#NDF");
        for (Map.Entry entry : props.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("data.") || key.equals("data.stamp")) continue;
            this.out.print(key.substring("data.".length())).print(": ").print(entry.getValue() == null ? "[null]" : entry.getValue().toString()).print(" ");
        }
        this.out.print(" <|@").print(' ').println(" <|@");
    }

    private void printNamedNodes(Node node, Iterator<Position> iter, String prefix, String suffix, String hideSuffix) {
        int lastIndex = -1;
        while (iter.hasNext()) {
            Position pos = iter.next();
            if (hideSuffix != null && pos.getName().endsWith(hideSuffix)) continue;
            if (pos.getIndex() != lastIndex) {
                if (lastIndex != -1) {
                    this.out.print(suffix);
                }
                this.out.print(prefix).print(pos.getName()).print(": ");
                lastIndex = pos.getIndex();
            }
            this.out.print(this.nodeToString(pos.get(node))).print(" ");
        }
        if (lastIndex != -1) {
            this.out.print(suffix);
        }
    }

    private String stateToString(FrameState state) {
        StringBuilder buf = new StringBuilder();
        FrameState curState = state;
        do {
            int i;
            buf.append(Bytecode.toLocation(curState.getCode(), curState.bci)).append('\n');
            if (curState.stackSize() > 0) {
                buf.append("stack: ");
                for (i = 0; i < curState.stackSize(); ++i) {
                    buf.append(this.stateValueToString(curState.stackAt(i))).append(' ');
                }
                buf.append("\n");
            }
            buf.append("locals: ");
            for (i = 0; i < curState.localsSize(); ++i) {
                buf.append(this.stateValueToString(curState.localAt(i))).append(' ');
            }
            buf.append("\n");
            buf.append("locks: ");
            for (i = 0; i < curState.locksSize(); ++i) {
                buf.append(this.stateValueToString(curState.lockAt(i))).append(' ');
            }
            buf.append("\n");
        } while ((curState = curState.outerFrameState()) != null);
        return buf.toString();
    }

    private String stateValueToString(ValueNode value) {
        String result = this.nodeToString(value);
        if (this.nodeLirGenerator != null && value != null && this.nodeLirGenerator.hasOperand(value)) {
            Value operand = this.nodeLirGenerator.operand(value);
            assert (operand != null);
            result = result + ": " + operand;
        }
        return result;
    }

    private void printLIR(AbstractBlockBase<?> block) {
        if (this.lir == null) {
            return;
        }
        ArrayList<LIRInstruction> lirInstructions = this.lir.getLIRforBlock(block);
        if (lirInstructions == null) {
            return;
        }
        this.begin("IR");
        this.out.println("LIR");
        for (int i = 0; i < lirInstructions.size(); ++i) {
            LIRInstruction inst = lirInstructions.get(i);
            this.printLIRInstruction(inst);
        }
        this.end("IR");
    }

    private void printLIRInstruction(LIRInstruction inst) {
        if (inst == null) {
            this.out.print("nr   -1 ").print(" <|@").print(" instruction ").print("<deleted>").print(" <|@");
            this.out.println(" <|@");
        } else {
            this.out.printf("nr %4d ", inst.id()).print(" <|@");
            StringBuilder stateString = new StringBuilder();
            inst.forEachState(state -> {
                if (state.hasDebugInfo()) {
                    DebugInfo di = state.debugInfo();
                    stateString.append(this.debugInfoToString(di.getBytecodePosition(), di.getReferenceMap(), state.getLiveBasePointers(), di.getCalleeSaveInfo()));
                } else {
                    stateString.append(this.debugInfoToString((BytecodePosition)state.topFrame, null, state.getLiveBasePointers(), null));
                }
            });
            if (stateString.length() > 0) {
                int level = this.out.indentationLevel();
                this.out.adjustIndentation(-level);
                this.out.print(" st ").print("<@").print("st").print("|@").print(stateString.toString()).print(">@").print(" <|@");
                this.out.adjustIndentation(level);
            }
            this.out.print(" instruction ").print(inst.toString(this.res)).print(" <|@");
            this.out.println(" <|@");
        }
    }

    private String nodeToString(Node node) {
        ValueNode value;
        if (node == null) {
            return "-";
        }
        String prefix = node instanceof AbstractBeginNode && this.lir == null && this.schedule == null ? "B" : (node instanceof ValueNode ? ((value = (ValueNode)node).getStackKind() == JavaKind.Illegal ? "v" : String.valueOf(Character.toLowerCase(value.getStackKind().getTypeChar()))) : "?");
        return prefix + node.toString(Verbosity.Id);
    }

    private String blockToString(AbstractBlockBase<?> block) {
        if (this.lir == null && this.schedule == null && block instanceof Block) {
            return "B" + ((Block)block).getBeginNode().toString(Verbosity.Id);
        }
        return "B" + block.getId();
    }

    public void printIntervals(String label, IntervalDumper intervals) {
        this.begin("intervals");
        this.out.println(String.format("name \"%s\"", label));
        intervals.visitIntervals(this.intervalVisitor);
        this.end("intervals");
    }

    public void printSchedule(String message, StructuredGraph.ScheduleResult theSchedule) {
        this.schedule = theSchedule;
        this.cfg = this.schedule.getCFG();
        this.printedNodes = new NodeBitMap(this.cfg.graph);
        this.begin("cfg");
        this.out.print("name \"").print(message).println('\"');
        for (Block b : this.schedule.getCFG().getBlocks()) {
            if (this.schedule.nodesFor(b) == null) continue;
            this.printScheduledBlock(b, this.schedule.nodesFor(b));
        }
        this.end("cfg");
        this.schedule = null;
        this.cfg = null;
        this.printedNodes = null;
    }

    private void printScheduledBlock(Block block, List<Node> nodesFor) {
        this.printBlockProlog(block);
        this.begin("IR");
        this.out.println("HIR");
        this.out.disableIndentation();
        if (block.getBeginNode() instanceof AbstractMergeNode) {
            for (ValueNode valueNode : ((AbstractMergeNode)block.getBeginNode()).phis()) {
                this.printNode(valueNode, false);
            }
        }
        for (Node node : nodesFor) {
            this.printNode(node, false);
        }
        this.out.enableIndentation();
        this.end("IR");
        this.printBlockEpilog(block);
    }

    public void printTraces(String label, TraceBuilderResult traces) {
        this.begin("cfg");
        this.out.print("name \"").print(label).println('\"');
        for (Trace trace : traces.getTraces()) {
            this.printTrace(trace, traces);
        }
        this.end("cfg");
    }

    private void printTrace(Trace trace, TraceBuilderResult traceBuilderResult) {
        this.printTraceProlog(trace, traceBuilderResult);
        this.printTraceInstructions(trace, traceBuilderResult);
        this.printTraceEpilog();
    }

    private void printTraceProlog(Trace trace, TraceBuilderResult traceBuilderResult) {
        this.begin("block");
        this.out.print("name \"").print(CFGPrinter.traceToString(trace)).println('\"');
        this.out.println("from_bci -1");
        this.out.println("to_bci -1");
        this.out.print("predecessors ");
        for (Trace pred : CFGPrinter.getPredecessors(trace, traceBuilderResult)) {
            this.out.print("\"").print(CFGPrinter.traceToString(pred)).print("\" ");
        }
        this.out.println();
        this.out.print("successors ");
        for (Trace succ : CFGPrinter.getSuccessors(trace, traceBuilderResult)) {
            this.out.print("\"").print(CFGPrinter.traceToString(succ)).print("\" ");
        }
        this.out.println();
        this.out.print("xhandlers");
        this.out.println();
        this.out.print("flags ");
        this.out.println();
    }

    private void printTraceInstructions(Trace trace, TraceBuilderResult traceBuilderResult) {
        if (this.lir == null) {
            return;
        }
        this.begin("IR");
        this.out.println("LIR");
        for (AbstractBlockBase<?> block : trace.getBlocks()) {
            ArrayList<LIRInstruction> lirInstructions = this.lir.getLIRforBlock(block);
            if (lirInstructions == null) continue;
            this.printBlockInstruction(block, traceBuilderResult);
            for (int i = 0; i < lirInstructions.size(); ++i) {
                LIRInstruction inst = lirInstructions.get(i);
                this.printLIRInstruction(inst);
            }
        }
        this.end("IR");
    }

    private void printBlockInstruction(AbstractBlockBase<?> block, TraceBuilderResult traceBuilderResult) {
        this.out.print("nr ").print(block.toString()).print(" <|@").print(" instruction ");
        if (block.getPredecessorCount() > 0) {
            this.out.print("<- ");
            this.printBlockListWithTrace(Arrays.asList(block.getPredecessors()), traceBuilderResult);
            this.out.print(" ");
        }
        if (block.getSuccessorCount() > 0) {
            this.out.print("-> ");
            this.printBlockListWithTrace(Arrays.asList(block.getSuccessors()), traceBuilderResult);
        }
        this.out.print(" <|@");
        this.out.println(" <|@");
    }

    private void printBlockListWithTrace(List<? extends AbstractBlockBase<?>> blocks, TraceBuilderResult traceBuilderResult) {
        Iterator<AbstractBlockBase<?>> it = blocks.iterator();
        this.printBlockWithTrace(it.next(), traceBuilderResult);
        while (it.hasNext()) {
            this.out.print(",");
            this.printBlockWithTrace(it.next(), traceBuilderResult);
        }
    }

    private void printBlockWithTrace(AbstractBlockBase<?> block, TraceBuilderResult traceBuilderResult) {
        this.out.print(block.toString());
        this.out.print("[T").print(traceBuilderResult.getTraceForBlock(block).getId()).print("]");
    }

    private void printTraceEpilog() {
        this.end("block");
    }

    private static boolean isLoopBackEdge(AbstractBlockBase<?> src, AbstractBlockBase<?> dst) {
        return dst.isLoopHeader() && dst.getLoop().equals(src.getLoop());
    }

    private static List<Trace> getSuccessors(Trace trace, TraceBuilderResult traceBuilderResult) {
        BitSet bs = new BitSet(traceBuilderResult.getTraces().size());
        for (AbstractBlockBase<?> block : trace.getBlocks()) {
            for (AbstractBlockBase s : block.getSuccessors()) {
                Trace otherTrace = traceBuilderResult.getTraceForBlock(s);
                int otherTraceId = otherTrace.getId();
                if (trace.getId() == otherTraceId && !CFGPrinter.isLoopBackEdge(block, s)) continue;
                bs.set(otherTraceId);
            }
        }
        ArrayList<Trace> succ = new ArrayList<Trace>();
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            succ.add(traceBuilderResult.getTraces().get(i));
            i = bs.nextSetBit(i + 1);
        }
        return succ;
    }

    private static List<Trace> getPredecessors(Trace trace, TraceBuilderResult traceBuilderResult) {
        BitSet bs = new BitSet(traceBuilderResult.getTraces().size());
        for (AbstractBlockBase<?> block : trace.getBlocks()) {
            for (AbstractBlockBase p : block.getPredecessors()) {
                Trace otherTrace = traceBuilderResult.getTraceForBlock(p);
                int otherTraceId = otherTrace.getId();
                if (trace.getId() == otherTraceId && !CFGPrinter.isLoopBackEdge(p, block)) continue;
                bs.set(traceBuilderResult.getTraceForBlock(p).getId());
            }
        }
        ArrayList<Trace> pred = new ArrayList<Trace>();
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            pred.add(traceBuilderResult.getTraces().get(i));
            i = bs.nextSetBit(i + 1);
        }
        return pred;
    }

    private static String traceToString(Trace trace) {
        return "T" + trace.getId();
    }
}

