/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.graph;

import java.util.ArrayDeque;
import java.util.Deque;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;

public abstract class StatelessPostOrderNodeIterator {
    private final NodeBitMap visitedEnds;
    private final Deque<AbstractBeginNode> nodeQueue;
    private final FixedNode start;

    public StatelessPostOrderNodeIterator(FixedNode start) {
        this.visitedEnds = start.graph().createNodeBitMap();
        this.nodeQueue = new ArrayDeque<AbstractBeginNode>();
        this.start = start;
    }

    public void apply() {
        FixedNode current = this.start;
        do {
            if (current instanceof LoopBeginNode) {
                this.loopBegin((LoopBeginNode)current);
                current = ((LoopBeginNode)current).next();
                assert (current != null);
                continue;
            }
            if (current instanceof LoopEndNode) {
                this.loopEnd((LoopEndNode)current);
                assert (!this.visitedEnds.isMarked(current));
                this.visitedEnds.mark(current);
                current = this.nodeQueue.pollFirst();
                continue;
            }
            if (current instanceof AbstractMergeNode) {
                this.merge((AbstractMergeNode)current);
                current = ((AbstractMergeNode)current).next();
                assert (current != null);
                continue;
            }
            if (current instanceof FixedWithNextNode) {
                this.node(current);
                current = ((FixedWithNextNode)current).next();
                continue;
            }
            if (current instanceof EndNode) {
                this.end((EndNode)current);
                this.queueMerge((EndNode)current);
                current = this.nodeQueue.pollFirst();
                continue;
            }
            if (current instanceof ControlSinkNode) {
                this.node(current);
                current = this.nodeQueue.pollFirst();
                continue;
            }
            if (current instanceof ControlSplitNode) {
                this.controlSplit((ControlSplitNode)current);
                for (Node node : current.successors()) {
                    this.nodeQueue.addFirst((AbstractBeginNode)node);
                }
                current = this.nodeQueue.pollFirst();
                continue;
            }
            assert (false) : current;
        } while (current != null);
        this.finished();
    }

    private void queueMerge(EndNode end) {
        assert (!this.visitedEnds.isMarked(end));
        this.visitedEnds.mark(end);
        AbstractMergeNode merge = end.merge();
        boolean endsVisited = true;
        for (int i = 0; i < merge.forwardEndCount(); ++i) {
            if (this.visitedEnds.isMarked(merge.forwardEndAt(i))) continue;
            endsVisited = false;
            break;
        }
        if (endsVisited) {
            this.nodeQueue.add(merge);
        }
    }

    protected void node(FixedNode node) {
    }

    protected void end(EndNode endNode) {
        this.node(endNode);
    }

    protected void merge(AbstractMergeNode merge) {
        this.node(merge);
    }

    protected void loopBegin(LoopBeginNode loopBegin) {
        this.node(loopBegin);
    }

    protected void loopEnd(LoopEndNode loopEnd) {
        this.node(loopEnd);
    }

    protected void controlSplit(ControlSplitNode controlSplit) {
        this.node(controlSplit);
    }

    protected void finished() {
    }
}

