/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.graph.MergeableState;

public abstract class SinglePassNodeIterator<T extends MergeableState<T>> {
    private final NodeBitMap visitedEnds;
    private final Deque<PathStart<T>> nodeQueue;
    private final EconomicMap<FixedNode, T> nodeStates;
    private final StartNode start;
    protected T state;

    public SinglePassNodeIterator(StartNode start, T initialState) {
        StructuredGraph graph = start.graph();
        this.visitedEnds = graph.createNodeBitMap();
        this.nodeQueue = new ArrayDeque<PathStart<T>>();
        this.nodeStates = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        this.start = start;
        this.state = initialState;
    }

    public void apply() {
        FixedNode current = this.start;
        do {
            if (current instanceof InvokeWithExceptionNode) {
                this.invoke((Invoke)((Object)current));
                this.queueSuccessors(current);
                current = this.nextQueuedNode();
                continue;
            }
            if (current instanceof LoopBeginNode) {
                ((MergeableState)this.state).loopBegin((LoopBeginNode)current);
                this.keepForLater(current, this.state);
                this.state = (MergeableState)((MergeableState)this.state).clone();
                this.loopBegin((LoopBeginNode)current);
                current = ((LoopBeginNode)current).next();
                assert (current != null);
                continue;
            }
            if (current instanceof LoopEndNode) {
                this.loopEnd((LoopEndNode)current);
                this.finishLoopEnds((LoopEndNode)current);
                current = this.nextQueuedNode();
                continue;
            }
            if (current instanceof AbstractMergeNode) {
                this.merge((AbstractMergeNode)current);
                current = ((AbstractMergeNode)current).next();
                assert (current != null);
                continue;
            }
            if (current instanceof FixedWithNextNode) {
                FixedNode next = ((FixedWithNextNode)current).next();
                assert (next != null) : current;
                this.node(current);
                current = next;
                continue;
            }
            if (current instanceof EndNode) {
                this.end((EndNode)current);
                this.queueMerge((EndNode)current);
                current = this.nextQueuedNode();
                continue;
            }
            if (current instanceof ControlSinkNode) {
                this.node(current);
                current = this.nextQueuedNode();
                continue;
            }
            if (current instanceof ControlSplitNode) {
                this.controlSplit((ControlSplitNode)current);
                this.queueSuccessors(current);
                current = this.nextQueuedNode();
                continue;
            }
            assert (false) : current;
        } while (current != null);
        this.finished();
    }

    private void queueSuccessors(FixedNode x) {
        T startState;
        Object curState = startState = this.state;
        for (Node succ : x.successors()) {
            if (succ == null) continue;
            if (curState == null) {
                curState = (MergeableState)((MergeableState)startState).clone();
            }
            AbstractBeginNode begin = (AbstractBeginNode)succ;
            this.nodeQueue.addFirst(new PathStart(begin, curState));
        }
    }

    private FixedNode nextQueuedNode() {
        if (this.nodeQueue.isEmpty()) {
            return null;
        }
        PathStart<T> elem = this.nodeQueue.removeFirst();
        if (((PathStart)elem).node instanceof AbstractMergeNode) {
            AbstractMergeNode merge = (AbstractMergeNode)((PathStart)elem).node;
            this.state = this.pruneEntry(merge.forwardEndAt(0));
            ArrayList<T> states = new ArrayList<T>(merge.forwardEndCount() - 1);
            for (int i = 1; i < merge.forwardEndCount(); ++i) {
                T other = this.pruneEntry(merge.forwardEndAt(i));
                states.add(other);
            }
            boolean ready = ((MergeableState)this.state).merge(merge, states);
            assert (ready) : "Not a single-pass iterator after all";
            return merge;
        }
        AbstractBeginNode begin = ((PathStart)elem).node;
        assert (begin.predecessor() != null);
        this.state = (MergeableState)((PathStart)elem).stateOnEntry;
        ((MergeableState)this.state).afterSplit(begin);
        return begin;
    }

    private void finishLoopEnds(LoopEndNode end) {
        assert (!this.visitedEnds.isMarked(end));
        this.visitedEnds.mark(end);
        this.keepForLater(end, this.state);
        LoopBeginNode begin = end.loopBegin();
        boolean endsVisited = true;
        for (LoopEndNode loopEndNode : begin.loopEnds()) {
            if (this.visitedEnds.isMarked(loopEndNode)) continue;
            endsVisited = false;
            break;
        }
        if (endsVisited) {
            ArrayList<T> states = new ArrayList<T>(begin.loopEnds().count());
            for (LoopEndNode le : begin.orderedLoopEnds()) {
                T leState = this.pruneEntry(le);
                states.add(leState);
            }
            Object e = this.pruneEntry(begin);
            ((MergeableState)e).loopEnds(begin, states);
        }
    }

    private void queueMerge(EndNode end) {
        assert (!this.visitedEnds.isMarked(end));
        this.visitedEnds.mark(end);
        this.keepForLater(end, this.state);
        AbstractMergeNode merge = end.merge();
        boolean endsVisited = true;
        for (int i = 0; i < merge.forwardEndCount(); ++i) {
            if (this.visitedEnds.isMarked(merge.forwardEndAt(i))) continue;
            endsVisited = false;
            break;
        }
        if (endsVisited) {
            this.nodeQueue.add(new PathStart(merge, null));
        }
    }

    protected abstract void node(FixedNode var1);

    protected void end(EndNode endNode) {
        this.node(endNode);
    }

    protected void merge(AbstractMergeNode merge) {
        this.node(merge);
    }

    protected void loopBegin(LoopBeginNode loopBegin) {
        this.node(loopBegin);
    }

    protected void loopEnd(LoopEndNode loopEnd) {
        this.node(loopEnd);
    }

    protected void controlSplit(ControlSplitNode controlSplit) {
        this.node(controlSplit);
    }

    protected void invoke(Invoke invoke) {
        this.node(invoke.asNode());
    }

    protected void finished() {
        assert (this.nodeQueue.isEmpty());
        assert (this.nodeStates.isEmpty());
    }

    private void keepForLater(FixedNode x, T s) {
        assert (!this.nodeStates.containsKey((Object)x));
        assert (x instanceof LoopBeginNode || x instanceof LoopEndNode || x instanceof EndNode);
        assert (s != null);
        this.nodeStates.put((Object)x, s);
    }

    private T pruneEntry(FixedNode x) {
        MergeableState result = (MergeableState)this.nodeStates.removeKey((Object)x);
        assert (result != null);
        return (T)result;
    }

    private static final class PathStart<U> {
        private final AbstractBeginNode node;
        private final U stateOnEntry;

        private PathStart(AbstractBeginNode node, U stateOnEntry) {
            this.node = node;
            this.stateOnEntry = stateOnEntry;
            assert (this.repOK());
        }

        private boolean repOK() {
            if (this.node == null) {
                return false;
            }
            if (this.node instanceof AbstractMergeNode) {
                return this.stateOnEntry == null;
            }
            return this.stateOnEntry != null;
        }
    }
}

