/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.memory;

import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.memory.FloatingAccessNode;
import org.graalvm.compiler.nodes.memory.LIRLowerableAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Read#{p#location/s}", cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class FloatingReadNode
extends FloatingAccessNode
implements LIRLowerableAccess,
Canonicalizable {
    public static final NodeClass<FloatingReadNode> TYPE = NodeClass.create(FloatingReadNode.class);
    @Node.OptionalInput(value=InputType.Memory)
    MemoryKill lastLocationAccess;

    public FloatingReadNode(AddressNode address, LocationIdentity location, MemoryKill lastLocationAccess, Stamp stamp) {
        this(address, location, lastLocationAccess, stamp, null, OnHeapMemoryAccess.BarrierType.NONE);
    }

    public FloatingReadNode(AddressNode address, LocationIdentity location, MemoryKill lastLocationAccess, Stamp stamp, GuardingNode guard) {
        this(address, location, lastLocationAccess, stamp, guard, OnHeapMemoryAccess.BarrierType.NONE);
    }

    public FloatingReadNode(AddressNode address, LocationIdentity location, MemoryKill lastLocationAccess, Stamp stamp, GuardingNode guard, OnHeapMemoryAccess.BarrierType barrierType) {
        super(TYPE, address, location, stamp, guard, barrierType);
        this.lastLocationAccess = lastLocationAccess;
        assert (guard != null || !(address.getBase().stamp(NodeView.DEFAULT) instanceof ObjectStamp) || address.getBase() instanceof ValuePhiNode || ((ObjectStamp)address.getBase().stamp(NodeView.DEFAULT)).nonNull()) : address.getBase();
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill newlla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(newlla));
        this.lastLocationAccess = newlla;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRKind readKind = gen.getLIRGeneratorTool().getLIRKind(this.stamp(NodeView.DEFAULT));
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().getArithmetic().emitLoad(readKind, gen.operand(this.address), null));
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        WriteNode write;
        ValueNode result = ReadNode.canonicalizeRead(this, this.getAddress(), this.getLocationIdentity(), tool);
        if (result != this) {
            return result;
        }
        if (tool.canonicalizeReads() && this.getAddress().hasMoreThanOneUsage() && this.lastLocationAccess instanceof WriteNode && (write = (WriteNode)this.lastLocationAccess).getAddress() == this.getAddress() && write.getAccessStamp(NodeView.DEFAULT).isCompatible(this.getAccessStamp(NodeView.DEFAULT))) {
            return write.value();
        }
        return this;
    }

    @Override
    public FixedAccessNode asFixedNode() {
        try (DebugCloseable position = this.withNodeSourcePosition();){
            ReadNode result = this.graph().add(new ReadNode(this.getAddress(), this.getLocationIdentity(), this.stamp(NodeView.DEFAULT), this.getBarrierType()));
            result.setGuard(this.getGuard());
            ReadNode readNode = result;
            return readNode;
        }
    }

    @Override
    public boolean verify() {
        MemoryKill lla = this.getLastLocationAccess();
        assert (lla != null || this.getLocationIdentity().isImmutable()) : "lastLocationAccess of " + this + " shouldn't be null for mutable location identity " + this.getLocationIdentity();
        return super.verify();
    }

    @Override
    public Stamp getAccessStamp(NodeView view) {
        return this.stamp(view);
    }
}

