/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.AbstractCompareAndSwapNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8)
public final class LogicCompareAndSwapNode
extends AbstractCompareAndSwapNode {
    public static final NodeClass<LogicCompareAndSwapNode> TYPE = NodeClass.create(LogicCompareAndSwapNode.class);

    public LogicCompareAndSwapNode(ValueNode address, ValueNode expectedValue, ValueNode newValue, LocationIdentity location) {
        this((AddressNode)address, location, expectedValue, newValue, OnHeapMemoryAccess.BarrierType.NONE);
    }

    public LogicCompareAndSwapNode(AddressNode address, LocationIdentity location, ValueNode expectedValue, ValueNode newValue, OnHeapMemoryAccess.BarrierType barrierType) {
        super(TYPE, address, location, expectedValue, newValue, barrierType, StampFactory.forInteger(JavaKind.Int, 0L, 1L));
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        assert (this.getNewValue().stamp(NodeView.DEFAULT).isCompatible(this.getExpectedValue().stamp(NodeView.DEFAULT)));
        assert (!this.canDeoptimize());
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        LIRKind resultKind = tool.getLIRKind(this.stamp(NodeView.DEFAULT));
        Value trueResult = tool.emitConstant(resultKind, (Constant)JavaConstant.TRUE);
        Value falseResult = tool.emitConstant(resultKind, (Constant)JavaConstant.FALSE);
        Variable result = tool.emitLogicCompareAndSwap(tool.getLIRKind(this.getAccessStamp(NodeView.DEFAULT)), gen.operand(this.getAddress()), gen.operand(this.getExpectedValue()), gen.operand(this.getNewValue()), trueResult, falseResult, false);
        gen.setResult(this, (Value)result);
    }
}

