/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.graphbuilderconf;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;

public final class MethodSubstitutionPlugin
implements InvocationPlugin {
    private InvocationPlugins.Registration registration;
    private ResolvedJavaMethod cachedSubstitute;
    private final Class<?> declaringClass;
    private final String substituteName;
    private final String originalName;
    private final Type[] parameters;
    private final boolean originalIsStatic;
    private final BytecodeProvider bytecodeProvider;

    public MethodSubstitutionPlugin(InvocationPlugins.Registration registration, BytecodeProvider bytecodeProvider, String originalName, Class<?> declaringClass, String substituteName, Type ... parameters) {
        assert (bytecodeProvider != null) : "Requires a non-null methodSubstitutionBytecodeProvider";
        this.registration = registration;
        this.bytecodeProvider = bytecodeProvider;
        this.originalName = originalName;
        this.declaringClass = declaringClass;
        this.substituteName = substituteName;
        this.parameters = parameters;
        this.originalIsStatic = parameters.length == 0 || parameters[0] != InvocationPlugin.Receiver.class;
    }

    public ResolvedJavaMethod getSubstitute(MetaAccessProvider metaAccess) {
        if (this.cachedSubstitute == null) {
            this.cachedSubstitute = metaAccess.lookupJavaMethod((Executable)this.getJavaSubstitute());
        }
        return this.cachedSubstitute;
    }

    public BytecodeProvider getBytecodeProvider() {
        return this.bytecodeProvider;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public Method getJavaSubstitute() throws GraalError {
        Method substituteMethod = this.lookupSubstitute();
        int modifiers = substituteMethod.getModifiers();
        if (Modifier.isAbstract(modifiers) || Modifier.isNative(modifiers)) {
            throw new GraalError("Substitution method must not be abstract or native: " + substituteMethod);
        }
        if (!Modifier.isStatic(modifiers)) {
            throw new GraalError("Substitution method must be static: " + substituteMethod);
        }
        return substituteMethod;
    }

    private boolean isSubstitute(Method m) {
        if (Modifier.isStatic(m.getModifiers()) && m.getName().equals(this.substituteName) && this.parameters.length == m.getParameterCount()) {
            Class<?>[] mparams = m.getParameterTypes();
            int start = 0;
            if (!this.originalIsStatic) {
                start = 1;
                if (!mparams[0].isAssignableFrom(InvocationPlugins.resolveType(this.parameters[0], false))) {
                    return false;
                }
            }
            for (int i = start; i < mparams.length; ++i) {
                if (mparams[i] == InvocationPlugins.resolveType(this.parameters[i], false)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Method lookupSubstitute(Method excluding) {
        for (Method m : this.declaringClass.getDeclaredMethods()) {
            if (m.equals(excluding) || !this.isSubstitute(m)) continue;
            return m;
        }
        return null;
    }

    private Method lookupSubstitute() {
        Method m = this.lookupSubstitute(null);
        if (m != null) {
            assert (this.lookupSubstitute(m) == null) : String.format("multiple matches found for %s:%n%s%n%s", this, m, this.lookupSubstitute(m));
            return m;
        }
        throw new GraalError("No method found specified by %s", this);
    }

    @Override
    public boolean execute(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode[] argsIncludingReceiver) {
        if (Services.IS_IN_NATIVE_IMAGE || GraalOptions.UseEncodedGraphs.getValue(b.getOptions()).booleanValue() && !b.parsingIntrinsic()) {
            StructuredGraph subst = b.getReplacements().getMethodSubstitution(this, targetMethod, IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING, StructuredGraph.AllowAssumptions.ifNonNull(b.getAssumptions()), null, b.getOptions());
            if (subst == null) {
                throw new GraalError("No graphs found for substitution %s", this);
            }
            return b.intrinsify(targetMethod, subst, receiver, argsIncludingReceiver);
        }
        ResolvedJavaMethod substitute = this.getSubstitute(b.getMetaAccess());
        return b.intrinsify(this.bytecodeProvider, targetMethod, substitute, receiver, argsIncludingReceiver);
    }

    @Override
    public StackTraceElement getApplySourceLocation(MetaAccessProvider metaAccess) {
        Class<?> c = this.getClass();
        if (Services.IS_IN_NATIVE_IMAGE) {
            return new StackTraceElement(c.getName(), "execute", null, -1);
        }
        for (Method m : c.getDeclaredMethods()) {
            if (!m.getName().equals("execute")) continue;
            return metaAccess.lookupJavaMethod((Executable)m).asStackTraceElement(0);
        }
        throw new GraalError("could not find method named \"execute\" in " + c.getName());
    }

    public String toString() {
        return String.format("%s[%s.%s(%s)]", this.getClass().getSimpleName(), this.declaringClass.getName(), this.substituteName, Arrays.asList(this.parameters).stream().map(c -> c.getTypeName()).collect(Collectors.joining(", ")));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodSubstitutionPlugin that = (MethodSubstitutionPlugin)o;
        return this.originalIsStatic == that.originalIsStatic && Objects.equals(this.declaringClass, that.declaringClass) && Objects.equals(this.substituteName, that.substituteName) && Objects.equals(this.originalName, that.originalName) && Arrays.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        int result = Objects.hash(this.declaringClass, this.substituteName, this.originalName, this.originalIsStatic);
        return result;
    }

    public String originalMethodAsString() {
        return String.format("%s.%s(%s)", this.declaringClass.getName(), this.substituteName, Arrays.asList(this.parameters).stream().map(c -> c.getTypeName()).collect(Collectors.joining(", ")));
    }

    public ResolvedJavaMethod getOriginalMethod(MetaAccessProvider metaAccess) {
        Class<?> clazz = InvocationPlugins.resolveType(this.registration.getDeclaringType(), false);
        if (clazz == null) {
            throw new GraalError("Can't find original class for " + this + " with class " + this.registration.getDeclaringType());
        }
        ResolvedJavaType type = metaAccess.lookupJavaType(clazz);
        String argumentsDescriptor = InvocationPlugins.toArgumentDescriptor(this.originalIsStatic, this.parameters);
        for (ResolvedJavaMethod declared : type.getDeclaredMethods()) {
            if (!declared.getName().equals(this.originalName) || declared.isStatic() != this.originalIsStatic || !declared.getSignature().toMethodDescriptor().startsWith(argumentsDescriptor)) continue;
            return declared;
        }
        throw new GraalError("Can't find original method for " + this + " with class " + this.registration.getDeclaringType());
    }
}

