/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.type.StampTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class LoadHubOrNullNode
extends FloatingNode
implements Lowerable,
Canonicalizable,
Virtualizable {
    public static final NodeClass<LoadHubOrNullNode> TYPE = NodeClass.create(LoadHubOrNullNode.class);
    @Node.Input
    ValueNode value;

    public ValueNode getValue() {
        return this.value;
    }

    private static AbstractPointerStamp hubStamp(StampProvider stampProvider, ValueNode value) {
        assert (value.stamp(NodeView.DEFAULT) instanceof ObjectStamp);
        return stampProvider.createHubStamp((ObjectStamp)value.stamp(NodeView.DEFAULT)).asMaybeNull();
    }

    public static ValueNode create(ValueNode value, StampProvider stampProvider, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection) {
        AbstractPointerStamp stamp = LoadHubOrNullNode.hubStamp(stampProvider, value);
        return LoadHubOrNullNode.create(value, stamp, metaAccess, constantReflection);
    }

    public static ValueNode create(ValueNode value, AbstractPointerStamp stamp, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection) {
        ValueNode synonym = LoadHubOrNullNode.findSynonym(value, stamp, metaAccess, constantReflection);
        if (synonym != null) {
            return synonym;
        }
        return new LoadHubOrNullNode(stamp, value);
    }

    public LoadHubOrNullNode(@Node.InjectedNodeParameter StampProvider stampProvider, ValueNode value) {
        this(LoadHubOrNullNode.hubStamp(stampProvider, value), value);
    }

    public LoadHubOrNullNode(Stamp stamp, ValueNode value) {
        super((NodeClass<? extends FloatingNode>)TYPE, stamp);
        this.value = value;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool) {
        if (!GraalOptions.GeneratePIC.getValue(tool.getOptions()).booleanValue()) {
            NodeView view = NodeView.from(tool);
            MetaAccessProvider metaAccess = tool.getMetaAccess();
            ValueNode curValue = this.getValue();
            ValueNode newNode = LoadHubOrNullNode.findSynonym(curValue, (AbstractPointerStamp)this.stamp(view), metaAccess, tool.getConstantReflection());
            if (newNode != null) {
                return newNode;
            }
        }
        return this;
    }

    public static ValueNode findSynonym(ValueNode curValue, AbstractPointerStamp stamp, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection) {
        if (StampTool.isPointerNonNull(stamp)) {
            return LoadHubNode.create(curValue, stamp.asNonNull(), metaAccess, constantReflection);
        }
        return null;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias;
        TypeReference type;
        if (!GraalOptions.GeneratePIC.getValue(tool.getOptions()).booleanValue() && (type = StampTool.typeReferenceOrNull(alias = tool.getAlias(this.getValue()))) != null && type.isExact()) {
            tool.replaceWithValue(ConstantNode.forConstant(this.stamp(NodeView.DEFAULT), tool.getConstantReflection().asObjectHub(type.getType()), tool.getMetaAccess(), this.graph()));
        }
    }
}

