/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.AbstractWriteNode;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="JavaWrite#{p#location/s}")
public final class JavaWriteNode
extends AbstractWriteNode
implements Lowerable,
StateSplit,
MemoryAccess,
SingleMemoryKill {
    public static final NodeClass<JavaWriteNode> TYPE = NodeClass.create(JavaWriteNode.class);
    protected final JavaKind writeKind;
    protected final boolean compressible;
    protected final boolean hasSideEffect;

    public JavaWriteNode(JavaKind writeKind, AddressNode address, LocationIdentity location, ValueNode value, OnHeapMemoryAccess.BarrierType barrierType, boolean compressible, boolean hasSideEffect) {
        super(TYPE, address, location, value, barrierType);
        this.writeKind = writeKind;
        this.compressible = compressible;
        this.hasSideEffect = hasSideEffect;
    }

    public JavaWriteNode(JavaKind writeKind, AddressNode address, LocationIdentity location, ValueNode value, OnHeapMemoryAccess.BarrierType barrierType, boolean compressible) {
        super(TYPE, address, location, value, barrierType);
        this.writeKind = writeKind;
        this.compressible = compressible;
        this.hasSideEffect = true;
    }

    @Override
    public boolean canNullCheck() {
        return true;
    }

    public JavaKind getWriteKind() {
        return this.writeKind;
    }

    public boolean isCompressible() {
        return this.compressible;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.getLocationIdentity();
    }

    @Override
    public Stamp getAccessStamp(NodeView view) {
        return this.value().stamp(view);
    }

    @Override
    public boolean hasSideEffect() {
        return this.hasSideEffect;
    }
}

