/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(shortName="*H", cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class IntegerMulHighNode
extends BinaryArithmeticNode<ArithmeticOpTable.BinaryOp.MulHigh>
implements Canonicalizable.BinaryCommutative<ValueNode> {
    public static final NodeClass<IntegerMulHighNode> TYPE = NodeClass.create(IntegerMulHighNode.class);

    public IntegerMulHighNode(ValueNode x, ValueNode y) {
        super(TYPE, IntegerMulHighNode.getArithmeticOpTable(x).getMulHigh(), x, y);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.MulHigh> getOp(ArithmeticOpTable table) {
        return table.getMulHigh();
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        Value a = nodeValueMap.operand(this.getX());
        Value b = nodeValueMap.operand(this.getY());
        nodeValueMap.setResult(this, gen.emitMulHigh(a, b));
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        if (forX.isConstant() && !forY.isConstant()) {
            ValueNode improvement = this.canonical(tool, forY, forX);
            if (improvement != this) {
                return improvement;
            }
            return new IntegerMulHighNode(forY, forX);
        }
        return IntegerMulHighNode.canonical(this, forY);
    }

    private static ValueNode canonical(IntegerMulHighNode self, ValueNode forY) {
        long i;
        Constant c;
        if (forY.isConstant() && (c = forY.asConstant()) instanceof PrimitiveConstant && ((PrimitiveConstant)c).getJavaKind().isNumericInteger() && ((i = ((PrimitiveConstant)c).asLong()) == 0L || i == 1L)) {
            return ConstantNode.forIntegerStamp(self.stamp(NodeView.DEFAULT), 0L);
        }
        return self;
    }
}

