/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FixedBinaryNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.Lowerable;

@NodeInfo(cycles=NodeCycles.CYCLES_32, size=NodeSize.SIZE_1)
public abstract class IntegerDivRemNode
extends FixedBinaryNode
implements Lowerable,
IterableNodeType {
    public static final NodeClass<IntegerDivRemNode> TYPE = NodeClass.create(IntegerDivRemNode.class);
    @Node.OptionalInput(value=InputType.Guard)
    private GuardingNode zeroCheck;
    private final Op op;
    private final Type type;
    private final boolean canDeopt;

    protected IntegerDivRemNode(NodeClass<? extends IntegerDivRemNode> c, Stamp stamp, Op op, Type type, ValueNode x, ValueNode y, GuardingNode zeroCheck) {
        super(c, stamp, x, y);
        this.zeroCheck = zeroCheck;
        this.op = op;
        this.type = type;
        IntegerStamp yStamp = (IntegerStamp)this.getY().stamp(NodeView.DEFAULT);
        this.canDeopt = yStamp.contains(0L) && zeroCheck == null || yStamp.contains(-1L);
    }

    public final GuardingNode getZeroCheck() {
        return this.zeroCheck;
    }

    public final Op getOp() {
        return this.op;
    }

    public final Type getType() {
        return this.type;
    }

    @Override
    public boolean canDeoptimize() {
        return this.canDeopt;
    }

    public static enum Type {
        SIGNED,
        UNSIGNED;

    }

    public static enum Op {
        DIV,
        REM;

    }
}

