/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AbstractNormalizeCompareNode;
import org.graalvm.compiler.nodes.calc.FloatEqualsNode;
import org.graalvm.compiler.nodes.calc.FloatLessThanNode;
import org.graalvm.compiler.options.OptionValues;

@NodeInfo
public final class FloatNormalizeCompareNode
extends AbstractNormalizeCompareNode {
    public static final NodeClass<FloatNormalizeCompareNode> TYPE = NodeClass.create(FloatNormalizeCompareNode.class);
    protected final boolean isUnorderedLess;

    public FloatNormalizeCompareNode(ValueNode x, ValueNode y, JavaKind kind, boolean isUnorderedLess) {
        super(TYPE, kind, x, y);
        this.isUnorderedLess = isUnorderedLess;
    }

    public static ValueNode create(ValueNode x, ValueNode y, boolean isUnorderedLess, JavaKind kind, ConstantReflectionProvider constantReflection) {
        ValueNode result = FloatNormalizeCompareNode.tryConstantFold(x, y, isUnorderedLess, false, kind, constantReflection);
        if (result != null) {
            return result;
        }
        return new FloatNormalizeCompareNode(x, y, kind, isUnorderedLess);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        ValueNode result = FloatNormalizeCompareNode.tryConstantFold(this.x, this.y, this.isUnorderedLess, false, this.stamp(view).getStackKind(), tool.getConstantReflection());
        if (result != null) {
            return result;
        }
        return this;
    }

    public boolean isUnorderedLess() {
        return this.isUnorderedLess;
    }

    @Override
    public LogicNode createEqualComparison() {
        return FloatEqualsNode.create(this.x, this.y, NodeView.DEFAULT);
    }

    @Override
    public LogicNode createEqualComparison(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, NodeView view) {
        return FloatEqualsNode.create(constantReflection, metaAccess, options, smallestCompareWidth, this.x, this.y, NodeView.DEFAULT);
    }

    @Override
    public LogicNode createLowerComparison(boolean swapInputs) {
        ValueNode a = swapInputs ? this.y : this.x;
        ValueNode b = swapInputs ? this.x : this.y;
        return FloatLessThanNode.create(a, b, this.isUnorderedLess() ^ swapInputs, NodeView.DEFAULT);
    }

    @Override
    public LogicNode createLowerComparison(boolean swapInputs, ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, NodeView view) {
        ValueNode a = swapInputs ? this.y : this.x;
        ValueNode b = swapInputs ? this.x : this.y;
        return FloatLessThanNode.create(constantReflection, metaAccess, options, smallestCompareWidth, a, b, this.isUnorderedLess() ^ swapInputs, NodeView.DEFAULT);
    }
}

