/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.Map;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.util.CollectionsUtil;

@NodeInfo(nameTemplate="Phi({i#values}, {p#valueDescription})")
public class ValuePhiNode
extends PhiNode {
    public static final NodeClass<ValuePhiNode> TYPE = NodeClass.create(ValuePhiNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> values;

    public ValuePhiNode(Stamp stamp, AbstractMergeNode merge) {
        this((NodeClass<? extends ValuePhiNode>)TYPE, stamp, merge);
    }

    protected ValuePhiNode(NodeClass<? extends ValuePhiNode> c, Stamp stamp, AbstractMergeNode merge) {
        super(c, stamp, merge);
        assert (stamp != StampFactory.forVoid());
        this.values = new NodeInputList(this);
    }

    public ValuePhiNode(Stamp stamp, AbstractMergeNode merge, ValueNode[] values) {
        super(TYPE, stamp, merge);
        assert (stamp != StampFactory.forVoid());
        this.values = new NodeInputList((Node)this, (Node[])values);
    }

    @Override
    public NodeInputList<ValueNode> values() {
        return this.values;
    }

    @Override
    public boolean inferStamp() {
        Stamp valuesStamp = StampTool.meetOrNull(this.values(), this);
        if (valuesStamp == null) {
            valuesStamp = this.stamp;
        } else if (this.stamp.isCompatible(valuesStamp)) {
            valuesStamp = this.stamp.join(valuesStamp);
        }
        return this.updateStamp(valuesStamp);
    }

    @Override
    public boolean verify() {
        Stamp s = null;
        for (ValueNode input : this.values()) {
            assert (input != null);
            if (s == null) {
                s = input.stamp(NodeView.DEFAULT);
                continue;
            }
            if (s.isCompatible(input.stamp(NodeView.DEFAULT))) continue;
            this.fail("Phi Input Stamps are not compatible. Phi:%s inputs:%s", this, CollectionsUtil.mapAndJoin(this.values(), x -> x.toString() + ":" + x.stamp(NodeView.DEFAULT), ", "));
        }
        return super.verify();
    }

    @Override
    protected String valueDescription() {
        return this.stamp(NodeView.DEFAULT).unrestricted().toString();
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        Map<Object, Object> properties = super.getDebugProperties(map);
        properties.put("valueDescription", this.valueDescription());
        return properties;
    }

    @Override
    public PhiNode duplicateOn(AbstractMergeNode newMerge) {
        return this.graph().addWithoutUnique(new ValuePhiNode(this.stamp(NodeView.DEFAULT), newMerge));
    }
}

