/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.Iterator;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.graph.iterators.NodePredicates;
import org.graalvm.compiler.graph.spi.SimplifierTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.serviceprovider.SpeculationReasonGroup;

@NodeInfo
public final class LoopBeginNode
extends AbstractMergeNode
implements IterableNodeType,
LIRLowerable {
    public static final NodeClass<LoopBeginNode> TYPE = NodeClass.create(LoopBeginNode.class);
    protected double loopFrequency = 1.0;
    protected double loopOrigFrequency = 1.0;
    protected int nextEndIndex;
    protected int unswitches = 0;
    protected int splits = 0;
    protected int peelings;
    protected int inversionCount;
    protected LoopType loopType = LoopType.SIMPLE_LOOP;
    protected int unrollFactor = 1;
    protected boolean osrLoop;
    protected boolean disableCounted;
    protected boolean canNeverOverflow;
    boolean canEndsSafepoint = true;
    @Node.OptionalInput(value=InputType.Guard)
    GuardingNode overflowGuard;
    public static final CounterKey overflowSpeculationTaken = DebugContext.counter("CountedLoops_OverflowSpeculation_Taken");
    public static final CounterKey overflowSpeculationNotTaken = DebugContext.counter("CountedLoops_OverflowSpeculation_NotTaken");
    public static final SpeculationReasonGroup LOOP_OVERFLOW_DEOPT = new SpeculationReasonGroup("LoopOverflowDeopt", ResolvedJavaMethod.class, Integer.TYPE);
    private static final int NO_INCREMENT = Integer.MIN_VALUE;

    public LoopBeginNode() {
        super((NodeClass<? extends AbstractMergeNode>)TYPE);
    }

    public void checkDisableCountedBySpeculation(int bci, StructuredGraph graph) {
        SpeculationLog.SpeculationReason speculationReason;
        SpeculationLog speculationLog = graph.getSpeculationLog();
        boolean disableCountedBasedOnSpeculation = false;
        if (speculationLog != null && !speculationLog.maySpeculate(speculationReason = LOOP_OVERFLOW_DEOPT.createSpeculationReason(graph.method(), bci))) {
            overflowSpeculationNotTaken.increment(graph.getDebug());
            disableCountedBasedOnSpeculation = true;
        }
        this.disableCounted = disableCountedBasedOnSpeculation;
    }

    public boolean canNeverOverflow() {
        return this.canNeverOverflow;
    }

    public void setCanNeverOverflow() {
        assert (!this.canNeverOverflow);
        this.canNeverOverflow = true;
    }

    public boolean countedLoopDisabled() {
        return this.disableCounted;
    }

    public boolean isSimpleLoop() {
        return this.loopType == LoopType.SIMPLE_LOOP;
    }

    public void setPreLoop() {
        assert (this.isSimpleLoop());
        this.loopType = LoopType.PRE_LOOP;
    }

    public boolean isPreLoop() {
        return this.loopType == LoopType.PRE_LOOP;
    }

    public void setMainLoop() {
        assert (this.isSimpleLoop());
        this.loopType = LoopType.MAIN_LOOP;
    }

    public boolean isMainLoop() {
        return this.loopType == LoopType.MAIN_LOOP;
    }

    public void setPostLoop() {
        assert (this.isSimpleLoop());
        this.loopType = LoopType.POST_LOOP;
    }

    public boolean isPostLoop() {
        return this.loopType == LoopType.POST_LOOP;
    }

    public int getUnrollFactor() {
        return this.unrollFactor;
    }

    public void setUnrollFactor(int currentUnrollFactor) {
        this.unrollFactor = currentUnrollFactor;
    }

    public void disableSafepoint() {
        this.canEndsSafepoint = false;
        for (LoopEndNode loopEnd : this.loopEnds()) {
            loopEnd.disableSafepoint();
        }
    }

    public double loopOrigFrequency() {
        return this.loopOrigFrequency;
    }

    public void setLoopOrigFrequency(double loopOrigFrequency) {
        assert (loopOrigFrequency >= 0.0);
        this.loopOrigFrequency = loopOrigFrequency;
    }

    public double loopFrequency() {
        return this.loopFrequency;
    }

    public void setLoopFrequency(double loopFrequency) {
        assert (loopFrequency >= 1.0);
        this.loopFrequency = loopFrequency;
    }

    public NodeIterable<LoopEndNode> loopEnds() {
        return this.usages().filter(LoopEndNode.class);
    }

    public NodeIterable<LoopExitNode> loopExits() {
        return this.usages().filter(LoopExitNode.class);
    }

    @Override
    public NodeIterable<Node> anchored() {
        return super.anchored().filter(NodePredicates.isNotA(LoopEndNode.class).nor(LoopExitNode.class));
    }

    public LoopEndNode[] orderedLoopEnds() {
        LoopEndNode[] result = new LoopEndNode[this.getLoopEndCount()];
        Iterator iterator = this.loopEnds().iterator();
        while (iterator.hasNext()) {
            LoopEndNode end;
            result[end.endIndex()] = end = (LoopEndNode)iterator.next();
        }
        return result;
    }

    public boolean isSingleEntryLoop() {
        return this.forwardEndCount() == 1;
    }

    public AbstractEndNode forwardEnd() {
        assert (this.forwardEndCount() == 1);
        return this.forwardEndAt(0);
    }

    public int splits() {
        return this.splits;
    }

    public void incrementSplits() {
        ++this.splits;
    }

    public int peelings() {
        return this.peelings;
    }

    public void incrementPeelings() {
        ++this.peelings;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
    }

    @Override
    protected void deleteEnd(AbstractEndNode end) {
        if (end instanceof LoopEndNode) {
            LoopEndNode loopEnd = (LoopEndNode)end;
            loopEnd.setLoopBegin(null);
            int idx = loopEnd.endIndex();
            for (LoopEndNode le : this.loopEnds()) {
                int leIdx = le.endIndex();
                assert (leIdx != idx);
                if (leIdx <= idx) continue;
                le.setEndIndex(leIdx - 1);
            }
            --this.nextEndIndex;
        } else {
            super.deleteEnd(end);
        }
    }

    @Override
    public int phiPredecessorCount() {
        return this.forwardEndCount() + this.loopEnds().count();
    }

    @Override
    public int phiPredecessorIndex(AbstractEndNode pred) {
        if (pred instanceof LoopEndNode) {
            LoopEndNode loopEnd = (LoopEndNode)pred;
            if (loopEnd.loopBegin() == this) {
                assert (loopEnd.endIndex() < this.loopEnds().count()) : "Invalid endIndex : " + loopEnd;
                return loopEnd.endIndex() + this.forwardEndCount();
            }
        } else {
            return super.forwardEndIndex((EndNode)pred);
        }
        throw ValueNodeUtil.shouldNotReachHere("unknown pred : " + pred);
    }

    @Override
    public AbstractEndNode phiPredecessorAt(int index) {
        if (index < this.forwardEndCount()) {
            return this.forwardEndAt(index);
        }
        for (LoopEndNode end : this.loopEnds()) {
            int idx = index - this.forwardEndCount();
            assert (idx >= 0);
            if (end.endIndex() != idx) continue;
            return end;
        }
        throw ValueNodeUtil.shouldNotReachHere();
    }

    @Override
    public boolean verify() {
        this.assertTrue(this.loopEnds().isNotEmpty(), "missing loopEnd", new Object[0]);
        return super.verify();
    }

    int nextEndIndex() {
        return this.nextEndIndex++;
    }

    public int getLoopEndCount() {
        return this.nextEndIndex;
    }

    public int unswitches() {
        return this.unswitches;
    }

    public void incrementUnswitches() {
        ++this.unswitches;
    }

    public int getInversionCount() {
        return this.inversionCount;
    }

    public void setInversionCount(int count) {
        this.inversionCount = count;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        this.canonicalizePhis(tool);
    }

    public boolean isLoopExit(AbstractBeginNode begin) {
        return begin instanceof LoopExitNode && ((LoopExitNode)begin).loopBegin() == this;
    }

    public LoopEndNode getSingleLoopEnd() {
        assert (this.loopEnds().count() == 1);
        return this.loopEnds().first();
    }

    public void removeExits() {
        for (LoopExitNode loopexit : this.loopExits().snapshot()) {
            DebugCloseable position = this.graph().withNodeSourcePosition(loopexit);
            Throwable throwable = null;
            try {
                loopexit.removeExit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (position == null) continue;
                if (throwable != null) {
                    try {
                        position.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                position.close();
            }
        }
    }

    public GuardingNode getOverflowGuard() {
        return this.overflowGuard;
    }

    public void setOverflowGuard(GuardingNode overflowGuard) {
        this.updateUsagesInterface(this.overflowGuard, overflowGuard);
        this.overflowGuard = overflowGuard;
    }

    private static int[] getSelfIncrements(PhiNode phi) {
        int[] selfIncrement = new int[phi.valueCount()];
        for (int i = 0; i < phi.valueCount(); ++i) {
            ValueNode input = phi.valueAt(i);
            long increment = Integer.MIN_VALUE;
            if (input != null && input instanceof AddNode && input.stamp(NodeView.DEFAULT) instanceof IntegerStamp) {
                AddNode add = (AddNode)input;
                if (add.getX() == phi && add.getY().isConstant()) {
                    increment = add.getY().asJavaConstant().asLong();
                } else if (add.getY() == phi && add.getX().isConstant()) {
                    increment = add.getX().asJavaConstant().asLong();
                }
            } else if (input == phi) {
                increment = 0L;
            }
            if (increment < Integer.MIN_VALUE || increment > Integer.MAX_VALUE || increment == Integer.MIN_VALUE) {
                increment = Integer.MIN_VALUE;
            }
            selfIncrement[i] = (int)increment;
        }
        return selfIncrement;
    }

    public void canonicalizePhis(SimplifierTool tool) {
        int phiCount = this.phis().count();
        if (phiCount > 1) {
            int phiInputCount = this.phiPredecessorCount();
            int phiIndex = 0;
            int[][] selfIncrement = new int[phiCount][];
            PhiNode[] phis = this.phis().snapshot().toArray(new PhiNode[phiCount]);
            for (phiIndex = 0; phiIndex < phiCount; ++phiIndex) {
                PhiNode phi = phis[phiIndex];
                if (phi == null) continue;
                block1: for (int otherPhiIndex = phiIndex + 1; otherPhiIndex < phiCount; ++otherPhiIndex) {
                    PhiNode otherPhi = phis[otherPhiIndex];
                    if (otherPhi == null || phi.getNodeClass() != otherPhi.getNodeClass() || !phi.valueEquals(otherPhi)) continue;
                    if (selfIncrement[phiIndex] == null) {
                        selfIncrement[phiIndex] = LoopBeginNode.getSelfIncrements(phi);
                    }
                    if (selfIncrement[otherPhiIndex] == null) {
                        selfIncrement[otherPhiIndex] = LoopBeginNode.getSelfIncrements(otherPhi);
                    }
                    int[] phiIncrement = selfIncrement[phiIndex];
                    int[] otherPhiIncrement = selfIncrement[otherPhiIndex];
                    for (int inputIndex = 0; inputIndex < phiInputCount; ++inputIndex) {
                        if (phiIncrement[inputIndex] == Integer.MIN_VALUE && phi.valueAt(inputIndex) != otherPhi.valueAt(inputIndex) || phiIncrement[inputIndex] != otherPhiIncrement[inputIndex]) continue block1;
                    }
                    if (tool != null) {
                        tool.addToWorkList(otherPhi.usages());
                    }
                    otherPhi.replaceAtUsages(phi);
                    GraphUtil.killWithUnusedFloatingInputs(otherPhi);
                    phis[otherPhiIndex] = null;
                }
            }
        }
    }

    public void markOsrLoop() {
        this.osrLoop = true;
    }

    public boolean isOsrLoop() {
        return this.osrLoop;
    }

    @Override
    protected boolean verifyState() {
        return !this.graph().getFrameStateVerification().implies(StructuredGraph.FrameStateVerificationFeature.LOOP_BEGINS) || super.verifyState();
    }

    public static enum LoopType {
        SIMPLE_LOOP,
        PRE_LOOP,
        MAIN_LOOP,
        POST_LOOP;

    }
}

