/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.TriState;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.bytecode.BytecodeDisassembler;
import org.graalvm.compiler.bytecode.Bytecodes;
import org.graalvm.compiler.bytecode.Bytes;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.graph.spi.Simplifiable;
import org.graalvm.compiler.graph.spi.SimplifierTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNegationNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.ValueProxyNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.FloatNormalizeCompareNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.IntegerNormalizeCompareNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.extended.UnboxNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.SwitchFoldable;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_2, sizeRationale="2 jmps")
public final class IfNode
extends ControlSplitNode
implements Simplifiable,
LIRLowerable,
IterableNodeType,
SwitchFoldable {
    public static final NodeClass<IfNode> TYPE = NodeClass.create(IfNode.class);
    private static final CounterKey CORRECTED_PROBABILITIES = DebugContext.counter("CorrectedProbabilities");
    @Node.Successor
    AbstractBeginNode trueSuccessor;
    @Node.Successor
    AbstractBeginNode falseSuccessor;
    @Node.Input(value=InputType.Condition)
    LogicNode condition;
    protected double trueSuccessorProbability;

    public LogicNode condition() {
        return this.condition;
    }

    public void setCondition(LogicNode x) {
        this.updateUsages(this.condition, x);
        this.condition = x;
    }

    public IfNode(LogicNode condition, FixedNode trueSuccessor, FixedNode falseSuccessor, double trueSuccessorProbability) {
        this(condition, BeginNode.begin(trueSuccessor), BeginNode.begin(falseSuccessor), trueSuccessorProbability);
    }

    public IfNode(LogicNode condition, AbstractBeginNode trueSuccessor, AbstractBeginNode falseSuccessor, double trueSuccessorProbability) {
        super((NodeClass<? extends ControlSplitNode>)TYPE, StampFactory.forVoid());
        this.condition = condition;
        this.falseSuccessor = falseSuccessor;
        this.trueSuccessor = trueSuccessor;
        this.setTrueSuccessorProbability(trueSuccessorProbability);
    }

    public AbstractBeginNode trueSuccessor() {
        return this.trueSuccessor;
    }

    public AbstractBeginNode falseSuccessor() {
        return this.falseSuccessor;
    }

    public double getTrueSuccessorProbability() {
        return this.trueSuccessorProbability;
    }

    public void setTrueSuccessor(AbstractBeginNode node) {
        this.updatePredecessor(this.trueSuccessor, node);
        this.trueSuccessor = node;
    }

    public void setFalseSuccessor(AbstractBeginNode node) {
        this.updatePredecessor(this.falseSuccessor, node);
        this.falseSuccessor = node;
    }

    public AbstractBeginNode successor(boolean istrue) {
        return istrue ? this.trueSuccessor : this.falseSuccessor;
    }

    public void setTrueSuccessorProbability(double prob) {
        assert (prob >= -1.0E-9 && prob <= 1.000000001) : "Probability out of bounds: " + prob;
        this.trueSuccessorProbability = Math.min(1.0, Math.max(0.0, prob));
    }

    @Override
    public double probability(AbstractBeginNode successor) {
        return successor == this.trueSuccessor ? this.trueSuccessorProbability : 1.0 - this.trueSuccessorProbability;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.emitIf(this);
    }

    @Override
    public boolean verify() {
        this.assertTrue(this.condition() != null, "missing condition", new Object[0]);
        this.assertTrue(this.trueSuccessor() != null, "missing trueSuccessor", new Object[0]);
        this.assertTrue(this.falseSuccessor() != null, "missing falseSuccessor", new Object[0]);
        return super.verify();
    }

    private boolean compareCallContext(NodeSourcePosition successorPosition) {
        NodeSourcePosition position = this.getNodeSourcePosition();
        NodeSourcePosition successor = successorPosition;
        while (position != null) {
            this.assertTrue(Objects.equals(position.getMethod(), successor.getMethod()), "method mismatch", new Object[0]);
            position = position.getCaller();
            successor = successor.getCaller();
        }
        this.assertTrue(successor == null, "successor position has more methods", new Object[0]);
        return true;
    }

    @Override
    public boolean verifySourcePosition() {
        NodeSourcePosition sourcePosition = this.getNodeSourcePosition();
        this.assertTrue(sourcePosition != null, "missing IfNode source position", new Object[0]);
        NodeSourcePosition trueSuccessorPosition = this.trueSuccessor.getNodeSourcePosition();
        this.assertTrue(trueSuccessorPosition != null, "missing IfNode true successor source position", new Object[0]);
        NodeSourcePosition falseSuccessorPosition = this.falseSuccessor.getNodeSourcePosition();
        this.assertTrue(falseSuccessorPosition != null, "missing IfNode false successor source position", new Object[0]);
        int bci = sourcePosition.getBCI();
        ResolvedJavaMethod method = sourcePosition.getMethod();
        int bytecode = BytecodeDisassembler.getBytecodeAt(method, bci);
        if (!Bytecodes.isIfBytecode(bytecode)) {
            return true;
        }
        byte[] code = new ResolvedJavaMethodBytecode(method).getCode();
        int targetBCI = bci + Bytes.beS2(code, bci + 1);
        int nextBCI = bci + Bytecodes.lengthOf(bytecode);
        boolean matchingSuccessorFound = false;
        if (trueSuccessorPosition.getBCI() == nextBCI || trueSuccessorPosition.getBCI() == targetBCI) {
            this.assertTrue(this.compareCallContext(trueSuccessorPosition), "call context different from IfNode in trueSuccessor", new Object[0]);
            matchingSuccessorFound = true;
        }
        if (falseSuccessorPosition.getBCI() == nextBCI || falseSuccessorPosition.getBCI() == targetBCI) {
            this.assertTrue(this.compareCallContext(falseSuccessorPosition), "call context different from IfNode in falseSuccessor", new Object[0]);
            matchingSuccessorFound = true;
        }
        this.assertTrue(matchingSuccessorFound, "no matching successor position found in IfNode", new Object[0]);
        this.assertTrue(trueSuccessorPosition.getBCI() != falseSuccessorPosition.getBCI(), "successor positions same in IfNode", new Object[0]);
        return true;
    }

    public void eliminateNegation() {
        AbstractBeginNode oldFalseSuccessor;
        AbstractBeginNode oldTrueSuccessor = this.trueSuccessor;
        this.trueSuccessor = oldFalseSuccessor = this.falseSuccessor;
        this.falseSuccessor = oldTrueSuccessor;
        this.trueSuccessorProbability = 1.0 - this.trueSuccessorProbability;
        this.setCondition(((LogicNegationNode)this.condition).getValue());
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (this.trueSuccessor().next() instanceof DeoptimizeNode) {
            if (this.trueSuccessorProbability != 0.0) {
                CORRECTED_PROBABILITIES.increment(this.getDebug());
                this.trueSuccessorProbability = 0.0;
            }
        } else if (this.falseSuccessor().next() instanceof DeoptimizeNode && this.trueSuccessorProbability != 1.0) {
            CORRECTED_PROBABILITIES.increment(this.getDebug());
            this.trueSuccessorProbability = 1.0;
        }
        if (this.condition() instanceof LogicNegationNode) {
            this.eliminateNegation();
        }
        if (this.condition() instanceof LogicConstantNode) {
            LogicConstantNode c = (LogicConstantNode)this.condition();
            if (c.getValue()) {
                tool.deleteBranch(this.falseSuccessor());
                tool.addToWorkList(this.trueSuccessor());
                this.graph().removeSplit(this, this.trueSuccessor());
            } else {
                tool.deleteBranch(this.trueSuccessor());
                tool.addToWorkList(this.falseSuccessor());
                this.graph().removeSplit(this, this.falseSuccessor());
            }
            return;
        }
        if (tool.allUsagesAvailable() && this.trueSuccessor().hasNoUsages() && this.falseSuccessor().hasNoUsages()) {
            this.pushNodesThroughIf(tool);
            if (this.checkForUnsignedCompare(tool) || this.removeOrMaterializeIf(tool)) {
                return;
            }
        }
        if (this.removeIntermediateMaterialization(tool)) {
            return;
        }
        if (this.conditionalNodeOptimization(tool)) {
            return;
        }
        if (this.switchTransformationOptimization(tool)) {
            return;
        }
        if (this.falseSuccessor().hasNoUsages() && !(this.falseSuccessor() instanceof LoopExitNode) && this.falseSuccessor().next() instanceof IfNode && !(((IfNode)this.falseSuccessor().next()).falseSuccessor() instanceof LoopExitNode)) {
            AbstractBeginNode intermediateBegin = this.falseSuccessor();
            IfNode nextIf = (IfNode)intermediateBegin.next();
            double probabilityB = (1.0 - this.trueSuccessorProbability) * nextIf.trueSuccessorProbability;
            if (this.trueSuccessorProbability < probabilityB && IfNode.prepareForSwap(tool, this.condition(), nextIf.condition())) {
                assert (intermediateBegin.next() == nextIf);
                AbstractBeginNode bothFalseBegin = nextIf.falseSuccessor();
                nextIf.setFalseSuccessor(null);
                intermediateBegin.setNext(null);
                this.setFalseSuccessor(null);
                this.replaceAtPredecessor(nextIf);
                nextIf.setFalseSuccessor(intermediateBegin);
                intermediateBegin.setNext(this);
                this.setFalseSuccessor(bothFalseBegin);
                NodeSourcePosition intermediateBeginPosition = intermediateBegin.getNodeSourcePosition();
                intermediateBegin.setNodeSourcePosition(bothFalseBegin.getNodeSourcePosition());
                bothFalseBegin.setNodeSourcePosition(intermediateBeginPosition);
                nextIf.setTrueSuccessorProbability(probabilityB);
                if (probabilityB == 1.0) {
                    this.setTrueSuccessorProbability(0.0);
                } else {
                    double newProbability = this.trueSuccessorProbability / (1.0 - probabilityB);
                    this.setTrueSuccessorProbability(Math.min(1.0, newProbability));
                }
                return;
            }
        }
        if (this.tryEliminateBoxedReferenceEquals(tool)) {
            return;
        }
    }

    private static boolean isUnboxedFrom(MetaAccessProvider meta, NodeView view, ValueNode x, ValueNode src) {
        if (x == src) {
            return true;
        }
        if (x instanceof UnboxNode) {
            return IfNode.isUnboxedFrom(meta, view, ((UnboxNode)x).getValue(), src);
        }
        if (x instanceof PiNode) {
            PiNode pi = (PiNode)x;
            return IfNode.isUnboxedFrom(meta, view, pi.getOriginalNode(), src);
        }
        if (x instanceof LoadFieldNode) {
            LoadFieldNode load = (LoadFieldNode)x;
            ResolvedJavaType integerType = meta.lookupJavaType(Integer.class);
            if (load.getValue().stamp(view).javaType(meta).equals(integerType)) {
                return IfNode.isUnboxedFrom(meta, view, load.getValue(), src);
            }
            return false;
        }
        return false;
    }

    private boolean tryEliminateBoxedReferenceEquals(SimplifierTool tool) {
        if (!(this.condition instanceof ObjectEqualsNode)) {
            return false;
        }
        MetaAccessProvider meta = tool.getMetaAccess();
        ObjectEqualsNode equalsCondition = (ObjectEqualsNode)this.condition;
        ValueNode x = equalsCondition.getX();
        ValueNode y = equalsCondition.getY();
        ResolvedJavaType integerType = meta.lookupJavaType(Integer.class);
        NodeView view = NodeView.from(tool);
        if (!x.stamp(view).javaType(meta).equals(integerType) && !y.stamp(view).javaType(meta).equals(integerType)) {
            return false;
        }
        if (this.getTrueSuccessorProbability() > 0.4) {
            return false;
        }
        if (this.trueSuccessor instanceof BeginNode || this.trueSuccessor instanceof LoopExitNode) {
            if (!(this.trueSuccessor.next() instanceof EndNode)) {
                return false;
            }
        } else {
            return false;
        }
        UnboxNode unbox = null;
        FixedGuardNode unboxCheck = null;
        for (FixedNode node : this.falseSuccessor.getBlockNodes()) {
            IntegerEqualsNode equals;
            FixedGuardNode fixed;
            if (!(node instanceof BeginNode || node instanceof UnboxNode || node instanceof FixedGuardNode || node instanceof EndNode || node instanceof LoadFieldNode || node instanceof LoopExitNode)) {
                return false;
            }
            if (node instanceof UnboxNode) {
                if (unbox == null) {
                    unbox = (UnboxNode)node;
                } else {
                    return false;
                }
            }
            if (!(node instanceof FixedGuardNode) || !((fixed = (FixedGuardNode)node).condition() instanceof IntegerEqualsNode) || (!IfNode.isUnboxedFrom(meta, view, (equals = (IntegerEqualsNode)fixed.condition()).getX(), x) || !IfNode.isUnboxedFrom(meta, view, equals.getY(), y)) && (!IfNode.isUnboxedFrom(meta, view, equals.getX(), y) || !IfNode.isUnboxedFrom(meta, view, equals.getY(), x))) continue;
            unboxCheck = fixed;
        }
        if (unbox == null || unboxCheck == null) {
            return false;
        }
        this.setCondition(this.graph().addOrUniqueWithInputs(LogicConstantNode.contradiction()));
        return true;
    }

    @Override
    public Node getNextSwitchFoldableBranch() {
        return this.falseSuccessor();
    }

    @Override
    public boolean isInSwitch(ValueNode switchValue) {
        return SwitchFoldable.maybeIsInSwitch(this.condition()) && SwitchFoldable.sameSwitchValue(this.condition(), switchValue);
    }

    @Override
    public void cutOffCascadeNode() {
        this.setTrueSuccessor(null);
    }

    @Override
    public void cutOffLowestCascadeNode() {
        this.setFalseSuccessor(null);
        this.setTrueSuccessor(null);
    }

    @Override
    public AbstractBeginNode getDefault() {
        return this.falseSuccessor();
    }

    @Override
    public ValueNode switchValue() {
        if (SwitchFoldable.maybeIsInSwitch(this.condition())) {
            return ((IntegerEqualsNode)this.condition()).getX();
        }
        return null;
    }

    @Override
    public boolean isNonInitializedProfile() {
        return this.getTrueSuccessorProbability() == 0.5;
    }

    @Override
    public int intKeyAt(int i) {
        assert (i == 0);
        return ((IntegerEqualsNode)this.condition()).getY().asJavaConstant().asInt();
    }

    @Override
    public double keyProbability(int i) {
        assert (i == 0);
        return this.getTrueSuccessorProbability();
    }

    @Override
    public AbstractBeginNode keySuccessor(int i) {
        assert (i == 0);
        return this.trueSuccessor();
    }

    @Override
    public double defaultProbability() {
        return 1.0 - this.getTrueSuccessorProbability();
    }

    private boolean conditionalNodeOptimization(SimplifierTool tool) {
        if (this.trueSuccessor().next() instanceof AbstractEndNode && this.falseSuccessor().next() instanceof AbstractEndNode) {
            NodeView view;
            AbstractEndNode trueEnd = (AbstractEndNode)this.trueSuccessor().next();
            AbstractEndNode falseEnd = (AbstractEndNode)this.falseSuccessor().next();
            if (trueEnd.merge() != falseEnd.merge()) {
                return false;
            }
            if (!(trueEnd.merge() instanceof MergeNode)) {
                return false;
            }
            MergeNode merge = (MergeNode)trueEnd.merge();
            if (!merge.hasExactlyOneUsage() || merge.phis().count() != 1) {
                return false;
            }
            if (this.trueSuccessor().hasAnchored() || this.falseSuccessor().hasAnchored()) {
                return false;
            }
            if (this.falseSuccessor instanceof LoopExitNode && ((LoopExitNode)this.falseSuccessor).stateAfter != null) {
                return false;
            }
            PhiNode phi = merge.phis().first();
            ValueNode falseValue = phi.valueAt(falseEnd);
            ValueNode trueValue = phi.valueAt(trueEnd);
            ValueNode result = ConditionalNode.canonicalizeConditional(this.condition, trueValue, falseValue, phi.stamp(view = NodeView.from(tool)), view);
            if (result != null) {
                if (result.graph() == null) {
                    result = this.graph().addOrUniqueWithInputs(result);
                }
                result = this.proxyReplacement(result);
                phi.setValueAt(trueEnd, result);
                this.removeThroughFalseBranch(tool, merge);
                return true;
            }
        }
        return false;
    }

    private void pushNodesThroughIf(SimplifierTool tool) {
        assert (this.trueSuccessor().hasNoUsages() && this.falseSuccessor().hasNoUsages());
        block0: while (true) {
            AbstractBeginNode trueSucc = this.trueSuccessor();
            AbstractBeginNode falseSucc = this.falseSuccessor();
            if (!(trueSucc instanceof BeginNode) || !(falseSucc instanceof BeginNode) || !(trueSucc.next() instanceof FixedWithNextNode) || !(falseSucc.next() instanceof FixedWithNextNode)) break;
            FixedWithNextNode trueNext = (FixedWithNextNode)trueSucc.next();
            FixedWithNextNode falseNext = (FixedWithNextNode)falseSucc.next();
            NodeClass<? extends Node> nodeClass = trueNext.getNodeClass();
            if (trueNext.getClass() != falseNext.getClass() || trueNext instanceof AbstractBeginNode || !nodeClass.equalInputs(trueNext, falseNext) || !trueNext.valueEquals(falseNext)) break;
            falseNext.replaceAtUsages(trueNext);
            this.graph().removeFixed(falseNext);
            GraphUtil.unlinkFixedNode(trueNext);
            this.graph().addBeforeFixed(this, trueNext);
            Iterator<Node> iterator = trueNext.usages().snapshot().iterator();
            while (true) {
                Node newNode;
                if (!iterator.hasNext()) continue block0;
                Node usage = iterator.next();
                if (!usage.isAlive()) continue;
                NodeClass<? extends Node> usageNodeClass = usage.getNodeClass();
                if (usageNodeClass.valueNumberable() && !usageNodeClass.isLeafNode() && (newNode = this.graph().findDuplicate(usage)) != null) {
                    usage.replaceAtUsagesAndDelete(newNode);
                }
                if (!usage.isAlive()) continue;
                tool.addToWorkList(usage);
            }
            break;
        }
    }

    private boolean checkForUnsignedCompare(SimplifierTool tool) {
        assert (this.trueSuccessor().hasNoUsages() && this.falseSuccessor().hasNoUsages());
        if (this.condition() instanceof IntegerLessThanNode) {
            NodeView view = NodeView.from(tool);
            IntegerLessThanNode lessThan = (IntegerLessThanNode)this.condition();
            Constant y = lessThan.getY().stamp(view).asConstant();
            if (y instanceof PrimitiveConstant && ((PrimitiveConstant)y).asLong() == 0L && this.falseSuccessor().next() instanceof IfNode) {
                IfNode ifNode2 = (IfNode)this.falseSuccessor().next();
                if (ifNode2.condition() instanceof IntegerLessThanNode) {
                    Object newLimit;
                    JavaConstant positive;
                    IntegerLessThanNode lessThan2 = (IntegerLessThanNode)ifNode2.condition();
                    AbstractBeginNode falseSucc = ifNode2.falseSuccessor();
                    AbstractBeginNode trueSucc = ifNode2.trueSuccessor();
                    IntegerBelowNode below = null;
                    if (lessThan2.getX() == lessThan.getX() && lessThan2.getY().stamp(view) instanceof IntegerStamp && ((IntegerStamp)lessThan2.getY().stamp(view)).isPositive() && IfNode.sameDestination(this.trueSuccessor(), ifNode2.falseSuccessor)) {
                        below = this.graph().unique(new IntegerBelowNode(lessThan2.getX(), lessThan2.getY()));
                        AbstractBeginNode tmp = falseSucc;
                        falseSucc = trueSucc;
                        trueSucc = tmp;
                    } else if (lessThan2.getY() == lessThan.getX() && IfNode.sameDestination(this.trueSuccessor(), ifNode2.trueSuccessor) && (positive = lessThan2.getX().asJavaConstant()) != null && positive.asLong() > 0L && positive.asLong() < positive.getJavaKind().getMaxValue()) {
                        newLimit = ConstantNode.forIntegerStamp(lessThan2.getX().stamp(view), positive.asLong() + 1L, this.graph());
                        below = this.graph().unique(new IntegerBelowNode(lessThan.getX(), (ValueNode)newLimit));
                    }
                    if (below != null) {
                        DebugCloseable position = ifNode2.withNodeSourcePosition();
                        newLimit = null;
                        try {
                            ifNode2.setTrueSuccessor(null);
                            ifNode2.setFalseSuccessor(null);
                            IfNode newIfNode = this.graph().add(new IfNode((LogicNode)below, falseSucc, trueSucc, 1.0 - this.trueSuccessorProbability));
                            tool.deleteBranch(this.trueSuccessor);
                            this.graph().removeSplit(this, this.falseSuccessor);
                            ifNode2.predecessor().replaceFirstSuccessor(ifNode2, newIfNode);
                            ifNode2.safeDelete();
                            boolean bl = true;
                            return bl;
                        }
                        catch (Throwable newIfNode) {
                            newLimit = newIfNode;
                            throw newIfNode;
                        }
                        finally {
                            if (position != null) {
                                if (newLimit != null) {
                                    try {
                                        position.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)newLimit).addSuppressed(throwable);
                                    }
                                } else {
                                    position.close();
                                }
                            }
                        }
                    }
                }
            } else if (y instanceof PrimitiveConstant && ((PrimitiveConstant)y).asLong() < 0L && this.falseSuccessor().next() instanceof IfNode) {
                IfNode ifNode2 = (IfNode)this.falseSuccessor().next();
                AbstractBeginNode falseSucc = ifNode2.falseSuccessor();
                AbstractBeginNode trueSucc = ifNode2.trueSuccessor();
                IntegerBelowNode below = null;
                if (ifNode2.condition() instanceof IntegerLessThanNode) {
                    long newLimitValue;
                    ValueNode x = lessThan.getX();
                    IntegerLessThanNode lessThan2 = (IntegerLessThanNode)ifNode2.condition();
                    Constant c2 = lessThan2.getY().stamp(view).asConstant();
                    if (lessThan2.getX() == x && c2 instanceof PrimitiveConstant && ((PrimitiveConstant)c2).asLong() > 0L && x.stamp(view).isCompatible(lessThan.getY().stamp(view)) && x.stamp(view).isCompatible(lessThan2.getY().stamp(view)) && IfNode.sameDestination(this.trueSuccessor(), ifNode2.falseSuccessor) && (newLimitValue = -((PrimitiveConstant)y).asLong() + ((PrimitiveConstant)c2).asLong()) > 0L && newLimitValue <= CodeUtil.maxValue((int)PrimitiveStamp.getBits(x.stamp(view)))) {
                        ConstantNode newLimit = ConstantNode.forIntegerStamp(x.stamp(view), newLimitValue, this.graph());
                        ConstantNode c1 = ConstantNode.forIntegerStamp(x.stamp(view), -((PrimitiveConstant)y).asLong(), this.graph());
                        ValueNode addNode = this.graph().addOrUniqueWithInputs(AddNode.create(x, c1, view));
                        below = this.graph().unique(new IntegerBelowNode(addNode, newLimit));
                    }
                }
                if (below != null) {
                    try (DebugCloseable position = ifNode2.withNodeSourcePosition();){
                        ifNode2.setTrueSuccessor(null);
                        ifNode2.setFalseSuccessor(null);
                        IfNode newIfNode = this.graph().add(new IfNode(below, trueSucc, falseSucc, this.trueSuccessorProbability));
                        tool.deleteBranch(this.trueSuccessor);
                        this.graph().removeSplit(this, this.falseSuccessor);
                        ifNode2.predecessor().replaceFirstSuccessor(ifNode2, newIfNode);
                        ifNode2.safeDelete();
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    public static boolean sameDestination(AbstractBeginNode succ1, AbstractBeginNode succ2) {
        FixedNode next1 = succ1.next();
        FixedNode next2 = succ2.next();
        if (next1 instanceof AbstractEndNode && next2 instanceof AbstractEndNode) {
            AbstractEndNode end1 = (AbstractEndNode)next1;
            AbstractEndNode end2 = (AbstractEndNode)next2;
            if (end1.merge() == end2.merge()) {
                for (PhiNode phi : end1.merge().phis()) {
                    if (phi.valueAt(end1) == phi.valueAt(end2)) continue;
                    return false;
                }
                return true;
            }
        } else if (next1 instanceof DeoptimizeNode && next2 instanceof DeoptimizeNode) {
            DeoptimizeNode deopt1 = (DeoptimizeNode)next1;
            DeoptimizeNode deopt2 = (DeoptimizeNode)next2;
            if (deopt1.getReason() == deopt2.getReason() && deopt1.getAction() == deopt2.getAction()) {
                return true;
            }
        } else if (next1 instanceof LoopExitNode && next2 instanceof LoopExitNode) {
            LoopExitNode exit1 = (LoopExitNode)next1;
            LoopExitNode exit2 = (LoopExitNode)next2;
            if (exit1.loopBegin() == exit2.loopBegin() && exit1.stateAfter() == exit2.stateAfter() && exit1.stateAfter() == null && IfNode.sameDestination(exit1, exit2)) {
                return true;
            }
        } else if (next1 instanceof ReturnNode && next2 instanceof ReturnNode) {
            ReturnNode exit1 = (ReturnNode)next1;
            ReturnNode exit2 = (ReturnNode)next2;
            if (exit1.result() == exit2.result()) {
                return true;
            }
        }
        return false;
    }

    private static boolean prepareForSwap(SimplifierTool tool, LogicNode a, LogicNode b) {
        DebugContext debug = a.getDebug();
        if (a instanceof InstanceOfNode) {
            InstanceOfNode instanceOfA = (InstanceOfNode)a;
            if (b instanceof IsNullNode) {
                IsNullNode isNullNode = (IsNullNode)b;
                if (isNullNode.getValue() == instanceOfA.getValue()) {
                    debug.log("Can swap instanceof and isnull if");
                    return true;
                }
            } else if (b instanceof InstanceOfNode) {
                InstanceOfNode instanceOfB = (InstanceOfNode)b;
                if (!(instanceOfA.getValue() != instanceOfB.getValue() || instanceOfA.type().getType().isInterface() || instanceOfB.type().getType().isInterface() || instanceOfA.type().getType().isAssignableFrom(instanceOfB.type().getType()) || instanceOfB.type().getType().isAssignableFrom(instanceOfA.type().getType()))) {
                    debug.log("Can swap instanceof for types %s and %s", (Object)instanceOfA.type(), (Object)instanceOfB.type());
                    return true;
                }
            }
        } else if (a instanceof CompareNode) {
            CompareNode compareA = (CompareNode)a;
            Condition conditionA = compareA.condition().asCondition();
            if (compareA.unorderedIsTrue()) {
                return false;
            }
            if (b instanceof CompareNode) {
                CompareNode compareB = (CompareNode)b;
                if (compareA == compareB) {
                    debug.log("Same conditions => do not swap and leave the work for global value numbering.");
                    return false;
                }
                if (compareB.unorderedIsTrue()) {
                    return false;
                }
                Condition comparableCondition = null;
                Condition conditionB = compareB.condition().asCondition();
                if (compareB.getX() == compareA.getX() && compareB.getY() == compareA.getY()) {
                    comparableCondition = conditionB;
                } else if (compareB.getX() == compareA.getY() && compareB.getY() == compareA.getX()) {
                    comparableCondition = conditionB.mirror();
                }
                if (comparableCondition != null) {
                    if (conditionA.trueIsDisjoint(comparableCondition)) {
                        debug.log("Can swap disjoint coditions on same values: %s and %s", (Object)conditionA, (Object)comparableCondition);
                        return true;
                    }
                } else if (conditionA == Condition.EQ && conditionB == Condition.EQ) {
                    boolean canSwap = false;
                    if (compareA.getX() == compareB.getX() && IfNode.valuesDistinct(tool, compareA.getY(), compareB.getY())) {
                        canSwap = true;
                    } else if (compareA.getX() == compareB.getY() && IfNode.valuesDistinct(tool, compareA.getY(), compareB.getX())) {
                        canSwap = true;
                    } else if (compareA.getY() == compareB.getX() && IfNode.valuesDistinct(tool, compareA.getX(), compareB.getY())) {
                        canSwap = true;
                    } else if (compareA.getY() == compareB.getY() && IfNode.valuesDistinct(tool, compareA.getX(), compareB.getX())) {
                        canSwap = true;
                    }
                    if (canSwap) {
                        debug.log("Can swap equality condition with one shared and one disjoint value.");
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean valuesDistinct(SimplifierTool tool, ValueNode a, ValueNode b) {
        Boolean equal;
        if (a.isConstant() && b.isConstant() && (equal = tool.getConstantReflection().constantEquals(a.asConstant(), b.asConstant())) != null) {
            return equal == false;
        }
        NodeView view = NodeView.from(tool);
        Stamp stampA = a.stamp(view);
        Stamp stampB = b.stamp(view);
        return stampA.alwaysDistinct(stampB);
    }

    private boolean removeOrMaterializeIf(SimplifierTool tool) {
        FixedNode falseEnd;
        FixedNode trueEnd;
        assert (this.trueSuccessor().hasNoUsages() && this.falseSuccessor().hasNoUsages());
        if (this.trueSuccessor().next() instanceof AbstractEndNode && this.falseSuccessor().next() instanceof AbstractEndNode) {
            trueEnd = (AbstractEndNode)this.trueSuccessor().next();
            falseEnd = (AbstractEndNode)this.falseSuccessor().next();
            AbstractMergeNode merge = ((AbstractEndNode)trueEnd).merge();
            if (this.falseSuccessor instanceof LoopExitNode && ((LoopExitNode)this.falseSuccessor).stateAfter != null) {
                return false;
            }
            if (merge == ((AbstractEndNode)falseEnd).merge() && this.trueSuccessor().anchored().isEmpty() && this.falseSuccessor().anchored().isEmpty()) {
                PhiNode singlePhi = null;
                int distinct = 0;
                for (PhiNode phi : merge.phis()) {
                    ValueNode falseValue;
                    ValueNode trueValue = phi.valueAt((AbstractEndNode)trueEnd);
                    if (trueValue == (falseValue = phi.valueAt((AbstractEndNode)falseEnd))) continue;
                    ++distinct;
                    singlePhi = phi;
                }
                if (distinct == 0) {
                    this.removeThroughFalseBranch(tool, merge);
                    return true;
                }
                if (distinct == 1) {
                    ValueNode falseValue;
                    assert (singlePhi != null);
                    ValueNode trueValue = singlePhi.valueAt((AbstractEndNode)trueEnd);
                    ValueNode conditional = this.canonicalizeConditionalCascade(tool, trueValue, falseValue = singlePhi.valueAt((AbstractEndNode)falseEnd));
                    if (conditional != null) {
                        conditional = this.proxyReplacement(conditional);
                        singlePhi.setValueAt((AbstractEndNode)trueEnd, conditional);
                        this.removeThroughFalseBranch(tool, merge);
                        return true;
                    }
                }
            }
        }
        if (this.trueSuccessor().next() instanceof ReturnNode && this.falseSuccessor().next() instanceof ReturnNode) {
            trueEnd = (ReturnNode)this.trueSuccessor().next();
            falseEnd = (ReturnNode)this.falseSuccessor().next();
            ValueNode trueValue = ((ReturnNode)trueEnd).result();
            ValueNode falseValue = ((ReturnNode)falseEnd).result();
            ValueNode value = null;
            boolean needsProxy = false;
            if (trueValue != null) {
                if (trueValue == falseValue) {
                    value = trueValue;
                } else {
                    value = this.canonicalizeConditionalCascade(tool, trueValue, falseValue);
                    if (value == null) {
                        return false;
                    }
                    needsProxy = true;
                }
            }
            if (this.trueSuccessor() instanceof LoopExitNode) {
                FrameState stateAfter = ((LoopExitNode)this.trueSuccessor()).stateAfter();
                LoopBeginNode loopBegin = ((LoopExitNode)this.trueSuccessor()).loopBegin();
                assert (loopBegin == ((LoopExitNode)this.falseSuccessor()).loopBegin());
                LoopExitNode loopExitNode = this.graph().add(new LoopExitNode(loopBegin));
                loopExitNode.setStateAfter(stateAfter);
                this.graph().addBeforeFixed(this, loopExitNode);
                if (this.graph().hasValueProxies() && needsProxy) {
                    value = this.graph().addOrUnique(new ValueProxyNode(value, loopExitNode));
                }
            }
            ReturnNode newReturn = this.graph().add(new ReturnNode(value));
            this.replaceAtPredecessor(newReturn);
            GraphUtil.killCFG(this);
            return true;
        }
        return false;
    }

    private ValueNode proxyReplacement(ValueNode replacement) {
        if (this.graph().hasValueProxies() && this.trueSuccessor instanceof LoopExitNode && this.falseSuccessor instanceof LoopExitNode) {
            assert (((LoopExitNode)this.trueSuccessor).loopBegin() == ((LoopExitNode)this.falseSuccessor).loopBegin());
            if (this.falseSuccessor.anchored().isEmpty() && this.falseSuccessor.hasUsages()) {
                for (Node n : this.falseSuccessor.usages().snapshot()) {
                    assert (n instanceof ProxyNode);
                    ((ProxyNode)n).setProxyPoint((LoopExitNode)this.trueSuccessor);
                }
            }
            assert (this.trueSuccessor.anchored().isEmpty() && this.falseSuccessor.hasNoUsages());
            return this.graph().addOrUnique(new ValueProxyNode(replacement, (LoopExitNode)this.trueSuccessor));
        }
        return replacement;
    }

    protected void removeThroughFalseBranch(SimplifierTool tool, AbstractMergeNode merge) {
        assert (!(this.falseSuccessor instanceof LoopExitNode) || ((LoopExitNode)this.falseSuccessor).stateAfter == null);
        AbstractBeginNode trueBegin = this.trueSuccessor();
        LogicNode conditionNode = this.condition();
        this.graph().removeSplitPropagate(this, trueBegin);
        tool.addToWorkList(trueBegin);
        if (conditionNode != null) {
            GraphUtil.tryKillUnused(conditionNode);
        }
        if (merge.isAlive() && merge.forwardEndCount() > 1) {
            for (FixedNode fixedNode : merge.forwardEnds()) {
                Node cur;
                for (cur = fixedNode; cur != null && cur.predecessor() instanceof BeginNode; cur = cur.predecessor()) {
                }
                if (cur == null || !(cur.predecessor() instanceof IfNode)) continue;
                tool.addToWorkList(cur.predecessor());
            }
        }
    }

    private ValueNode canonicalizeConditionalViaImplies(ValueNode trueValue, ValueNode falseValue) {
        TriState result;
        ValueNode collapsedTrue = trueValue;
        ValueNode collapsedFalse = falseValue;
        boolean simplify = false;
        if (trueValue instanceof ConditionalNode && (result = this.condition().implies(false, ((ConditionalNode)trueValue).condition())).isKnown()) {
            simplify = true;
            ValueNode valueNode = collapsedTrue = result.toBoolean() ? ((ConditionalNode)trueValue).trueValue() : ((ConditionalNode)trueValue).falseValue();
        }
        if (falseValue instanceof ConditionalNode && (result = this.condition().implies(true, ((ConditionalNode)falseValue).condition())).isKnown()) {
            simplify = true;
            ValueNode valueNode = collapsedFalse = result.toBoolean() ? ((ConditionalNode)falseValue).trueValue() : ((ConditionalNode)falseValue).falseValue();
        }
        if (simplify) {
            return this.graph().unique(new ConditionalNode(this.condition(), collapsedTrue, collapsedFalse));
        }
        return null;
    }

    private List<Node> getNodesForBlock(AbstractBeginNode successor) {
        StructuredGraph.ScheduleResult schedule = this.graph().getLastSchedule();
        if (schedule == null) {
            return null;
        }
        if (schedule.getCFG().getNodeToBlock().isNew(successor)) {
            return null;
        }
        Block block = schedule.getCFG().blockFor(successor);
        if (block == null) {
            return null;
        }
        return schedule.nodesFor(block);
    }

    private boolean isSafeConditionalInput(ValueNode value, AbstractBeginNode successor) {
        assert (successor.hasNoUsages());
        if (value.isConstant() || this.condition.inputs().contains(value)) {
            return true;
        }
        if (this.graph().isAfterFixedReadPhase()) {
            if (value instanceof ParameterNode) {
                return true;
            }
            if (value instanceof FixedNode) {
                List<Node> nodes = this.getNodesForBlock(successor);
                return nodes != null && nodes.size() == 2;
            }
        }
        return false;
    }

    private ValueNode canonicalizeConditionalCascade(SimplifierTool tool, ValueNode trueValue, ValueNode falseValue) {
        if (trueValue.getStackKind() != falseValue.getStackKind()) {
            return null;
        }
        if (trueValue.getStackKind() != JavaKind.Int && trueValue.getStackKind() != JavaKind.Long) {
            return null;
        }
        if (this.isSafeConditionalInput(trueValue, this.trueSuccessor) && this.isSafeConditionalInput(falseValue, this.falseSuccessor)) {
            return this.graph().unique(new ConditionalNode(this.condition(), trueValue, falseValue));
        }
        ValueNode value = this.canonicalizeConditionalViaImplies(trueValue, falseValue);
        if (value != null) {
            return value;
        }
        if (!this.graph().isAfterExpandLogic()) {
            boolean negateCondition;
            ConditionalNode conditional = null;
            ValueNode constant = null;
            if (trueValue instanceof ConditionalNode && falseValue.isConstant()) {
                conditional = (ConditionalNode)trueValue;
                constant = falseValue;
                negateCondition = true;
            } else if (falseValue instanceof ConditionalNode && trueValue.isConstant()) {
                conditional = (ConditionalNode)falseValue;
                constant = trueValue;
                negateCondition = false;
            } else {
                return null;
            }
            boolean negateConditionalCondition = false;
            ValueNode otherValue = null;
            if (constant == conditional.trueValue()) {
                otherValue = conditional.falseValue();
                negateConditionalCondition = false;
            } else if (constant == conditional.falseValue()) {
                otherValue = conditional.trueValue();
                negateConditionalCondition = true;
            }
            if (otherValue != null && otherValue.isConstant()) {
                double shortCutProbability = this.probability(this.trueSuccessor());
                LogicNode newCondition = LogicNode.or(this.condition(), negateCondition, conditional.condition(), negateConditionalCondition, shortCutProbability);
                return this.graph().unique(new ConditionalNode(newCondition, constant, otherValue));
            }
            if (constant.isJavaConstant() && conditional.trueValue().isJavaConstant() && conditional.falseValue().isJavaConstant() && this.condition() instanceof CompareNode && conditional.condition() instanceof CompareNode) {
                boolean sameVars;
                CompareNode condition1 = (CompareNode)this.condition();
                Condition cond1 = condition1.condition().asCondition();
                if (negateCondition) {
                    cond1 = cond1.negate();
                }
                CompareNode condition2 = (CompareNode)conditional.condition();
                Condition cond2 = condition2.condition().asCondition();
                ValueNode x = condition1.getX();
                ValueNode y = condition1.getY();
                ValueNode x2 = condition2.getX();
                ValueNode y2 = condition2.getY();
                boolean bl = sameVars = x == x2 && y == y2;
                if (!sameVars && x == y2 && y == x2) {
                    sameVars = true;
                    cond2 = cond2.mirror();
                }
                if (sameVars) {
                    JavaKind stackKind = conditional.trueValue().stamp(NodeView.from(tool)).getStackKind();
                    assert (!stackKind.isNumericFloat());
                    long c1 = constant.asJavaConstant().asLong();
                    long c2 = conditional.trueValue().asJavaConstant().asLong();
                    long c3 = conditional.falseValue().asJavaConstant().asLong();
                    if ((cond2 = cond2.join(cond1.negate())) == null) {
                        return null;
                    }
                    Condition cond3 = cond1.negate().join(cond2.negate());
                    if (cond3 == null) {
                        return null;
                    }
                    boolean unsigned = cond1.isUnsigned() || cond2.isUnsigned();
                    boolean floatingPoint = x.stamp(NodeView.from(tool)) instanceof FloatStamp;
                    assert (!floatingPoint || y.stamp(NodeView.from(tool)) instanceof FloatStamp);
                    assert (!floatingPoint || !unsigned);
                    long expected1 = IfNode.expectedConstantForNormalize(cond1);
                    long expected2 = IfNode.expectedConstantForNormalize(cond2);
                    long expected3 = IfNode.expectedConstantForNormalize(cond3);
                    if (c1 != expected1 || c2 != expected2 || c3 != expected3) {
                        if (c1 == 0L - expected1 && c2 == 0L - expected2 && c3 == 0L - expected3) {
                            ValueNode tmp = x;
                            x = y;
                            y = tmp;
                        } else {
                            return null;
                        }
                    }
                    if (floatingPoint) {
                        boolean unorderedLess = false;
                        if (((FloatStamp)x.stamp).canBeNaN() || ((FloatStamp)y.stamp).canBeNaN()) {
                            long unorderedValue;
                            long l = condition1.unorderedIsTrue() ? c1 : (unorderedValue = condition2.unorderedIsTrue() ? c2 : c3);
                            if (unorderedValue == 0L) {
                                return null;
                            }
                            unorderedLess = unorderedValue == -1L;
                        }
                        return this.graph().unique(new FloatNormalizeCompareNode(x, y, stackKind, unorderedLess));
                    }
                    return this.graph().unique(new IntegerNormalizeCompareNode(x, y, stackKind, unsigned));
                }
            }
        }
        return null;
    }

    private static long expectedConstantForNormalize(Condition condition) {
        if (condition == Condition.EQ) {
            return 0L;
        }
        if (condition == Condition.LT || condition == Condition.BT) {
            return -1L;
        }
        assert (condition == Condition.GT || condition == Condition.AT);
        return 1L;
    }

    private boolean removeIntermediateMaterialization(SimplifierTool tool) {
        if (!(this.predecessor() instanceof AbstractMergeNode) || this.predecessor() instanceof LoopBeginNode) {
            return false;
        }
        AbstractMergeNode merge = (AbstractMergeNode)this.predecessor();
        if (!(this.condition() instanceof CompareNode)) {
            return false;
        }
        CompareNode compare = (CompareNode)this.condition();
        if (compare.getUsageCount() != 1) {
            return false;
        }
        NodeIterable<Node> mergeUsages = merge.usages();
        if (mergeUsages.count() != 1) {
            return false;
        }
        Node singleUsage = mergeUsages.first();
        if (!(singleUsage instanceof ValuePhiNode) || singleUsage != compare.getX() && singleUsage != compare.getY()) {
            return false;
        }
        if (this.trueSuccessor().isUsedAsGuardInput() || this.falseSuccessor().isUsedAsGuardInput()) {
            return false;
        }
        ValuePhiNode phi = (ValuePhiNode)singleUsage;
        NodeIterable<Node> phiUsages = phi.usages();
        for (Node usage : phiUsages) {
            ValueProxyNode proxy;
            if (usage == compare || usage == merge.stateAfter() || usage instanceof ValueProxyNode && ((proxy = (ValueProxyNode)usage).proxyPoint() == this.trueSuccessor || proxy.proxyPoint() == this.falseSuccessor)) continue;
            return false;
        }
        List mergePredecessors = merge.cfgPredecessors().snapshot();
        assert (phi.valueCount() == merge.forwardEndCount());
        Constant[] xs = IfNode.constantValues(compare.getX(), merge, false);
        Constant[] ys = IfNode.constantValues(compare.getY(), merge, false);
        if (xs == null || ys == null) {
            return false;
        }
        if (merge.stateAfter() != null && !GraphUtil.mayRemoveSplit(this)) {
            return false;
        }
        ArrayList<EndNode> falseEnds = new ArrayList<EndNode>(mergePredecessors.size());
        ArrayList<EndNode> trueEnds = new ArrayList<EndNode>(mergePredecessors.size());
        EconomicMap phiValues = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)mergePredecessors.size());
        AbstractBeginNode oldFalseSuccessor = this.falseSuccessor();
        AbstractBeginNode oldTrueSuccessor = this.trueSuccessor();
        this.setFalseSuccessor(null);
        this.setTrueSuccessor(null);
        Iterator ends = mergePredecessors.iterator();
        for (int i = 0; i < xs.length; ++i) {
            EndNode endNode = (EndNode)ends.next();
            phiValues.put((Object)endNode, (Object)phi.valueAt(endNode));
            if (compare.condition().foldCondition(xs[i], ys[i], tool.getConstantReflection(), compare.unorderedIsTrue())) {
                trueEnds.add(endNode);
                continue;
            }
            falseEnds.add(endNode);
        }
        assert (!ends.hasNext());
        assert (falseEnds.size() + trueEnds.size() == xs.length);
        this.connectEnds(falseEnds, phi, (EconomicMap<AbstractEndNode, ValueNode>)phiValues, oldFalseSuccessor, merge, tool);
        this.connectEnds(trueEnds, phi, (EconomicMap<AbstractEndNode, ValueNode>)phiValues, oldTrueSuccessor, merge, tool);
        if (this.trueSuccessorProbability == 0.0) {
            for (AbstractEndNode abstractEndNode : trueEnds) {
                IfNode.propagateZeroProbability(abstractEndNode);
            }
        }
        if (this.trueSuccessorProbability == 1.0) {
            for (AbstractEndNode abstractEndNode : falseEnds) {
                IfNode.propagateZeroProbability(abstractEndNode);
            }
        }
        if (falseEnds.isEmpty()) {
            GraphUtil.killCFG(oldFalseSuccessor);
        }
        if (trueEnds.isEmpty()) {
            GraphUtil.killCFG(oldTrueSuccessor);
        }
        GraphUtil.killCFG(merge);
        assert (!merge.isAlive()) : merge;
        assert (!phi.isAlive()) : phi;
        assert (!compare.isAlive()) : compare;
        assert (!this.isAlive()) : this;
        return true;
    }

    private static void propagateZeroProbability(FixedNode startNode) {
        FixedNode prev = null;
        for (FixedNode node : GraphUtil.predecessorIterable(startNode)) {
            if (node instanceof IfNode) {
                IfNode ifNode = (IfNode)node;
                if (ifNode.trueSuccessor() == prev) {
                    if (ifNode.trueSuccessorProbability == 0.0) {
                        return;
                    }
                    if (ifNode.trueSuccessorProbability == 1.0) continue;
                    ifNode.setTrueSuccessorProbability(0.0);
                    return;
                }
                if (ifNode.falseSuccessor() == prev) {
                    if (ifNode.trueSuccessorProbability == 1.0) {
                        return;
                    }
                    if (ifNode.trueSuccessorProbability == 0.0) continue;
                    ifNode.setTrueSuccessorProbability(1.0);
                    return;
                }
                throw new GraalError("Illegal state");
            }
            if (node instanceof AbstractMergeNode && !(node instanceof LoopBeginNode)) {
                for (AbstractEndNode endNode : ((AbstractMergeNode)node).cfgPredecessors()) {
                    IfNode.propagateZeroProbability(endNode);
                }
                return;
            }
            prev = node;
        }
    }

    private void connectEnds(List<EndNode> ends, ValuePhiNode phi, EconomicMap<AbstractEndNode, ValueNode> phiValues, AbstractBeginNode successor, AbstractMergeNode oldMerge, SimplifierTool tool) {
        if (!ends.isEmpty()) {
            ValueProxyNode valueProxy = null;
            if (successor instanceof LoopExitNode) {
                for (Node usage : phi.usages()) {
                    if (!(usage instanceof ValueProxyNode) || ((ValueProxyNode)usage).proxyPoint() != successor) continue;
                    valueProxy = (ValueProxyNode)usage;
                }
            }
            ValueProxyNode proxy = valueProxy;
            if (ends.size() == 1) {
                AbstractEndNode end = ends.get(0);
                if (proxy != null) {
                    phi.replaceAtUsages((Node)phiValues.get((Object)end), (Node n) -> n == proxy);
                }
                ((FixedWithNextNode)end.predecessor()).setNext(successor);
                oldMerge.removeEnd(end);
                GraphUtil.killCFG(end);
            } else {
                NodeView view = NodeView.from(tool);
                AbstractMergeNode newMerge = this.graph().add(new MergeNode());
                PhiNode oldPhi = (PhiNode)oldMerge.usages().first();
                PhiNode newPhi = this.graph().addWithoutUnique(new ValuePhiNode(oldPhi.stamp(view), newMerge));
                if (proxy != null) {
                    phi.replaceAtUsages((Node)newPhi, (Node n) -> n == proxy);
                }
                for (EndNode end : ends) {
                    newPhi.addInput((ValueNode)phiValues.get((Object)end));
                    newMerge.addForwardEnd(end);
                }
                FrameState stateAfter = oldMerge.stateAfter();
                if (stateAfter != null) {
                    stateAfter = stateAfter.duplicate();
                    stateAfter.replaceFirstInput(oldPhi, newPhi);
                    newMerge.setStateAfter(stateAfter);
                }
                newMerge.setNext(successor);
            }
            tool.addToWorkList(successor);
        }
    }

    public static Constant[] constantValues(ValueNode node, AbstractMergeNode merge, boolean allowNull) {
        PhiNode phi;
        if (node.isConstant()) {
            Object[] result = new Constant[merge.forwardEndCount()];
            Arrays.fill(result, node.asConstant());
            return result;
        }
        if (node instanceof PhiNode && (phi = (PhiNode)node).merge() == merge && phi instanceof ValuePhiNode && phi.valueCount() == merge.forwardEndCount()) {
            Constant[] result = new Constant[merge.forwardEndCount()];
            int i = 0;
            for (ValueNode n : phi.values()) {
                if (!allowNull && !n.isConstant()) {
                    return null;
                }
                result[i++] = n.asConstant();
            }
            return result;
        }
        return null;
    }

    @Override
    public AbstractBeginNode getPrimarySuccessor() {
        return null;
    }

    public AbstractBeginNode getSuccessor(boolean result) {
        return result ? this.trueSuccessor() : this.falseSuccessor();
    }

    @Override
    public boolean setProbability(AbstractBeginNode successor, double value) {
        if (successor == this.trueSuccessor()) {
            this.setTrueSuccessorProbability(value);
            return true;
        }
        if (successor == this.falseSuccessor()) {
            this.setTrueSuccessorProbability(1.0 - value);
            return true;
        }
        return false;
    }

    @Override
    public int getSuccessorCount() {
        return 2;
    }

    public static enum NodeColor {
        NONE,
        CONDITION_USAGE,
        TRUE_BRANCH,
        FALSE_BRANCH,
        PHI_MIXED,
        MIXED;

    }
}

