/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;

@NodeInfo
public final class DynamicPiNode
extends PiNode {
    public static final NodeClass<DynamicPiNode> TYPE = NodeClass.create(DynamicPiNode.class);
    @Node.Input
    ValueNode typeMirror;
    private final boolean exact;

    protected DynamicPiNode(ValueNode object, GuardingNode guard, ValueNode typeMirror, boolean exact) {
        super(TYPE, object, StampFactory.object(), guard);
        this.typeMirror = typeMirror;
        this.exact = exact;
    }

    public static ValueNode create(Assumptions assumptions, ConstantReflectionProvider constantReflection, ValueNode object, GuardingNode guard, ValueNode typeMirror, boolean exact) {
        ValueNode synonym = DynamicPiNode.findSynonym(assumptions, constantReflection, object, guard, typeMirror, exact);
        if (synonym != null) {
            return synonym;
        }
        return new DynamicPiNode(object, guard, typeMirror, exact);
    }

    public static ValueNode create(Assumptions assumptions, ConstantReflectionProvider constantReflection, ValueNode object, GuardingNode guard, ValueNode typeMirror) {
        return DynamicPiNode.create(assumptions, constantReflection, object, guard, typeMirror, false);
    }

    public boolean isExact() {
        return this.exact;
    }

    private static ValueNode findSynonym(Assumptions assumptions, ConstantReflectionProvider constantReflection, ValueNode object, GuardingNode guard, ValueNode typeMirror, boolean exact) {
        ResolvedJavaType t;
        if (typeMirror.isConstant() && (t = constantReflection.asJavaType(typeMirror.asConstant())) != null) {
            Stamp staticPiStamp;
            if (t.isPrimitive()) {
                staticPiStamp = StampFactory.alwaysNull();
            } else {
                TypeReference type = exact ? TypeReference.createExactTrusted(t) : TypeReference.createTrusted(assumptions, t);
                staticPiStamp = StampFactory.object(type);
            }
            return PiNode.create(object, staticPiStamp, (ValueNode)((Object)guard));
        }
        return null;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ValueNode synonym = DynamicPiNode.findSynonym(tool.getAssumptions(), tool.getConstantReflection(), this.object, this.guard, this.typeMirror, this.exact);
        if (synonym != null) {
            return synonym;
        }
        return this;
    }
}

