/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop;

import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.loop.DerivedInductionVariable;
import org.graalvm.compiler.loop.InductionVariable;
import org.graalvm.compiler.loop.LoopEx;
import org.graalvm.compiler.loop.MathUtil;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.util.GraphUtil;

public class DerivedScaledInductionVariable
extends DerivedInductionVariable {
    private final ValueNode scale;
    private final ValueNode value;

    public DerivedScaledInductionVariable(LoopEx loop, InductionVariable base, ValueNode scale, ValueNode value) {
        super(loop, base);
        this.scale = scale;
        this.value = value;
    }

    public DerivedScaledInductionVariable(LoopEx loop, InductionVariable base, NegateNode value) {
        super(loop, base);
        this.scale = ConstantNode.forIntegerStamp(value.stamp(NodeView.DEFAULT), -1L, value.graph());
        this.value = value;
    }

    public ValueNode getScale() {
        return this.scale;
    }

    @Override
    public ValueNode valueNode() {
        return this.value;
    }

    @Override
    public InductionVariable.Direction direction() {
        InductionVariable.Direction baseDirection = this.base.direction();
        if (baseDirection == null) {
            return null;
        }
        Stamp stamp = this.scale.stamp(NodeView.DEFAULT);
        if (stamp instanceof IntegerStamp) {
            IntegerStamp integerStamp = (IntegerStamp)stamp;
            if (integerStamp.isStrictlyPositive()) {
                return baseDirection;
            }
            if (integerStamp.isStrictlyNegative()) {
                return baseDirection.opposite();
            }
        }
        return null;
    }

    @Override
    public ValueNode initNode() {
        return MathUtil.mul(this.graph(), this.base.initNode(), this.scale);
    }

    @Override
    public ValueNode strideNode() {
        return MathUtil.mul(this.graph(), this.base.strideNode(), this.scale);
    }

    @Override
    public boolean isConstantInit() {
        return this.scale.isConstant() && this.base.isConstantInit();
    }

    @Override
    public boolean isConstantStride() {
        return this.scale.isConstant() && this.base.isConstantStride();
    }

    @Override
    public long constantInit() {
        return this.base.constantInit() * this.scale.asJavaConstant().asLong();
    }

    @Override
    public long constantStride() {
        return this.base.constantStride() * this.scale.asJavaConstant().asLong();
    }

    @Override
    public ValueNode extremumNode(boolean assumeLoopEntered, Stamp stamp) {
        return MathUtil.mul(this.graph(), this.base.extremumNode(assumeLoopEntered, stamp), IntegerConvertNode.convert(this.scale, stamp, this.graph(), NodeView.DEFAULT));
    }

    @Override
    public ValueNode exitValueNode() {
        return MathUtil.mul(this.graph(), this.base.exitValueNode(), this.scale);
    }

    @Override
    public boolean isConstantExtremum() {
        return this.scale.isConstant() && this.base.isConstantExtremum();
    }

    @Override
    public long constantExtremum() {
        return this.base.constantExtremum() * this.scale.asJavaConstant().asLong();
    }

    @Override
    public void deleteUnusedNodes() {
        GraphUtil.tryKillUnused(this.scale);
    }

    @Override
    public boolean isConstantScale(InductionVariable ref) {
        return super.isConstantScale(ref) || this.scale.isConstant() && this.base.isConstantScale(ref);
    }

    @Override
    public long constantScale(InductionVariable ref) {
        assert (this.isConstantScale(ref));
        if (super.isConstantScale(ref)) {
            return super.constantScale(ref);
        }
        return this.scale.asJavaConstant().asLong() * this.base.constantScale(ref);
    }

    @Override
    public boolean offsetIsZero(InductionVariable ref) {
        if (super.offsetIsZero(ref)) {
            return true;
        }
        return this.base.offsetIsZero(ref);
    }

    @Override
    public ValueNode offsetNode(InductionVariable ref) {
        assert (!this.offsetIsZero(ref));
        return null;
    }

    public String toString() {
        return String.format("DerivedScaleInductionVariable base (%s) %s %s", this.base, this.value.getNodeClass().shortName(), this.scale);
    }
}

