/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.util;

import java.util.EnumSet;
import java.util.Objects;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.lir.InstructionValueConsumer;
import org.graalvm.compiler.lir.InstructionValueProcedure;
import org.graalvm.compiler.lir.LIRInstruction;

public final class IndexedValueMap {
    private Value[] values;

    public IndexedValueMap() {
        this.values = Value.NO_VALUES;
    }

    public IndexedValueMap(IndexedValueMap other) {
        int limit;
        for (limit = other.values.length; limit > 0 && other.values[limit - 1] == null; --limit) {
        }
        if (limit == 0) {
            this.values = Value.NO_VALUES;
        } else {
            this.values = new Value[limit];
            System.arraycopy(other.values, 0, this.values, 0, this.values.length);
        }
    }

    public Value get(int index) {
        return this.values[index];
    }

    public void put(int index, Value value) {
        if (this.values.length <= index) {
            if (value == null) {
                return;
            }
            Value[] newValues = new Value[index + 1];
            if (this.values.length > 0) {
                System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            }
            this.values = newValues;
            this.values[index] = value;
        } else {
            this.values[index] = value;
        }
    }

    public void putAll(IndexedValueMap stack) {
        Value[] otherValues = stack.values;
        int limit = otherValues.length;
        if (limit > this.values.length) {
            while (limit > 0 && otherValues[limit - 1] == null) {
                --limit;
            }
            if (limit > this.values.length) {
                Value[] newValues = new Value[limit];
                System.arraycopy(this.values, 0, newValues, 0, this.values.length);
                this.values = newValues;
            }
        }
        for (int i = 0; i < limit; ++i) {
            Value value = otherValues[i];
            if (value == null) continue;
            this.values[i] = value;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof IndexedValueMap) {
            int i;
            IndexedValueMap that = (IndexedValueMap)other;
            int limit = Math.min(this.values.length, that.values.length);
            for (i = 0; i < limit; ++i) {
                if (Objects.equals(this.values[i], that.values[i])) continue;
                return false;
            }
            for (i = limit; i < this.values.length; ++i) {
                if (this.values[i] == null) continue;
                return false;
            }
            for (i = limit; i < that.values.length; ++i) {
                if (that.values[i] == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void forEach(LIRInstruction inst, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags, InstructionValueProcedure proc) {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            this.values[i] = proc.doValue(inst, this.values[i], mode, flags);
        }
    }

    public void visitEach(LIRInstruction inst, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags, InstructionValueConsumer consumer) {
        for (Value v : this.values) {
            if (v == null) continue;
            consumer.visitValue(inst, v, mode, flags);
        }
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        boolean comma = false;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            if (comma) {
                sb.append(", ");
            } else {
                comma = true;
            }
            sb.append(i);
            sb.append(": ");
            sb.append(this.values[i]);
        }
        sb.append(']');
        return sb.toString();
    }
}

