/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.stackslotalloc;

import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.lir.VirtualStackSlot;

public final class StackInterval {
    private static final int INVALID_START = Integer.MAX_VALUE;
    private static final int INVALID_END = Integer.MIN_VALUE;
    private final VirtualStackSlot operand;
    private StackInterval hint;
    private final ValueKind<?> kind;
    private int from = Integer.MAX_VALUE;
    private int to = Integer.MIN_VALUE;
    private StackSlot location;

    public StackInterval(VirtualStackSlot operand, ValueKind<?> kind) {
        this.operand = operand;
        this.kind = kind;
    }

    public boolean verify(int maxOpId) {
        assert (0 <= this.from && this.from <= this.to && this.to <= maxOpId + 1) : String.format("from %d, to %d, maxOpId %d", this.from, this.to, maxOpId);
        return true;
    }

    public VirtualStackSlot getOperand() {
        return this.operand;
    }

    public void addTo(int opId) {
        if (opId >= this.to) {
            this.to = opId;
        }
    }

    protected void addFrom(int opId) {
        if (this.from > opId) {
            this.from = opId;
            if (this.to == Integer.MIN_VALUE) {
                this.to = opId;
            }
        }
    }

    public ValueKind<?> kind() {
        return this.kind;
    }

    public StackSlot location() {
        return this.location;
    }

    public void setLocation(StackSlot location) {
        this.location = location;
    }

    public int from() {
        return this.from;
    }

    public int to() {
        return this.to;
    }

    public void fixFrom() {
        if (this.from == Integer.MAX_VALUE) {
            this.from = 0;
        }
    }

    public boolean isFixed() {
        return this.from == 0;
    }

    public String toString() {
        return String.format("SI[%d-%d] k=%s o=%s l=%s h=%s", new Object[]{this.from, this.to, this.kind, this.operand, this.location, this.hint != null ? this.hint.getOperand() : "null"});
    }

    public void setLocationHint(StackInterval locationHint) {
        this.hint = locationHint;
    }

    public StackInterval locationHint() {
        return this.hint;
    }
}

