/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.sparc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARC;
import org.graalvm.compiler.asm.sparc.SPARCAddress;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.sparc.SPARCDelayedControlTransfer;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;
import org.graalvm.compiler.lir.sparc.SPARCMove;

@Opcode(value="SAVE_REGISTER")
public class SPARCSaveRegistersOp
extends StandardOp.SaveRegistersOp
implements SPARCLIRInstructionMixin {
    public static final LIRInstructionClass<SPARCSaveRegistersOp> TYPE = LIRInstructionClass.create(SPARCSaveRegistersOp.class);
    public static final Register RETURN_REGISTER_STORAGE = SPARC.d62;
    public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(32);
    private final SPARCLIRInstructionMixin.SPARCLIRInstructionMixinStore store = new SPARCLIRInstructionMixin.SPARCLIRInstructionMixinStore(SIZE);

    public SPARCSaveRegistersOp(Register[] savedRegisters, AllocatableValue[] savedRegisterLocations) {
        super(TYPE, savedRegisters, savedRegisterLocations);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb) {
        SPARCMacroAssembler masm = (SPARCMacroAssembler)crb.asm;
        SPARCAddress slot0Address = (SPARCAddress)crb.asAddress((Value)this.slots[0]);
        masm.stx(SPARC.i0, slot0Address);
        masm.lddf(slot0Address, RETURN_REGISTER_STORAGE);
        for (int i = 0; i < this.savedRegisters.length; ++i) {
            if (this.savedRegisters[i] == null) continue;
            assert (ValueUtil.isStackSlot((Value)this.slots[i])) : "not a StackSlot: " + this.slots[i];
            Register savedRegister = this.savedRegisters[i];
            StackSlot slot = ValueUtil.asStackSlot((Value)this.slots[i]);
            SPARCAddress slotAddress = (SPARCAddress)crb.asAddress((Value)slot);
            RegisterValue input = savedRegister.asValue(slot.getValueKind());
            SPARCMove.emitStore((Value)input, slotAddress, slot.getPlatformKind(), SPARCDelayedControlTransfer.DUMMY, null, crb, masm);
        }
    }

    @Override
    public SPARCLIRInstructionMixin.SPARCLIRInstructionMixinStore getSPARCLIRInstructionStore() {
        return this.store;
    }
}

