/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.sparc;

import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import jdk.vm.ci.sparc.SPARC;
import jdk.vm.ci.sparc.SPARCKind;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstruction;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;
import org.graalvm.compiler.lir.sparc.SPARCTailDelayedLIRInstruction;

public final class SPARCOPFOp
extends SPARCLIRInstruction
implements SPARCTailDelayedLIRInstruction {
    public static final LIRInstructionClass<SPARCOPFOp> TYPE = LIRInstructionClass.create(SPARCOPFOp.class);
    public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(1);
    @Opcode
    protected final SPARCAssembler.Opfs opf;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue rs1;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue rs2;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue rd;
    @LIRInstruction.State
    protected LIRFrameState state;

    public SPARCOPFOp(SPARCAssembler.Opfs opf, AllocatableValue rs2, AllocatableValue rd) {
        this(opf, (AllocatableValue)SPARC.g0.asValue((ValueKind)LIRKind.value((PlatformKind)SPARCKind.SINGLE)), rs2, rd);
    }

    public SPARCOPFOp(SPARCAssembler.Opfs opf, AllocatableValue rs1, AllocatableValue rs2, AllocatableValue rd) {
        this(opf, rs1, rs2, rd, null);
    }

    public SPARCOPFOp(SPARCAssembler.Opfs opf, AllocatableValue rs1, AllocatableValue rs2, AllocatableValue rd, LIRFrameState state) {
        super(TYPE, SIZE);
        this.opf = opf;
        this.rs1 = rs1;
        this.rs2 = rs2;
        this.rd = rd;
        this.state = state;
    }

    @Override
    protected void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        this.getDelayedControlTransfer().emitControlTransfer(crb, masm);
        if (this.state != null) {
            crb.recordImplicitException(masm.position(), this.state);
        }
        SPARCAssembler.OpfOp.emit(masm, this.opf, ValueUtil.asRegister((Value)this.rs1), ValueUtil.asRegister((Value)this.rs2), ValueUtil.asRegister((Value)this.rd));
    }
}

