/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.sparc;

import org.graalvm.compiler.lir.sparc.SPARCDelayedControlTransfer;

public interface SPARCLIRInstructionMixin {
    default public boolean leavesRegisterWindow() {
        return false;
    }

    default public SizeEstimate estimateSize() {
        return this.getSPARCLIRInstructionStore().estimate;
    }

    public SPARCLIRInstructionMixinStore getSPARCLIRInstructionStore();

    public static class SPARCLIRInstructionMixinStore {
        public final SizeEstimate estimate;
        public SPARCDelayedControlTransfer delayedControlTransfer = SPARCDelayedControlTransfer.DUMMY;

        public SPARCLIRInstructionMixinStore(SizeEstimate estimate) {
            this.estimate = estimate;
        }

        public String toString() {
            return this.estimate != null ? this.estimate.toString() : "";
        }
    }

    public static class SizeEstimate {
        private static final SizeEstimate[] cache = new SizeEstimate[5];
        public final int instructionSize;
        public final int constantSize;

        public SizeEstimate(int instructionSize, int constantSize) {
            this.instructionSize = instructionSize;
            this.constantSize = constantSize;
        }

        public static SizeEstimate create(int instructionSize, int constantSize) {
            if (constantSize == 0 && instructionSize < cache.length) {
                return cache[instructionSize];
            }
            return new SizeEstimate(instructionSize, constantSize);
        }

        public static SizeEstimate create(int instructionSize) {
            if (instructionSize < cache.length) {
                return cache[instructionSize];
            }
            return new SizeEstimate(instructionSize, 0);
        }

        public String toString() {
            return "SE[i=" + this.instructionSize + ", c=" + this.constantSize + "]";
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                SizeEstimate.cache[i] = new SizeEstimate(i, 0);
            }
        }
    }
}

