/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.sparc;

import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ValueKind;
import jdk.vm.ci.sparc.SPARCKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.framemap.FrameMap;

public final class SPARCFrameMap
extends FrameMap {
    public SPARCFrameMap(CodeCacheProvider codeCache, RegisterConfig registerConfig, FrameMap.ReferenceMapBuilderFactory referenceMapFactory) {
        super(codeCache, registerConfig, referenceMapFactory);
        this.spillSize = this.initialSpillSize = 0;
    }

    @Override
    public int totalFrameSize() {
        return this.frameSize();
    }

    @Override
    public int currentFrameSize() {
        return this.alignFrameSize(128 + this.outgoingSize + this.spillSize);
    }

    @Override
    public int spillSlotSize(ValueKind<?> kind) {
        return kind.getPlatformKind().getSizeInBytes();
    }

    @Override
    public int offsetForStackSlot(StackSlot slot) {
        assert (!slot.getRawAddFrameSize() && slot.getRawOffset() < this.outgoingSize + 128 || slot.getRawAddFrameSize() && slot.getRawOffset() < 0 && -slot.getRawOffset() <= this.spillSize || slot.getRawAddFrameSize() && slot.getRawOffset() >= 0) : String.format("RawAddFrameSize: %b RawOffset: 0x%x spillSize: 0x%x outgoingSize: 0x%x", slot.getRawAddFrameSize(), slot.getRawOffset(), this.spillSize, this.outgoingSize);
        return super.offsetForStackSlot(slot);
    }

    @Override
    public boolean frameNeedsAllocating() {
        return super.frameNeedsAllocating() || this.spillSize > 0;
    }

    public StackSlot allocateDeoptimizationRescueSlot() {
        assert (this.spillSize == this.initialSpillSize) : "Deoptimization rescue slot must be the first stack slot";
        return this.allocateSpillSlot(LIRKind.value((PlatformKind)SPARCKind.XWORD));
    }
}

