/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.sparc;

import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstruction;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;
import org.graalvm.compiler.lir.sparc.SPARCTailDelayedLIRInstruction;

public class SPARCFloatCompareOp
extends SPARCLIRInstruction
implements SPARCTailDelayedLIRInstruction {
    public static final LIRInstructionClass<SPARCFloatCompareOp> TYPE = LIRInstructionClass.create(SPARCFloatCompareOp.class);
    public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(1);
    private final SPARCAssembler.CC cc;
    @Opcode
    protected final SPARCAssembler.Opfs opf;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue a;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue b;

    public SPARCFloatCompareOp(SPARCAssembler.Opfs opf, SPARCAssembler.CC cc, AllocatableValue a, AllocatableValue b) {
        super(TYPE, SIZE);
        this.cc = cc;
        this.opf = opf;
        this.a = a;
        this.b = b;
    }

    @Override
    protected void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        this.getDelayedControlTransfer().emitControlTransfer(crb, masm);
        SPARCAssembler.OpfOp.emitFcmp(masm, this.opf, this.cc, ValueUtil.asRegister((Value)this.a), ValueUtil.asRegister((Value)this.b));
    }

    @Override
    public void verify() {
        assert (this.a.getPlatformKind().equals(this.b.getPlatformKind())) : "a: " + this.a + " b: " + this.b;
        assert (this.opf.equals((Object)SPARCAssembler.Opfs.Fcmpd) || this.opf.equals((Object)SPARCAssembler.Opfs.Fcmps)) : this.opf;
    }
}

