/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.sparc;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARC;
import jdk.vm.ci.sparc.SPARCKind;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.SwitchStrategy;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.sparc.SPARCBlockEndOp;
import org.graalvm.compiler.lir.sparc.SPARCDelayedControlTransfer;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstruction;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;
import org.graalvm.compiler.lir.sparc.SPARCMove;
import org.graalvm.compiler.lir.sparc.SPARCOP3Op;

public class SPARCControlFlow {
    private static final int maximumSelfOffsetInstructions = 10;

    public static boolean isShortBranch(SPARCAssembler asm, int position, Assembler.LabelHint hint, Label label) {
        int disp = 0;
        boolean dispValid = true;
        if (label.isBound()) {
            disp = label.position() - position;
        } else if (hint != null && hint.isValid()) {
            disp = hint.getTarget() - hint.getPosition();
        } else {
            dispValid = false;
        }
        if (dispValid) {
            disp = disp < 0 ? (disp -= 10 * asm.target.wordSize) : (disp += 10 * asm.target.wordSize);
            return SPARCAssembler.isSimm10(disp >> 2);
        }
        if (hint == null) {
            asm.requestLabelHint(label);
        }
        return false;
    }

    private static boolean emitBranch(CompilationResultBuilder crb, SPARCMacroAssembler masm, SPARCKind kind, SPARCAssembler.ConditionFlag conditionFlag, LabelRef trueDestination, LabelRef falseDestination, boolean withDelayedNop, double trueDestinationProbability) {
        SPARCAssembler.BranchPredict predictTaken;
        boolean needJump;
        Label actualTarget;
        SPARCAssembler.ConditionFlag actualConditionFlag;
        if (falseDestination != null && crb.isSuccessorEdge(trueDestination)) {
            actualConditionFlag = conditionFlag != null ? conditionFlag.negate() : null;
            actualTarget = falseDestination.label();
            needJump = false;
            predictTaken = trueDestinationProbability < 0.5 ? SPARCAssembler.BranchPredict.PREDICT_TAKEN : SPARCAssembler.BranchPredict.PREDICT_NOT_TAKEN;
        } else {
            actualConditionFlag = conditionFlag;
            actualTarget = trueDestination.label();
            needJump = falseDestination != null && !crb.isSuccessorEdge(falseDestination);
            SPARCAssembler.BranchPredict branchPredict = predictTaken = trueDestinationProbability > 0.5 ? SPARCAssembler.BranchPredict.PREDICT_TAKEN : SPARCAssembler.BranchPredict.PREDICT_NOT_TAKEN;
        }
        if (!withDelayedNop && needJump) {
            return false;
        }
        if (kind.isFloat()) {
            SPARCAssembler.FBPCC.emit(masm, SPARCAssembler.CC.Fcc0, actualConditionFlag, SPARCAssembler.Annul.NOT_ANNUL, predictTaken, actualTarget);
        } else {
            assert (kind.isInteger());
            SPARCAssembler.CC cc = kind.equals((Object)SPARCKind.WORD) ? SPARCAssembler.CC.Icc : SPARCAssembler.CC.Xcc;
            SPARCAssembler.BPCC.emit(masm, cc, actualConditionFlag, SPARCAssembler.Annul.NOT_ANNUL, predictTaken, actualTarget);
        }
        if (withDelayedNop) {
            masm.nop();
        }
        if (needJump) {
            masm.jmp(falseDestination.label());
        }
        return true;
    }

    public static SPARCAssembler.ConditionFlag fromCondition(boolean integer, Condition cond, boolean unorderedIsTrue) {
        if (integer) {
            switch (cond) {
                case EQ: {
                    return SPARCAssembler.ConditionFlag.Equal;
                }
                case NE: {
                    return SPARCAssembler.ConditionFlag.NotEqual;
                }
                case BT: {
                    return SPARCAssembler.ConditionFlag.LessUnsigned;
                }
                case LT: {
                    return SPARCAssembler.ConditionFlag.Less;
                }
                case BE: {
                    return SPARCAssembler.ConditionFlag.LessEqualUnsigned;
                }
                case LE: {
                    return SPARCAssembler.ConditionFlag.LessEqual;
                }
                case AE: {
                    return SPARCAssembler.ConditionFlag.GreaterEqualUnsigned;
                }
                case GE: {
                    return SPARCAssembler.ConditionFlag.GreaterEqual;
                }
                case AT: {
                    return SPARCAssembler.ConditionFlag.GreaterUnsigned;
                }
                case GT: {
                    return SPARCAssembler.ConditionFlag.Greater;
                }
            }
            throw GraalError.shouldNotReachHere("Unimplemented for: " + (Object)((Object)cond));
        }
        switch (cond) {
            case EQ: {
                return unorderedIsTrue ? SPARCAssembler.ConditionFlag.F_UnorderedOrEqual : SPARCAssembler.ConditionFlag.F_Equal;
            }
            case NE: {
                return SPARCAssembler.ConditionFlag.F_NotEqual;
            }
            case LT: {
                return unorderedIsTrue ? SPARCAssembler.ConditionFlag.F_UnorderedOrLess : SPARCAssembler.ConditionFlag.F_Less;
            }
            case LE: {
                return unorderedIsTrue ? SPARCAssembler.ConditionFlag.F_UnorderedOrLessOrEqual : SPARCAssembler.ConditionFlag.F_LessOrEqual;
            }
            case GE: {
                return unorderedIsTrue ? SPARCAssembler.ConditionFlag.F_UnorderedGreaterOrEqual : SPARCAssembler.ConditionFlag.F_GreaterOrEqual;
            }
            case GT: {
                return unorderedIsTrue ? SPARCAssembler.ConditionFlag.F_UnorderedOrGreater : SPARCAssembler.ConditionFlag.F_Greater;
            }
        }
        throw GraalError.shouldNotReachHere("Unkown condition: " + (Object)((Object)cond));
    }

    @Opcode(value="CMOVE")
    public static final class CondMoveOp
    extends SPARCLIRInstruction {
        public static final LIRInstructionClass<CondMoveOp> TYPE = LIRInstructionClass.create(CondMoveOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected Value result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
        protected Value trueValue;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
        protected Value falseValue;
        private final SPARCAssembler.ConditionFlag condition;
        private final SPARCAssembler.CC cc;
        private final SPARCAssembler.CMOV cmove;

        public CondMoveOp(SPARCAssembler.CMOV cmove, SPARCAssembler.CC cc, SPARCAssembler.ConditionFlag condition, Value trueValue, Value falseValue, Value result) {
            super(TYPE);
            this.result = result;
            this.condition = condition;
            this.trueValue = trueValue;
            this.falseValue = falseValue;
            this.cc = cc;
            this.cmove = cmove;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            if (this.result.equals((Object)this.trueValue)) {
                this.cmove(masm, this.condition.negate(), this.falseValue);
            } else if (this.result.equals((Object)this.falseValue)) {
                this.cmove(masm, this.condition, this.trueValue);
            } else {
                SPARCAssembler.ConditionFlag actualCondition = this.condition;
                Value actualTrueValue = this.trueValue;
                Value actualFalseValue = this.falseValue;
                if (LIRValueUtil.isJavaConstant(this.falseValue) && SPARCAssembler.isSimm11(LIRValueUtil.asJavaConstant(this.falseValue))) {
                    actualCondition = this.condition.negate();
                    actualTrueValue = this.falseValue;
                    actualFalseValue = this.trueValue;
                }
                SPARCMove.move(crb, masm, this.result, actualFalseValue, SPARCDelayedControlTransfer.DUMMY);
                this.cmove(masm, actualCondition, actualTrueValue);
            }
        }

        private void cmove(SPARCMacroAssembler masm, SPARCAssembler.ConditionFlag localCondition, Value value) {
            if (LIRValueUtil.isConstantValue(value)) {
                this.cmove.emit(masm, localCondition, this.cc, CondMoveOp.asImmediate(LIRValueUtil.asJavaConstant(value)), ValueUtil.asRegister((Value)this.result));
            } else {
                this.cmove.emit(masm, localCondition, this.cc, ValueUtil.asRegister((Value)value), ValueUtil.asRegister((Value)this.result));
            }
        }

        @Override
        public SPARCLIRInstructionMixin.SizeEstimate estimateSize() {
            int constantSize = 0;
            if (LIRValueUtil.isJavaConstant(this.trueValue) && !SPARCAssembler.isSimm13(LIRValueUtil.asJavaConstant(this.trueValue))) {
                constantSize += this.trueValue.getPlatformKind().getSizeInBytes();
            }
            if (LIRValueUtil.isJavaConstant(this.falseValue) && !SPARCAssembler.isSimm13(LIRValueUtil.asJavaConstant(this.falseValue))) {
                constantSize += this.trueValue.getPlatformKind().getSizeInBytes();
            }
            return SPARCLIRInstructionMixin.SizeEstimate.create(3, constantSize);
        }
    }

    public static final class TableSwitchOp
    extends SPARCBlockEndOp {
        public static final LIRInstructionClass<TableSwitchOp> TYPE = LIRInstructionClass.create(TableSwitchOp.class);
        private final int lowKey;
        private final LabelRef defaultTarget;
        private final LabelRef[] targets;
        @LIRInstruction.Alive
        protected Value index;
        @LIRInstruction.Temp
        protected Value scratch;

        public TableSwitchOp(int lowKey, LabelRef defaultTarget, LabelRef[] targets, Variable index, Variable scratch) {
            super((LIRInstructionClass<? extends SPARCBlockEndOp>)TYPE);
            this.lowKey = lowKey;
            this.defaultTarget = defaultTarget;
            this.targets = targets;
            this.index = index;
            this.scratch = scratch;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            Register value = ValueUtil.asRegister((Value)this.index, (PlatformKind)SPARCKind.WORD);
            Register scratchReg = ValueUtil.asRegister((Value)this.scratch, (PlatformKind)SPARCKind.XWORD);
            int highKey = this.lowKey + this.targets.length - 1;
            if (SPARCAssembler.isSimm13(this.lowKey)) {
                masm.sub(value, this.lowKey, scratchReg);
            } else {
                LabelRef[] labelRefArray = null;
                try (SPARCMacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                    Register scratch2 = sc.getRegister();
                    masm.setx(this.lowKey, scratch2, false);
                    masm.sub(value, scratch2, scratchReg);
                }
                catch (Throwable object) {
                    labelRefArray = object;
                    throw object;
                }
            }
            int upperLimit = highKey - this.lowKey;
            try (SPARCMacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                Register scratch2 = sc.getRegister();
                if (SPARCAssembler.isSimm13(upperLimit)) {
                    masm.cmp(scratchReg, upperLimit);
                } else {
                    masm.setx(upperLimit, scratch2, false);
                    masm.cmp(scratchReg, upperLimit);
                }
                if (this.defaultTarget != null) {
                    SPARCAssembler.BPCC.emit(masm, SPARCAssembler.CC.Icc, SPARCAssembler.ConditionFlag.GreaterUnsigned, SPARCAssembler.Annul.NOT_ANNUL, SPARCAssembler.BranchPredict.PREDICT_TAKEN, this.defaultTarget.label());
                    masm.nop();
                }
                masm.sll(scratchReg, 3, scratchReg);
                masm.srl(scratchReg, 0, scratchReg);
                masm.rdpc(scratch2);
                masm.add(scratchReg, 16, scratchReg);
                masm.jmpl(scratch2, scratchReg, SPARC.g0);
            }
            masm.nop();
            for (LabelRef target : this.targets) {
                SPARCAssembler.BPCC.emit(masm, SPARCAssembler.CC.Xcc, SPARCAssembler.ConditionFlag.Always, SPARCAssembler.Annul.NOT_ANNUL, SPARCAssembler.BranchPredict.PREDICT_TAKEN, target.label());
                masm.nop();
            }
        }

        @Override
        public SPARCLIRInstructionMixin.SizeEstimate estimateSize() {
            return SPARCLIRInstructionMixin.SizeEstimate.create(17 + this.targets.length * 2);
        }
    }

    public static class StrategySwitchOp
    extends SPARCBlockEndOp {
        public static final LIRInstructionClass<StrategySwitchOp> TYPE = LIRInstructionClass.create(StrategySwitchOp.class);
        protected Constant[] keyConstants;
        private final LabelRef[] keyTargets;
        private LabelRef defaultTarget;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected Value key;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        protected Value constantTableBase;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        protected Value scratch;
        protected final SwitchStrategy strategy;
        private final EconomicMap<Label, Assembler.LabelHint> labelHints;
        private final List<Label> conditionalLabels = new ArrayList<Label>();

        public StrategySwitchOp(Value constantTableBase, SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, AllocatableValue key, Variable scratch) {
            this(TYPE, constantTableBase, strategy, keyTargets, defaultTarget, key, scratch);
        }

        protected StrategySwitchOp(LIRInstructionClass<? extends StrategySwitchOp> c, Value constantTableBase, SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, AllocatableValue key, Variable scratch) {
            super((LIRInstructionClass<? extends SPARCBlockEndOp>)c);
            this.strategy = strategy;
            this.keyConstants = strategy.getKeyConstants();
            this.keyTargets = keyTargets;
            this.defaultTarget = defaultTarget;
            this.constantTableBase = constantTableBase;
            this.key = key;
            this.scratch = scratch;
            this.labelHints = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
            assert (this.keyConstants.length == keyTargets.length);
            assert (this.keyConstants.length == strategy.keyProbabilities.length);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            Register keyRegister = ValueUtil.asRegister((Value)this.key);
            Register constantBaseRegister = AllocatableValue.ILLEGAL.equals((Object)this.constantTableBase) ? SPARC.g0 : ValueUtil.asRegister((Value)this.constantTableBase);
            this.strategy.run(new SwitchClosure(keyRegister, constantBaseRegister, crb, masm));
        }

        protected Assembler.LabelHint requestHint(SPARCMacroAssembler masm, Label label) {
            Assembler.LabelHint hint = (Assembler.LabelHint)this.labelHints.get((Object)label);
            if (hint == null) {
                hint = masm.requestLabelHint(label);
                this.labelHints.put((Object)label, (Object)hint);
            }
            return hint;
        }

        protected int estimateEmbeddedSize(Constant c) {
            JavaConstant v = (JavaConstant)c;
            if (!SPARCAssembler.isSimm13(v)) {
                return v.getJavaKind().getByteCount();
            }
            return 0;
        }

        @Override
        public SPARCLIRInstructionMixin.SizeEstimate estimateSize() {
            int constantBytes = 0;
            for (Constant c : this.keyConstants) {
                constantBytes += this.estimateEmbeddedSize(c);
            }
            return new SPARCLIRInstructionMixin.SizeEstimate(4 * this.keyTargets.length, constantBytes);
        }

        public class SwitchClosure
        extends SwitchStrategy.BaseSwitchClosure {
            private int conditionalLabelPointer;
            protected final Register keyRegister;
            protected final Register constantBaseRegister;
            protected final CompilationResultBuilder crb;
            protected final SPARCMacroAssembler masm;

            protected SwitchClosure(Register keyRegister, Register constantBaseRegister, CompilationResultBuilder crb, SPARCMacroAssembler masm) {
                super(crb, masm, StrategySwitchOp.this.keyTargets, StrategySwitchOp.this.defaultTarget);
                this.conditionalLabelPointer = 0;
                this.keyRegister = keyRegister;
                this.constantBaseRegister = constantBaseRegister;
                this.crb = crb;
                this.masm = masm;
            }

            @Override
            public Label conditionalJump(int index, Condition condition) {
                Label label;
                if (this.conditionalLabelPointer <= StrategySwitchOp.this.conditionalLabels.size()) {
                    label = new Label();
                    StrategySwitchOp.this.conditionalLabels.add(label);
                    this.conditionalLabelPointer = StrategySwitchOp.this.conditionalLabels.size();
                } else {
                    label = (Label)StrategySwitchOp.this.conditionalLabels.get(this.conditionalLabelPointer++);
                }
                this.conditionalJump(index, condition, label);
                return label;
            }

            @Override
            protected void conditionalJump(int index, Condition condition, Label target) {
                boolean canUseShortBranch;
                SPARCAssembler.CC conditionCode;
                JavaConstant constant = (JavaConstant)StrategySwitchOp.this.keyConstants[index];
                Long bits = constant.asLong();
                switch (constant.getJavaKind()) {
                    case Char: 
                    case Byte: 
                    case Short: 
                    case Int: {
                        conditionCode = SPARCAssembler.CC.Icc;
                        break;
                    }
                    case Long: {
                        conditionCode = SPARCAssembler.CC.Xcc;
                        break;
                    }
                    default: {
                        throw new GraalError("switch only supported for int, long and object");
                    }
                }
                SPARCAssembler.ConditionFlag conditionFlag = SPARCControlFlow.fromCondition(this.keyRegister.getRegisterCategory().equals((Object)SPARC.CPU), condition, false);
                Assembler.LabelHint hint = StrategySwitchOp.this.requestHint(this.masm, target);
                boolean isShortConstant = SPARCAssembler.isSimm5(constant);
                int cbCondPosition = this.masm.position();
                if (!isShortConstant) {
                    cbCondPosition += 4;
                }
                boolean bl = canUseShortBranch = this.masm.hasFeature(SPARC.CPUFeature.CBCOND) && SPARCControlFlow.isShortBranch(this.masm, cbCondPosition, hint, target);
                if (bits != null && canUseShortBranch) {
                    if (isShortConstant) {
                        SPARCAssembler.CBCOND.emit(this.masm, conditionFlag, conditionCode == SPARCAssembler.CC.Xcc, this.keyRegister, (int)bits.longValue(), target);
                    } else {
                        Register scratchRegister = ValueUtil.asRegister((Value)StrategySwitchOp.this.scratch);
                        SPARCMove.const2reg(this.crb, this.masm, StrategySwitchOp.this.scratch, this.constantBaseRegister, (JavaConstant)StrategySwitchOp.this.keyConstants[index], SPARCDelayedControlTransfer.DUMMY);
                        SPARCAssembler.CBCOND.emit(this.masm, conditionFlag, conditionCode == SPARCAssembler.CC.Xcc, this.keyRegister, scratchRegister, target);
                    }
                } else {
                    if (bits != null && SPARCAssembler.isSimm13(constant)) {
                        this.masm.cmp(this.keyRegister, (int)bits.longValue());
                    } else {
                        Register scratchRegister = ValueUtil.asRegister((Value)StrategySwitchOp.this.scratch);
                        SPARCMove.const2reg(this.crb, this.masm, StrategySwitchOp.this.scratch, this.constantBaseRegister, (JavaConstant)StrategySwitchOp.this.keyConstants[index], SPARCDelayedControlTransfer.DUMMY);
                        this.masm.cmp(this.keyRegister, scratchRegister);
                    }
                    SPARCAssembler.BPCC.emit(this.masm, conditionCode, conditionFlag, SPARCAssembler.Annul.ANNUL, SPARCAssembler.BranchPredict.PREDICT_TAKEN, target);
                    this.masm.nop();
                }
            }
        }
    }

    public static final class BranchOp
    extends SPARCBlockEndOp
    implements StandardOp.BranchOp {
        public static final LIRInstructionClass<BranchOp> TYPE = LIRInstructionClass.create(BranchOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(2);
        protected final SPARCAssembler.ConditionFlag conditionFlag;
        protected final LabelRef trueDestination;
        protected final LabelRef falseDestination;
        protected final SPARCKind kind;
        protected final double trueDestinationProbability;

        public BranchOp(SPARCAssembler.ConditionFlag conditionFlag, LabelRef trueDestination, LabelRef falseDestination, SPARCKind kind, double trueDestinationProbability) {
            super(TYPE, SIZE);
            this.trueDestination = trueDestination;
            this.falseDestination = falseDestination;
            this.kind = kind;
            this.conditionFlag = conditionFlag;
            this.trueDestinationProbability = trueDestinationProbability;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            SPARCControlFlow.emitBranch(crb, masm, this.kind, this.conditionFlag, this.trueDestination, this.falseDestination, true, this.trueDestinationProbability);
        }
    }

    public static final class CompareBranchOp
    extends SPARCBlockEndOp
    implements SPARCDelayedControlTransfer {
        public static final LIRInstructionClass<CompareBranchOp> TYPE = LIRInstructionClass.create(CompareBranchOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(3);
        static final EnumSet<SPARCKind> SUPPORTED_KINDS = EnumSet.of(SPARCKind.XWORD, SPARCKind.WORD);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
        protected Value y;
        private SPARCAssembler.ConditionFlag conditionFlag;
        protected final LabelRef trueDestination;
        protected Assembler.LabelHint trueDestinationHint;
        protected final LabelRef falseDestination;
        protected Assembler.LabelHint falseDestinationHint;
        protected final SPARCKind kind;
        protected final boolean unorderedIsTrue;
        private boolean emitted = false;
        private int delaySlotPosition = -1;
        private double trueDestinationProbability;

        public CompareBranchOp(AllocatableValue x, Value y, Condition condition, LabelRef trueDestination, LabelRef falseDestination, SPARCKind kind, boolean unorderedIsTrue, double trueDestinationProbability) {
            super(TYPE, SIZE);
            assert (x.getPlatformKind() == y.getPlatformKind()) : String.format("PlatformKind of x must match PlatformKind of y. %s!=%s", x.getPlatformKind(), y.getPlatformKind());
            this.x = x;
            this.y = y;
            this.trueDestination = trueDestination;
            this.falseDestination = falseDestination;
            this.kind = kind;
            this.unorderedIsTrue = unorderedIsTrue;
            this.trueDestinationProbability = trueDestinationProbability;
            this.conditionFlag = SPARCControlFlow.fromCondition(kind.isInteger(), condition, unorderedIsTrue);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            if (this.emitted) assert (masm.position() - this.delaySlotPosition == 4) : "Only one instruction can be stuffed into the delay slot";
            if (!this.emitted) {
                this.requestHints(masm);
                int targetPosition = CompareBranchOp.getTargetPosition(masm);
                if (this.canUseShortBranch(crb, masm, targetPosition)) {
                    this.emitted = this.emitShortCompareBranch(crb, masm);
                }
                if (!this.emitted) {
                    this.emitted = this.emitLongCompareBranch(crb, masm, true);
                    this.emitted = true;
                }
            }
            assert (this.emitted);
        }

        private boolean emitLongCompareBranch(CompilationResultBuilder crb, SPARCMacroAssembler masm, boolean withDelayedNop) {
            SPARCOP3Op.emitOp3(masm, SPARCAssembler.Op3s.Subcc, (Value)this.x, this.y);
            return SPARCControlFlow.emitBranch(crb, masm, this.kind, this.conditionFlag, this.trueDestination, this.falseDestination, withDelayedNop, this.trueDestinationProbability);
        }

        private static int getTargetPosition(Assembler asm) {
            return asm.position() + 10 * asm.target.wordSize;
        }

        @Override
        public void emitControlTransfer(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            this.requestHints(masm);
            int targetPosition = CompareBranchOp.getTargetPosition(masm);
            if (!this.canUseShortBranch(crb, masm, targetPosition)) {
                this.emitted = this.emitLongCompareBranch(crb, masm, false);
                if (this.emitted) {
                    this.delaySlotPosition = masm.position();
                }
            }
        }

        private void requestHints(SPARCMacroAssembler masm) {
            if (this.trueDestinationHint == null) {
                this.trueDestinationHint = masm.requestLabelHint(this.trueDestination.label());
            }
            if (this.falseDestinationHint == null) {
                this.falseDestinationHint = masm.requestLabelHint(this.falseDestination.label());
            }
        }

        private boolean emitShortCompareBranch(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            boolean needJump;
            boolean isLong = this.kind == SPARCKind.XWORD;
            SPARCAssembler.ConditionFlag actualConditionFlag = this.conditionFlag;
            Label actualTrueTarget = this.trueDestination.label();
            Label actualFalseTarget = this.falseDestination.label();
            if (crb.isSuccessorEdge(this.trueDestination)) {
                actualConditionFlag = this.conditionFlag.negate();
                Label tmpTarget = actualTrueTarget;
                actualTrueTarget = actualFalseTarget;
                actualFalseTarget = tmpTarget;
                needJump = false;
            } else {
                needJump = !crb.isSuccessorEdge(this.falseDestination);
                int targetPosition = CompareBranchOp.getTargetPosition(masm);
                if (needJump && !SPARCControlFlow.isShortBranch(masm, targetPosition, this.trueDestinationHint, actualTrueTarget)) {
                    actualConditionFlag = actualConditionFlag.negate();
                    Label tmpTarget = actualTrueTarget;
                    actualTrueTarget = actualFalseTarget;
                    actualFalseTarget = tmpTarget;
                }
            }
            CompareBranchOp.emitCBCond(masm, (Value)this.x, this.y, actualTrueTarget, actualConditionFlag, isLong);
            if (needJump) {
                masm.jmp(actualFalseTarget);
                masm.nop();
            }
            return true;
        }

        private static void emitCBCond(SPARCMacroAssembler masm, Value actualX, Value actualY, Label actualTrueTarget, SPARCAssembler.ConditionFlag cFlag, boolean isLong) {
            PlatformKind xKind = actualX.getPlatformKind();
            Register rs1 = ValueUtil.asRegister((Value)actualX, (PlatformKind)xKind);
            if (LIRValueUtil.isJavaConstant(actualY)) {
                JavaConstant c = LIRValueUtil.asJavaConstant(actualY);
                long constantY = c.isNull() ? 0L : c.asLong();
                try (SPARCMacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
                    if (SPARCMacroAssembler.isSimm5(constantY)) {
                        SPARCAssembler.CBCOND.emit(masm, cFlag, isLong, rs1, (int)constantY, actualTrueTarget);
                    }
                    Register rs2 = scratch.getRegister();
                    masm.setx(constantY, rs2, false);
                    SPARCAssembler.CBCOND.emit(masm, cFlag, isLong, rs1, rs2, actualTrueTarget);
                }
            } else {
                Register rs2 = ValueUtil.asRegister((Value)actualY, (PlatformKind)xKind);
                SPARCAssembler.CBCOND.emit(masm, cFlag, isLong, rs1, rs2, actualTrueTarget);
            }
        }

        private boolean canUseShortBranch(CompilationResultBuilder crb, SPARCAssembler asm, int position) {
            if (!asm.hasFeature(SPARC.CPUFeature.CBCOND)) {
                return false;
            }
            if (!((SPARCKind)this.x.getPlatformKind()).isInteger()) {
                return false;
            }
            if (LIRValueUtil.isJavaConstant(this.y) && !SPARCAssembler.isSimm5(LIRValueUtil.asJavaConstant(this.y)) && SPARCAssembler.isSimm13(LIRValueUtil.asJavaConstant(this.y))) {
                return false;
            }
            boolean hasShortJumpTarget = false;
            if (!crb.isSuccessorEdge(this.trueDestination)) {
                hasShortJumpTarget |= SPARCControlFlow.isShortBranch(asm, position, this.trueDestinationHint, this.trueDestination.label());
            }
            if (!crb.isSuccessorEdge(this.falseDestination)) {
                hasShortJumpTarget |= SPARCControlFlow.isShortBranch(asm, position, this.falseDestinationHint, this.falseDestination.label());
            }
            return hasShortJumpTarget;
        }

        @Override
        public void resetState() {
            this.emitted = false;
            this.delaySlotPosition = -1;
        }

        @Override
        public void verify() {
            super.verify();
            assert (SUPPORTED_KINDS.contains(this.kind)) : this.kind;
            assert (!LIRValueUtil.isConstantValue((Value)this.x));
            assert (this.x.getPlatformKind().equals(this.kind) && (LIRValueUtil.isConstantValue(this.y) || this.y.getPlatformKind().equals(this.kind))) : this.x + " " + this.y;
        }
    }

    public static final class ReturnOp
    extends SPARCBlockEndOp {
        public static final LIRInstructionClass<ReturnOp> TYPE = LIRInstructionClass.create(ReturnOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(2);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        protected Value x;

        public ReturnOp(Value x) {
            super(TYPE, SIZE);
            this.x = x;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            ReturnOp.emitCodeHelper(crb, masm);
        }

        public static void emitCodeHelper(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            masm.ret();
            crb.frameContext.leave(crb);
        }
    }
}

