/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.sparc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARC;
import org.graalvm.compiler.asm.sparc.SPARCAddress;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstruction;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;

public class SPARCCall {
    public static void directCall(CompilationResultBuilder crb, SPARCMacroAssembler masm, InvokeTarget callTarget, Register scratch, LIRFrameState info) {
        int before;
        if (scratch != null) {
            before = masm.position();
            masm.sethix(0L, scratch, true);
            masm.jmpl(scratch, 0, SPARC.o7);
        } else {
            before = masm.call(0);
        }
        masm.nop();
        int after = masm.position();
        crb.recordDirectCall(before, after, callTarget, info);
        crb.recordExceptionHandlers(after, info);
        masm.ensureUniquePC();
    }

    public static void indirectJmp(CompilationResultBuilder crb, SPARCMacroAssembler masm, Register dst, InvokeTarget target) {
        int before = masm.position();
        masm.sethix(0L, dst, true);
        masm.jmp(new SPARCAddress(dst, 0));
        masm.nop();
        int after = masm.position();
        crb.recordIndirectCall(before, after, target, null);
        masm.ensureUniquePC();
    }

    public static void indirectCall(CompilationResultBuilder crb, SPARCMacroAssembler masm, Register dst, InvokeTarget callTarget, LIRFrameState info) {
        int before = masm.jmpl(dst, 0, SPARC.o7);
        masm.nop();
        int after = masm.position();
        crb.recordIndirectCall(before, after, callTarget, info);
        crb.recordExceptionHandlers(after, info);
        masm.ensureUniquePC();
    }

    @Opcode(value="FAR_FOREIGN_CALL")
    public static final class DirectFarForeignCallOp
    extends ForeignCallOp {
        public static final LIRInstructionClass<DirectFarForeignCallOp> TYPE = LIRInstructionClass.create(DirectFarForeignCallOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(1);

        public DirectFarForeignCallOp(ForeignCallLinkage callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(TYPE, SIZE, callTarget, result, parameters, temps, state);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            try (SPARCMacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
                SPARCCall.directCall(crb, masm, this.callTarget, scratch.getRegister(), this.state);
            }
        }
    }

    @Opcode(value="NEAR_FOREIGN_CALL")
    public static final class DirectNearForeignCallOp
    extends ForeignCallOp {
        public static final LIRInstructionClass<DirectNearForeignCallOp> TYPE = LIRInstructionClass.create(DirectNearForeignCallOp.class);
        public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(1);

        public DirectNearForeignCallOp(ForeignCallLinkage linkage, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(TYPE, SIZE, linkage, result, parameters, temps, state);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            SPARCCall.directCall(crb, masm, this.callTarget, null, this.state);
        }
    }

    public static abstract class ForeignCallOp
    extends CallOp {
        public static final LIRInstructionClass<ForeignCallOp> TYPE = LIRInstructionClass.create(ForeignCallOp.class);
        protected final ForeignCallLinkage callTarget;

        public ForeignCallOp(LIRInstructionClass<? extends ForeignCallOp> c, SPARCLIRInstructionMixin.SizeEstimate size, ForeignCallLinkage callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(c, size, result, parameters, temps, state);
            this.callTarget = callTarget;
        }

        @Override
        public boolean destroysCallerSavedRegisters() {
            return this.callTarget.destroysRegisters();
        }
    }

    @Opcode(value="CALL_INDIRECT")
    public static abstract class IndirectCallOp
    extends MethodCallOp {
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected Value targetAddress;

        protected IndirectCallOp(LIRInstructionClass<? extends IndirectCallOp> c, SPARCLIRInstructionMixin.SizeEstimate size, ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value targetAddress, LIRFrameState state) {
            super(c, size, callTarget, result, parameters, temps, state);
            this.targetAddress = targetAddress;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            SPARCCall.indirectCall(crb, masm, ValueUtil.asRegister((Value)this.targetAddress), (InvokeTarget)this.callTarget, this.state);
        }

        @Override
        public void verify() {
            super.verify();
            assert (ValueUtil.isRegister((Value)this.targetAddress)) : "The current register allocator cannot handle variables to be used at call sites, it must be in a fixed register for now";
        }
    }

    @Opcode(value="CALL_DIRECT")
    public static abstract class DirectCallOp
    extends MethodCallOp {
        private boolean emitted = false;
        private int before = -1;

        public DirectCallOp(LIRInstructionClass<? extends DirectCallOp> c, SPARCLIRInstructionMixin.SizeEstimate size, ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(c, size, callTarget, result, parameters, temps, state);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            if (!this.emitted) {
                this.emitCallPrefixCode(crb, masm);
                SPARCCall.directCall(crb, masm, (InvokeTarget)this.callTarget, null, this.state);
            } else {
                int after = masm.position();
                if (after - this.before == 4) {
                    masm.nop();
                } else if (after - this.before != 8) {
                    GraalError.shouldNotReachHere("" + (after - this.before));
                }
                after = masm.position();
                crb.recordDirectCall(this.before, after, (InvokeTarget)this.callTarget, this.state);
                crb.recordExceptionHandlers(after, this.state);
                masm.ensureUniquePC();
            }
        }

        public void emitCallPrefixCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        }

        public void emitControlTransfer(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            assert (!this.emitted);
            this.emitCallPrefixCode(crb, masm);
            this.before = masm.call(0);
            this.emitted = true;
        }

        public void resetState() {
            this.emitted = false;
            this.before = -1;
        }
    }

    public static abstract class MethodCallOp
    extends CallOp {
        protected final ResolvedJavaMethod callTarget;

        protected MethodCallOp(LIRInstructionClass<? extends MethodCallOp> c, SPARCLIRInstructionMixin.SizeEstimate size, ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(c, size, result, parameters, temps, state);
            this.callTarget = callTarget;
        }
    }

    public static abstract class CallOp
    extends SPARCLIRInstruction {
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        protected Value result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected Value[] parameters;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected Value[] temps;
        @LIRInstruction.State
        protected LIRFrameState state;

        protected CallOp(LIRInstructionClass<? extends CallOp> c, SPARCLIRInstructionMixin.SizeEstimate size, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(c, size);
            this.result = result;
            this.parameters = parameters;
            this.state = state;
            this.temps = CallOp.addStackSlotsToTemporaries(parameters, temps);
            assert (temps != null);
        }

        @Override
        public boolean destroysCallerSavedRegisters() {
            return true;
        }
    }
}

