/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.sparc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARC;
import jdk.vm.ci.sparc.SPARCKind;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.sparc.SPARCAddress;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstruction;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;

@Opcode(value="ARRAY_EQUALS")
public final class SPARCArrayEqualsOp
extends SPARCLIRInstruction {
    public static final LIRInstructionClass<SPARCArrayEqualsOp> TYPE = LIRInstructionClass.create(SPARCArrayEqualsOp.class);
    public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(32);
    private final JavaKind kind;
    private final int arrayBaseOffset;
    private final int arrayIndexScale;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue array1Value;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue array2Value;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue lengthValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue temp1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue temp2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue temp3;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue temp4;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue temp5;
    private static final int VECTOR_SIZE = 8;

    public SPARCArrayEqualsOp(LIRGeneratorTool tool, JavaKind kind, AllocatableValue result, AllocatableValue array1, AllocatableValue array2, AllocatableValue length, boolean directPointers) {
        super(TYPE, SIZE);
        assert (!kind.isNumericFloat()) : "Float arrays comparison (bitwise_equal || both_NaN) isn't supported";
        this.kind = kind;
        this.arrayBaseOffset = directPointers ? 0 : tool.getProviders().getMetaAccess().getArrayBaseOffset(kind);
        this.arrayIndexScale = tool.getProviders().getMetaAccess().getArrayIndexScale(kind);
        this.resultValue = result;
        this.array1Value = array1;
        this.array2Value = array2;
        this.lengthValue = length;
        this.temp1 = tool.newVariable(LIRKind.unknownReference(tool.target().arch.getWordKind()));
        this.temp2 = tool.newVariable(LIRKind.unknownReference(tool.target().arch.getWordKind()));
        this.temp3 = tool.newVariable(LIRKind.value(tool.target().arch.getWordKind()));
        this.temp4 = tool.newVariable(LIRKind.value(tool.target().arch.getWordKind()));
        this.temp5 = tool.newVariable(LIRKind.value(tool.target().arch.getWordKind()));
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register array1 = ValueUtil.asRegister((Value)this.temp1);
        Register array2 = ValueUtil.asRegister((Value)this.temp2);
        Register length = ValueUtil.asRegister((Value)this.temp3);
        Label trueLabel = new Label();
        Label falseLabel = new Label();
        Label done = new Label();
        masm.add(ValueUtil.asRegister((Value)this.array1Value), this.arrayBaseOffset, array1);
        masm.add(ValueUtil.asRegister((Value)this.array2Value), this.arrayBaseOffset, array2);
        masm.mulx(ValueUtil.asRegister((Value)this.lengthValue, (PlatformKind)SPARCKind.WORD), this.arrayIndexScale, length);
        masm.mov(length, result);
        this.emit8ByteCompare(masm, result, array1, array2, length, trueLabel, falseLabel);
        this.emitTailCompares(masm, result, array1, array2, trueLabel, falseLabel);
        masm.bind(trueLabel);
        masm.mov(1, result);
        masm.jmp(done);
        masm.bind(falseLabel);
        masm.mov(SPARC.g0, result);
        masm.bind(done);
    }

    private void emit8ByteCompare(SPARCMacroAssembler masm, Register result, Register array1, Register array2, Register length, Label trueLabel, Label falseLabel) {
        assert (this.lengthValue.getPlatformKind().equals(SPARCKind.WORD));
        Label loop = new Label();
        Label compareTail = new Label();
        Label compareTailCorrectVectorEnd = new Label();
        Register tempReg1 = ValueUtil.asRegister((Value)this.temp4);
        Register tempReg2 = ValueUtil.asRegister((Value)this.temp5);
        masm.sra(length, 0, length);
        masm.and(result, 7, result);
        masm.andcc(length, -8, length);
        SPARCAssembler.BPCC.emit(masm, SPARCAssembler.CC.Xcc, SPARCAssembler.ConditionFlag.Equal, SPARCAssembler.Annul.NOT_ANNUL, SPARCAssembler.BranchPredict.PREDICT_NOT_TAKEN, compareTail);
        masm.sub(length, 8, length);
        masm.add(array1, length, array1);
        masm.add(array2, length, array2);
        masm.sub(SPARC.g0, length, length);
        masm.ldx(new SPARCAddress(array1, 0), tempReg1);
        masm.ldx(new SPARCAddress(array2, 0), tempReg2);
        masm.compareBranch(tempReg1, tempReg2, SPARCAssembler.ConditionFlag.NotEqual, SPARCAssembler.CC.Xcc, falseLabel, SPARCAssembler.BranchPredict.PREDICT_NOT_TAKEN, null);
        masm.compareBranch(length, 0, SPARCAssembler.ConditionFlag.Equal, SPARCAssembler.CC.Xcc, compareTailCorrectVectorEnd, SPARCAssembler.BranchPredict.PREDICT_NOT_TAKEN, null);
        masm.ldx(new SPARCAddress(array1, length), tempReg1);
        masm.bind(loop);
        masm.ldx(new SPARCAddress(array2, length), tempReg2);
        masm.cmp(tempReg1, tempReg2);
        SPARCAssembler.BPCC.emit(masm, SPARCAssembler.CC.Xcc, SPARCAssembler.ConditionFlag.NotEqual, SPARCAssembler.Annul.NOT_ANNUL, SPARCAssembler.BranchPredict.PREDICT_NOT_TAKEN, falseLabel);
        masm.addcc(length, 8, length);
        SPARCAssembler.BPCC.emit(masm, SPARCAssembler.CC.Xcc, SPARCAssembler.ConditionFlag.NotEqual, SPARCAssembler.Annul.ANNUL, SPARCAssembler.BranchPredict.PREDICT_TAKEN, loop);
        masm.ldx(new SPARCAddress(array1, length), tempReg1);
        masm.compareBranch(result, 0, SPARCAssembler.ConditionFlag.Equal, SPARCAssembler.CC.Xcc, trueLabel, SPARCAssembler.BranchPredict.PREDICT_TAKEN, null);
        masm.bind(compareTailCorrectVectorEnd);
        masm.add(array1, 8, array1);
        masm.add(array2, 8, array2);
        masm.bind(compareTail);
    }

    private void emitTailCompares(SPARCMacroAssembler masm, Register result, Register array1, Register array2, Label trueLabel, Label falseLabel) {
        Label compare2Bytes = new Label();
        Label compare1Byte = new Label();
        Register tempReg1 = ValueUtil.asRegister((Value)this.temp3);
        Register tempReg2 = ValueUtil.asRegister((Value)this.temp4);
        if (this.kind.getByteCount() <= 4) {
            masm.compareBranch(result, 4, SPARCAssembler.ConditionFlag.Less, SPARCAssembler.CC.Xcc, compare2Bytes, SPARCAssembler.BranchPredict.PREDICT_NOT_TAKEN, null);
            masm.lduw(new SPARCAddress(array1, 0), tempReg1);
            masm.lduw(new SPARCAddress(array2, 0), tempReg2);
            masm.compareBranch(tempReg1, tempReg2, SPARCAssembler.ConditionFlag.NotEqual, SPARCAssembler.CC.Xcc, falseLabel, SPARCAssembler.BranchPredict.PREDICT_NOT_TAKEN, null);
            if (this.kind.getByteCount() <= 2) {
                masm.add(array1, 4, array1);
                masm.add(array2, 4, array2);
                masm.sub(result, 4, result);
                masm.bind(compare2Bytes);
                masm.compareBranch(result, 2, SPARCAssembler.ConditionFlag.Less, SPARCAssembler.CC.Xcc, compare1Byte, SPARCAssembler.BranchPredict.PREDICT_TAKEN, null);
                masm.lduh(new SPARCAddress(array1, 0), tempReg1);
                masm.lduh(new SPARCAddress(array2, 0), tempReg2);
                masm.compareBranch(tempReg1, tempReg2, SPARCAssembler.ConditionFlag.NotEqual, SPARCAssembler.CC.Xcc, falseLabel, SPARCAssembler.BranchPredict.PREDICT_TAKEN, null);
                if (this.kind.getByteCount() <= 1) {
                    masm.add(array1, 2, array1);
                    masm.add(array2, 2, array2);
                    masm.sub(result, 2, result);
                    masm.bind(compare1Byte);
                    masm.compareBranch(result, 1, SPARCAssembler.ConditionFlag.NotEqual, SPARCAssembler.CC.Xcc, trueLabel, SPARCAssembler.BranchPredict.PREDICT_TAKEN, null);
                    masm.ldub(new SPARCAddress(array1, 0), tempReg1);
                    masm.ldub(new SPARCAddress(array2, 0), tempReg2);
                    masm.compareBranch(tempReg1, tempReg2, SPARCAssembler.ConditionFlag.NotEqual, SPARCAssembler.CC.Xcc, falseLabel, SPARCAssembler.BranchPredict.PREDICT_TAKEN, null);
                } else {
                    masm.bind(compare1Byte);
                }
            } else {
                masm.bind(compare2Bytes);
            }
        }
    }
}

