/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="ZAP_STACK")
public final class AMD64ZapStackOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64ZapStackOp> TYPE = LIRInstructionClass.create(AMD64ZapStackOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.STACK})
    protected final StackSlot[] zappedStack;
    protected final JavaConstant[] zapValues;

    public AMD64ZapStackOp(StackSlot[] zappedStack, JavaConstant[] zapValues) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.zappedStack = zappedStack;
        this.zapValues = zapValues;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        for (int i = 0; i < this.zappedStack.length; ++i) {
            StackSlot slot = this.zappedStack[i];
            if (slot == null) continue;
            AMD64Move.const2stack(crb, masm, (Value)slot, this.zapValues[i]);
        }
    }
}

