/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AMD64MulDivOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64MulDivOp> TYPE = LIRInstructionClass.create(AMD64MulDivOp.class);
    @Opcode
    private final AMD64Assembler.AMD64MOp opcode;
    private final AMD64BaseAssembler.OperandSize size;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue highResult;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue lowResult;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected AllocatableValue highX;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue lowX;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
    protected AllocatableValue y;
    @LIRInstruction.State
    protected LIRFrameState state;

    public AMD64MulDivOp(AMD64Assembler.AMD64MOp opcode, AMD64BaseAssembler.OperandSize size, LIRKind resultKind, AllocatableValue x, AllocatableValue y) {
        this(opcode, size, resultKind, Value.ILLEGAL, x, y, null);
    }

    public AMD64MulDivOp(AMD64Assembler.AMD64MOp opcode, AMD64BaseAssembler.OperandSize size, LIRKind resultKind, AllocatableValue highX, AllocatableValue lowX, AllocatableValue y, LIRFrameState state) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.opcode = opcode;
        this.size = size;
        this.highResult = AMD64.rdx.asValue((ValueKind)resultKind);
        this.lowResult = AMD64.rax.asValue((ValueKind)resultKind);
        this.highX = highX;
        this.lowX = lowX;
        this.y = y;
        this.state = state;
    }

    public AllocatableValue getHighResult() {
        return this.highResult;
    }

    public AllocatableValue getLowResult() {
        return this.lowResult;
    }

    public AllocatableValue getQuotient() {
        return this.lowResult;
    }

    public AllocatableValue getRemainder() {
        return this.highResult;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        if (this.state != null) {
            crb.recordImplicitException(masm.position(), this.state);
        }
        if (ValueUtil.isRegister((Value)this.y)) {
            this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.y));
        } else {
            assert (ValueUtil.isStackSlot((Value)this.y));
            this.opcode.emit((AMD64Assembler)masm, this.size, (AMD64Address)crb.asAddress((Value)this.y));
        }
    }

    @Override
    public void verify() {
        assert (ValueUtil.asRegister((Value)this.highResult).equals((Object)AMD64.rdx));
        assert (ValueUtil.asRegister((Value)this.lowResult).equals((Object)AMD64.rax));
        assert (ValueUtil.asRegister((Value)this.lowX).equals((Object)AMD64.rax));
        if (this.opcode == AMD64Assembler.AMD64MOp.DIV || this.opcode == AMD64Assembler.AMD64MOp.IDIV ? !$assertionsDisabled && !ValueUtil.asRegister((Value)this.highX).equals((Object)AMD64.rdx) : (this.opcode == AMD64Assembler.AMD64MOp.MUL || this.opcode == AMD64Assembler.AMD64MOp.IMUL) && !$assertionsDisabled && !ValueUtil.isIllegal((Value)this.highX)) {
            throw new AssertionError();
        }
    }
}

