/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.alloc.lsra;

import java.util.ArrayList;
import java.util.BitSet;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.alloc.lsra.Interval;
import org.graalvm.compiler.lir.alloc.lsra.LinearScan;
import org.graalvm.compiler.lir.alloc.lsra.LinearScanAllocationPhase;
import org.graalvm.compiler.lir.alloc.lsra.MoveResolver;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.AllocationPhase;

public class LinearScanResolveDataFlowPhase
extends LinearScanAllocationPhase {
    protected final LinearScan allocator;

    protected LinearScanResolveDataFlowPhase(LinearScan allocator) {
        this.allocator = allocator;
    }

    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, AllocationPhase.AllocationContext context) {
        this.resolveDataFlow();
        this.allocator.printIntervals("After resolve data flow");
    }

    protected void resolveCollectMappings(AbstractBlockBase<?> fromBlock, AbstractBlockBase<?> toBlock, AbstractBlockBase<?> midBlock, MoveResolver moveResolver) {
        assert (moveResolver.checkEmpty());
        assert (midBlock == null || midBlock.getPredecessorCount() == 1 && midBlock.getSuccessorCount() == 1 && midBlock.getPredecessors()[0].equals(fromBlock) && midBlock.getSuccessors()[0].equals(toBlock));
        int toBlockFirstInstructionId = this.allocator.getFirstLirInstructionId(toBlock);
        int fromBlockLastInstructionId = this.allocator.getLastLirInstructionId(fromBlock) + 1;
        int numOperands = this.allocator.operandSize();
        BitSet liveAtEdge = this.allocator.getBlockData(toBlock).liveIn;
        int operandNum = liveAtEdge.nextSetBit(0);
        while (operandNum >= 0) {
            Interval toInterval;
            assert (operandNum < numOperands) : "live information set for not exisiting interval";
            assert (this.allocator.getBlockData(fromBlock).liveOut.get(operandNum) && this.allocator.getBlockData(toBlock).liveIn.get(operandNum)) : "interval not live at this edge";
            Interval fromInterval = this.allocator.splitChildAtOpId(this.allocator.intervalFor(operandNum), fromBlockLastInstructionId, LIRInstruction.OperandMode.DEF);
            if (fromInterval != (toInterval = this.allocator.splitChildAtOpId(this.allocator.intervalFor(operandNum), toBlockFirstInstructionId, LIRInstruction.OperandMode.DEF)) && !fromInterval.location().equals((Object)toInterval.location())) {
                moveResolver.addMapping(fromInterval, toInterval);
            }
            operandNum = liveAtEdge.nextSetBit(operandNum + 1);
        }
    }

    void resolveFindInsertPos(AbstractBlockBase<?> fromBlock, AbstractBlockBase<?> toBlock, MoveResolver moveResolver) {
        DebugContext debug = this.allocator.getDebug();
        if (fromBlock.getSuccessorCount() <= 1) {
            ArrayList<LIRInstruction> instructions;
            LIRInstruction instr;
            if (debug.isLogEnabled()) {
                debug.log("inserting moves at end of fromBlock B%d", fromBlock.getId());
            }
            if ((instr = (instructions = this.allocator.getLIR().getLIRforBlock(fromBlock)).get(instructions.size() - 1)) instanceof StandardOp.JumpOp) {
                moveResolver.setInsertPosition(instructions, instructions.size() - 1);
            } else {
                moveResolver.setInsertPosition(instructions, instructions.size());
            }
        } else {
            if (debug.isLogEnabled()) {
                debug.log("inserting moves at beginning of toBlock B%d", toBlock.getId());
            }
            if (this.allocator.detailedAsserts) {
                assert (this.allocator.getLIR().getLIRforBlock(fromBlock).get(0) instanceof StandardOp.LabelOp) : "block does not start with a label";
                for (AbstractBlockBase predecessor : toBlock.getPredecessors()) {
                    assert (fromBlock == predecessor) : "all critical edges must be broken";
                }
            }
            moveResolver.setInsertPosition(this.allocator.getLIR().getLIRforBlock(toBlock), 1);
        }
    }

    protected void resolveDataFlow() {
        try (Indent indent = this.allocator.getDebug().logAndIndent("resolve data flow");){
            MoveResolver moveResolver = this.allocator.createMoveResolver();
            BitSet blockCompleted = new BitSet(this.allocator.blockCount());
            this.optimizeEmptyBlocks(moveResolver, blockCompleted);
            this.resolveDataFlow0(moveResolver, blockCompleted);
        }
    }

    protected void optimizeEmptyBlocks(MoveResolver moveResolver, BitSet blockCompleted) {
        for (AbstractBlockBase<?> block : this.allocator.sortedBlocks()) {
            if (block.getPredecessorCount() != 1 || block.getSuccessorCount() != 1) continue;
            ArrayList<LIRInstruction> instructions = this.allocator.getLIR().getLIRforBlock(block);
            assert (instructions.get(0) instanceof StandardOp.LabelOp) : "block must start with label";
            assert (instructions.get(instructions.size() - 1) instanceof StandardOp.JumpOp) : "block with successor must end with unconditional jump";
            if (instructions.size() != 2) continue;
            AbstractBlockBase pred = block.getPredecessors()[0];
            AbstractBlockBase sux = block.getSuccessors()[0];
            if (blockCompleted.get(pred.getLinearScanNumber()) || blockCompleted.get(sux.getLinearScanNumber())) continue;
            DebugContext debug = this.allocator.getDebug();
            if (debug.isLogEnabled()) {
                debug.log(" optimizing empty block B%d (pred: B%d, sux: B%d)", block.getId(), pred.getId(), sux.getId());
            }
            blockCompleted.set(block.getLinearScanNumber());
            this.resolveCollectMappings(pred, sux, block, moveResolver);
            if (!moveResolver.hasMappings()) continue;
            moveResolver.setInsertPosition(instructions, 1);
            moveResolver.resolveAndAppendMoves();
        }
    }

    protected void resolveDataFlow0(MoveResolver moveResolver, BitSet blockCompleted) {
        BitSet alreadyResolved = new BitSet(this.allocator.blockCount());
        for (AbstractBlockBase<?> fromBlock : this.allocator.sortedBlocks()) {
            if (blockCompleted.get(fromBlock.getLinearScanNumber())) continue;
            alreadyResolved.clear();
            alreadyResolved.or(blockCompleted);
            for (AbstractBlockBase toBlock : fromBlock.getSuccessors()) {
                if (alreadyResolved.get(toBlock.getLinearScanNumber())) continue;
                DebugContext debug = this.allocator.getDebug();
                if (debug.isLogEnabled()) {
                    debug.log("processing edge between B%d and B%d", fromBlock.getId(), toBlock.getId());
                }
                alreadyResolved.set(toBlock.getLinearScanNumber());
                this.resolveCollectMappings(fromBlock, toBlock, null, moveResolver);
                if (!moveResolver.hasMappings()) continue;
                this.resolveFindInsertPos(fromBlock, toBlock, moveResolver);
                moveResolver.resolveAndAppendMoves();
            }
        }
    }
}

