/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.common.type.DataPointerConstant;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.aarch64.AArch64AddressValue;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.options.OptionValues;

public class AArch64Move {
    private static void emitStore(CompilationResultBuilder crb, AArch64MacroAssembler masm, AArch64Kind kind, AArch64Address dst, Value src) {
        int destSize = kind.getSizeInBytes() * 8;
        if (kind.isInteger()) {
            masm.str(destSize, ValueUtil.asRegister((Value)src), dst);
        } else {
            masm.fstr(destSize, ValueUtil.asRegister((Value)src), dst);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void move(CompilationResultBuilder crb, AArch64MacroAssembler masm, AllocatableValue result, Value input) {
        if (ValueUtil.isRegister((Value)input)) {
            if (ValueUtil.isRegister((Value)result)) {
                AArch64Move.reg2reg(crb, masm, result, ValueUtil.asAllocatableValue((Value)input));
                return;
            } else {
                if (!ValueUtil.isStackSlot((Value)result)) throw GraalError.shouldNotReachHere();
                AArch64Move.reg2stack(crb, masm, result, ValueUtil.asAllocatableValue((Value)input));
            }
            return;
        } else if (ValueUtil.isStackSlot((Value)input)) {
            if (ValueUtil.isRegister((Value)result)) {
                AArch64Move.stack2reg(crb, masm, result, ValueUtil.asAllocatableValue((Value)input));
                return;
            } else {
                if (!ValueUtil.isStackSlot((Value)result)) throw GraalError.shouldNotReachHere();
                AArch64Move.emitStackMove(crb, masm, result, input);
            }
            return;
        } else {
            if (!LIRValueUtil.isJavaConstant(input)) throw GraalError.shouldNotReachHere();
            if (!ValueUtil.isRegister((Value)result)) throw GraalError.shouldNotReachHere();
            AArch64Move.const2reg(crb, masm, (Value)result, LIRValueUtil.asJavaConstant(input));
        }
    }

    private static void emitStackMove(CompilationResultBuilder crb, AArch64MacroAssembler masm, AllocatableValue result, Value input) {
        try (AArch64MacroAssembler.ScratchRegister r1 = masm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister r2 = masm.getScratchRegister();){
            Register rscratch1 = r1.getRegister();
            Register rscratch2 = r2.getRegister();
            PlatformKind kind = input.getPlatformKind();
            int size = kind.getSizeInBytes() * 8;
            crb.blockComment("[stack -> stack copy]");
            AArch64Address src = AArch64Move.loadStackSlotAddress(crb, masm, ValueUtil.asStackSlot((Value)input), rscratch2);
            masm.ldr(size, rscratch1, src);
            AArch64Address dst = AArch64Move.loadStackSlotAddress(crb, masm, ValueUtil.asStackSlot((Value)result), rscratch2);
            masm.str(size, rscratch1, dst);
        }
    }

    private static void reg2reg(CompilationResultBuilder crb, AArch64MacroAssembler masm, AllocatableValue result, AllocatableValue input) {
        Register dst = ValueUtil.asRegister((Value)result);
        Register src = ValueUtil.asRegister((Value)input);
        if (src.equals((Object)dst)) {
            return;
        }
        AArch64Kind kind = (AArch64Kind)input.getPlatformKind();
        int size = kind.getSizeInBytes() * 8;
        if (kind.isInteger()) {
            masm.mov(size, dst, src);
        } else {
            masm.fmov(size, dst, src);
        }
    }

    static void reg2stack(CompilationResultBuilder crb, AArch64MacroAssembler masm, AllocatableValue result, AllocatableValue input) {
        AArch64Address dest;
        try (AArch64MacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
            dest = AArch64Move.loadStackSlotAddress(crb, masm, ValueUtil.asStackSlot((Value)result), scratch.getRegister());
        }
        Register src = ValueUtil.asRegister((Value)input);
        AArch64Kind kind = (AArch64Kind)result.getPlatformKind();
        int size = kind.getSizeInBytes() * 8;
        if (kind.isInteger()) {
            masm.str(size, src, dest);
        } else {
            masm.fstr(size, src, dest);
        }
    }

    static void stack2reg(CompilationResultBuilder crb, AArch64MacroAssembler masm, AllocatableValue result, AllocatableValue input) {
        AArch64Kind kind = (AArch64Kind)input.getPlatformKind();
        int size = kind.getSizeInBytes() * 8;
        if (kind.isInteger()) {
            AArch64Address src = AArch64Move.loadStackSlotAddress(crb, masm, ValueUtil.asStackSlot((Value)input), result);
            masm.ldr(size, ValueUtil.asRegister((Value)result), src);
        } else {
            try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                RegisterValue scratchRegisterValue = sc.getRegister().asValue((ValueKind)LIRKind.combine(new Value[]{input}));
                AArch64Address src = AArch64Move.loadStackSlotAddress(crb, masm, ValueUtil.asStackSlot((Value)input), (AllocatableValue)scratchRegisterValue);
                masm.fldr(size, ValueUtil.asRegister((Value)result), src);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void const2reg(CompilationResultBuilder crb, AArch64MacroAssembler masm, Value result, JavaConstant input) {
        dst = ValueUtil.asRegister((Value)result);
        switch (1.$SwitchMap$jdk$vm$ci$meta$JavaKind[input.getJavaKind().getStackKind().ordinal()]) {
            case 5: {
                value = input.asInt();
                switch (1.$SwitchMap$jdk$vm$ci$meta$JavaKind[input.getJavaKind().ordinal()]) {
                    case 1: 
                    case 2: {
                        maskedValue = value & 255;
                        break;
                    }
                    case 3: 
                    case 4: {
                        maskedValue = value & 65535;
                        break;
                    }
                    case 5: {
                        maskedValue = value;
                        break;
                    }
                    default: {
                        throw GraalError.shouldNotReachHere();
                    }
                }
                masm.mov(dst, maskedValue);
                break;
            }
            case 6: {
                masm.mov(dst, input.asLong());
                break;
            }
            case 7: {
                if (AArch64MacroAssembler.isFloatImmediate(input.asFloat())) {
                    masm.fmov(32, dst, input.asFloat());
                    break;
                }
                if (!crb.compilationResult.isImmutablePIC()) ** GOTO lbl58
                scr = masm.getScratchRegister();
                var8_11 = null;
                scratch = scr.getRegister();
                masm.mov(scratch, Float.floatToRawIntBits(input.asFloat()));
                masm.fmov(32, dst, scratch);
                if (scr == null) break;
                if (var8_11 == null) ** GOTO lbl41
                try {
                    scr.close();
                }
                catch (Throwable scratch) {
                    var8_11.addSuppressed(scratch);
                }
                break;
lbl41:
                // 1 sources

                scr.close();
                break;
                catch (Throwable scratch) {
                    try {
                        var8_11 = scratch;
                        throw scratch;
                    }
                    catch (Throwable var10_27) {
                        if (scr != null) {
                            if (var8_11 != null) {
                                try {
                                    scr.close();
                                }
                                catch (Throwable var11_28) {
                                    var8_11.addSuppressed(var11_28);
                                }
                            } else {
                                scr.close();
                            }
                        }
                        throw var10_27;
                    }
                }
lbl58:
                // 1 sources

                scr = masm.getScratchRegister();
                var8_12 = null;
                scratch = scr.getRegister();
                crb.asFloatConstRef(input);
                masm.adrpAdd(scratch);
                masm.fldr(32, dst, AArch64Address.createBaseRegisterOnlyAddress(scratch));
                if (scr == null) break;
                if (var8_12 == null) ** GOTO lbl74
                try {
                    scr.close();
                }
                catch (Throwable scratch) {
                    var8_12.addSuppressed(scratch);
                }
                break;
lbl74:
                // 1 sources

                scr.close();
                break;
                catch (Throwable scratch) {
                    try {
                        var8_12 = scratch;
                        throw scratch;
                    }
                    catch (Throwable var12_29) {
                        if (scr != null) {
                            if (var8_12 != null) {
                                try {
                                    scr.close();
                                }
                                catch (Throwable var13_30) {
                                    var8_12.addSuppressed(var13_30);
                                }
                            } else {
                                scr.close();
                            }
                        }
                        throw var12_29;
                    }
                }
            }
            case 8: {
                if (AArch64MacroAssembler.isDoubleImmediate(input.asDouble())) {
                    masm.fmov(64, dst, input.asDouble());
                    break;
                }
                if (!crb.compilationResult.isImmutablePIC()) ** GOTO lbl127
                scr = masm.getScratchRegister();
                var8_13 = null;
                scratch = scr.getRegister();
                masm.mov(scratch, Double.doubleToRawLongBits(input.asDouble()));
                masm.fmov(64, dst, scratch);
                if (scr == null) break;
                if (var8_13 == null) ** GOTO lbl110
                try {
                    scr.close();
                }
                catch (Throwable scratch) {
                    var8_13.addSuppressed(scratch);
                }
                break;
lbl110:
                // 1 sources

                scr.close();
                break;
                catch (Throwable scratch) {
                    try {
                        var8_13 = scratch;
                        throw scratch;
                    }
                    catch (Throwable var14_31) {
                        if (scr != null) {
                            if (var8_13 != null) {
                                try {
                                    scr.close();
                                }
                                catch (Throwable var15_32) {
                                    var8_13.addSuppressed(var15_32);
                                }
                            } else {
                                scr.close();
                            }
                        }
                        throw var14_31;
                    }
                }
lbl127:
                // 1 sources

                scr = masm.getScratchRegister();
                var8_14 = null;
                scratch = scr.getRegister();
                crb.asDoubleConstRef(input);
                masm.adrpAdd(scratch);
                masm.fldr(64, dst, AArch64Address.createBaseRegisterOnlyAddress(scratch));
                if (scr == null) break;
                if (var8_14 == null) ** GOTO lbl143
                try {
                    scr.close();
                }
                catch (Throwable var9_25) {
                    var8_14.addSuppressed(var9_25);
                }
                break;
lbl143:
                // 1 sources

                scr.close();
                break;
                catch (Throwable var9_26) {
                    try {
                        var8_14 = var9_26;
                        throw var9_26;
                    }
                    catch (Throwable var16_33) {
                        if (scr != null) {
                            if (var8_14 != null) {
                                try {
                                    scr.close();
                                }
                                catch (Throwable var17_34) {
                                    var8_14.addSuppressed(var17_34);
                                }
                            } else {
                                scr.close();
                            }
                        }
                        throw var16_33;
                    }
                }
            }
            case 9: {
                if (input.isNull()) {
                    if (crb.mustReplaceWithUncompressedNullRegister(input)) {
                        masm.mov(64, dst, crb.uncompressedNullRegister);
                        break;
                    }
                    masm.mov(dst, 0);
                    break;
                }
                if (crb.target.inlineObjects) {
                    crb.recordInlineDataInCode((Constant)input);
                    masm.mov(dst, -2401018187971961171L, true);
                    break;
                }
                crb.recordDataReferenceInCode((Constant)input, 8);
                masm.adrpLdr(64, dst, dst);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("kind=" + input.getJavaKind().getStackKind());
            }
        }
    }

    private static void const2stack(CompilationResultBuilder crb, AArch64MacroAssembler masm, Value result, JavaConstant constant) {
        block25: {
            try (AArch64MacroAssembler.ScratchRegister addrReg = masm.getScratchRegister();){
                StackSlot slot = (StackSlot)result;
                AArch64Address resultAddress = AArch64Move.loadStackSlotAddress(crb, masm, slot, addrReg.getRegister());
                if (constant.isNull() && !crb.mustReplaceWithUncompressedNullRegister(constant)) {
                    AArch64Move.emitStore(crb, masm, (AArch64Kind)result.getPlatformKind(), resultAddress, (Value)AArch64.zr.asValue((ValueKind)LIRKind.combine(result)));
                    break block25;
                }
                try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                    RegisterValue scratchRegisterValue = sc.getRegister().asValue((ValueKind)LIRKind.combine(result));
                    AArch64Move.const2reg(crb, masm, (Value)scratchRegisterValue, constant);
                    AArch64Move.emitStore(crb, masm, (AArch64Kind)result.getPlatformKind(), resultAddress, (Value)scratchRegisterValue);
                }
            }
        }
    }

    private static AArch64Address loadStackSlotAddress(CompilationResultBuilder crb, AArch64MacroAssembler masm, StackSlot slot, AllocatableValue scratch) {
        Register scratchReg = Value.ILLEGAL.equals((Object)scratch) ? AArch64.zr : ValueUtil.asRegister((Value)scratch);
        return AArch64Move.loadStackSlotAddress(crb, masm, slot, scratchReg);
    }

    private static AArch64Address loadStackSlotAddress(CompilationResultBuilder crb, AArch64MacroAssembler masm, StackSlot slot, Register scratchReg) {
        int displacement = crb.frameMap.offsetForStackSlot(slot);
        int transferSize = slot.getPlatformKind().getSizeInBytes();
        return masm.makeAddress(AArch64.sp, displacement, scratchReg, transferSize, false);
    }

    public static class ConvertZeroToNullOp
    extends ZeroNullConversionOp {
        public static final LIRInstructionClass<ConvertZeroToNullOp> TYPE = LIRInstructionClass.create(ConvertZeroToNullOp.class);

        public ConvertZeroToNullOp(AllocatableValue result, AllocatableValue input) {
            super(TYPE, result, input);
        }

        @Override
        protected final void emitConversion(Register resultRegister, Register inputRegister, Register nullRegister, AArch64MacroAssembler masm) {
            if (!inputRegister.equals((Object)resultRegister)) {
                masm.movx(resultRegister, inputRegister);
            }
            Label done = new Label();
            masm.ands(64, AArch64.zr, inputRegister, inputRegister);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, done);
            masm.movx(resultRegister, nullRegister);
            masm.bind(done);
        }
    }

    public static class ConvertNullToZeroOp
    extends ZeroNullConversionOp {
        public static final LIRInstructionClass<ConvertNullToZeroOp> TYPE = LIRInstructionClass.create(ConvertNullToZeroOp.class);

        public ConvertNullToZeroOp(AllocatableValue result, AllocatableValue input) {
            super(TYPE, result, input);
        }

        @Override
        protected final void emitConversion(Register resultRegister, Register inputRegister, Register nullRegister, AArch64MacroAssembler masm) {
            if (inputRegister.equals((Object)resultRegister)) {
                masm.subs(64, inputRegister, inputRegister, nullRegister);
                Label done = new Label();
                masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, done);
                masm.add(64, inputRegister, inputRegister, nullRegister);
                masm.bind(done);
            } else {
                masm.subs(64, resultRegister, resultRegister, resultRegister);
                masm.cmp(64, inputRegister, nullRegister);
                Label done = new Label();
                masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, done);
                masm.movx(resultRegister, inputRegister);
                masm.bind(done);
            }
        }
    }

    private static abstract class ZeroNullConversionOp
    extends AArch64LIRInstruction {
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;

        protected ZeroNullConversionOp(LIRInstructionClass<? extends ZeroNullConversionOp> type, AllocatableValue result, AllocatableValue input) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)type);
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register nullRegister = crb.uncompressedNullRegister;
            if (!nullRegister.equals((Object)Register.None)) {
                this.emitConversion(ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.input), nullRegister, masm);
            }
        }

        protected abstract void emitConversion(Register var1, Register var2, Register var3, AArch64MacroAssembler var4);
    }

    public static class UncompressPointerOp
    extends PointerCompressionOp {
        public static final LIRInstructionClass<UncompressPointerOp> TYPE = LIRInstructionClass.create(UncompressPointerOp.class);

        public UncompressPointerOp(AllocatableValue result, Value input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull, LIRKindTool lirKindTool) {
            this(TYPE, result, input, baseRegister, encoding, nonNull, lirKindTool);
        }

        private UncompressPointerOp(LIRInstructionClass<? extends PointerCompressionOp> type, AllocatableValue result, Value input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull, LIRKindTool lirKindTool) {
            super(type, result, input, baseRegister, encoding, nonNull, lirKindTool);
        }

        @Override
        protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register base;
            Register inputRegister = ValueUtil.asRegister((Value)this.getInput());
            Register resultRegister = this.getResultRegister();
            Register register = base = this.encoding.hasBase() ? this.getBaseRegister(crb) : null;
            if (this.nonNull || base == null) {
                masm.add(64, resultRegister, base == null ? AArch64.zr : base, inputRegister, AArch64Assembler.ShiftType.LSL, this.encoding.getShift());
            } else {
                Label done = new Label();
                if (!resultRegister.equals((Object)inputRegister)) {
                    masm.mov(32, resultRegister, inputRegister);
                }
                masm.cbz(32, resultRegister, done);
                masm.add(64, resultRegister, base, resultRegister, AArch64Assembler.ShiftType.LSL, this.encoding.getShift());
                masm.bind(done);
            }
        }
    }

    public static class CompressPointerOp
    extends PointerCompressionOp {
        public static final LIRInstructionClass<CompressPointerOp> TYPE = LIRInstructionClass.create(CompressPointerOp.class);

        public CompressPointerOp(AllocatableValue result, Value input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull, LIRKindTool lirKindTool) {
            this(TYPE, result, input, baseRegister, encoding, nonNull, lirKindTool);
        }

        private CompressPointerOp(LIRInstructionClass<? extends PointerCompressionOp> type, AllocatableValue result, Value input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull, LIRKindTool lirKindTool) {
            super(type, result, input, baseRegister, encoding, nonNull, lirKindTool);
        }

        @Override
        protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register resultRegister = this.getResultRegister();
            Register ptr = ValueUtil.asRegister((Value)this.getInput());
            Register base = this.getBaseRegister(crb);
            if (!this.encoding.hasBase()) {
                if (this.encoding.hasShift()) {
                    masm.lshr(64, resultRegister, ptr, this.encoding.getShift());
                } else {
                    masm.movx(resultRegister, ptr);
                }
            } else if (this.nonNull) {
                masm.sub(64, resultRegister, ptr, base);
                if (this.encoding.hasShift()) {
                    masm.lshr(64, resultRegister, resultRegister, this.encoding.getShift());
                }
            } else {
                masm.cmp(64, ptr, 0);
                masm.cmov(64, resultRegister, ptr, base, AArch64Assembler.ConditionFlag.NE);
                masm.sub(64, resultRegister, resultRegister, base);
                if (this.encoding.hasShift()) {
                    masm.lshr(64, resultRegister, resultRegister, this.encoding.getShift());
                }
            }
        }
    }

    public static abstract class PointerCompressionOp
    extends AArch64LIRInstruction {
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        private AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
        private Value input;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL, LIRInstruction.OperandFlag.UNINITIALIZED})
        private AllocatableValue baseRegister;
        protected final CompressEncoding encoding;
        protected final boolean nonNull;
        protected final LIRKindTool lirKindTool;

        protected PointerCompressionOp(LIRInstructionClass<? extends PointerCompressionOp> type, AllocatableValue result, Value input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull, LIRKindTool lirKindTool) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)type);
            this.result = result;
            this.input = input;
            this.baseRegister = baseRegister;
            this.encoding = encoding;
            this.nonNull = nonNull;
            this.lirKindTool = lirKindTool;
        }

        public static boolean hasBase(OptionValues options, CompressEncoding encoding) {
            return GraalOptions.GeneratePIC.getValue(options) != false || encoding.hasBase();
        }

        public final Value getInput() {
            return this.input;
        }

        public final AllocatableValue getResult() {
            return this.result;
        }

        protected final Register getResultRegister() {
            return ValueUtil.asRegister((Value)this.result);
        }

        protected final Register getBaseRegister(CompilationResultBuilder crb) {
            return PointerCompressionOp.hasBase(crb.getOptions(), this.encoding) ? ValueUtil.asRegister((Value)this.baseRegister) : Register.None;
        }

        protected final int getShift() {
            return this.encoding.getShift();
        }

        protected final void move(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64Move.move(crb, masm, this.result, this.input);
        }
    }

    public static final class NullCheckOp
    extends AArch64LIRInstruction
    implements StandardOp.NullCheck {
        public static final LIRInstructionClass<NullCheckOp> TYPE = LIRInstructionClass.create(NullCheckOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AArch64AddressValue address;
        @LIRInstruction.State
        protected LIRFrameState state;

        public NullCheckOp(AArch64AddressValue address, LIRFrameState state) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.address = address;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int prePosition = masm.position();
            masm.ldr(64, AArch64.zr, this.address.toAddress());
            int implicitExceptionPosition = prePosition;
            if (prePosition == masm.position() && masm.isImmLoadStoreMerged() && crb.isImplicitExceptionExist(implicitExceptionPosition = prePosition - 4)) {
                return;
            }
            crb.recordImplicitException(implicitExceptionPosition, this.state);
        }

        @Override
        public Value getCheckedValue() {
            return this.address.base;
        }

        @Override
        public LIRFrameState getState() {
            return this.state;
        }
    }

    public static class VolatileStoreOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<VolatileStoreOp> TYPE = LIRInstructionClass.create(VolatileStoreOp.class);
        protected final AArch64Kind kind;
        @LIRInstruction.State
        protected LIRFrameState state;
        @LIRInstruction.Use
        protected AllocatableValue input;
        @LIRInstruction.Use
        protected AllocatableValue address;

        public VolatileStoreOp(AArch64Kind kind, AllocatableValue address, AllocatableValue input, LIRFrameState state) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.kind = kind;
            this.address = address;
            this.input = input;
            this.state = state;
            if (state != null) {
                throw GraalError.shouldNotReachHere("Can't handle implicit null check");
            }
        }

        @Override
        protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int destSize = this.kind.getSizeInBytes() * 8;
            if (this.kind.isInteger()) {
                masm.stlr(destSize, ValueUtil.asRegister((Value)this.input), ValueUtil.asRegister((Value)this.address));
            } else {
                try (AArch64MacroAssembler.ScratchRegister r1 = masm.getScratchRegister();){
                    Register rscratch1 = r1.getRegister();
                    masm.fmov(destSize, rscratch1, ValueUtil.asRegister((Value)this.input));
                    masm.stlr(destSize, rscratch1, ValueUtil.asRegister((Value)this.address));
                }
            }
        }

        public AArch64Kind getKind() {
            return this.kind;
        }
    }

    public static final class StoreConstantOp
    extends MemOp {
        public static final LIRInstructionClass<StoreConstantOp> TYPE = LIRInstructionClass.create(StoreConstantOp.class);
        protected final JavaConstant input;

        public StoreConstantOp(AArch64Kind kind, AArch64AddressValue address, JavaConstant input, LIRFrameState state) {
            super(TYPE, kind, address, state);
            this.input = input;
            if (!input.isDefaultForKind()) {
                throw GraalError.shouldNotReachHere("Can only store null constants to memory");
            }
        }

        @Override
        public void emitMemAccess(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64Move.emitStore(crb, masm, this.kind, this.addressValue.toAddress(), (Value)AArch64.zr.asValue((ValueKind)LIRKind.combine(this.addressValue)));
        }
    }

    public static class StoreOp
    extends MemOp {
        public static final LIRInstructionClass<StoreOp> TYPE = LIRInstructionClass.create(StoreOp.class);
        @LIRInstruction.Use
        protected AllocatableValue input;

        public StoreOp(AArch64Kind kind, AArch64AddressValue address, AllocatableValue input, LIRFrameState state) {
            super(TYPE, kind, address, state);
            this.input = input;
        }

        @Override
        protected void emitMemAccess(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64Move.emitStore(crb, masm, this.kind, this.addressValue.toAddress(), (Value)this.input);
        }
    }

    public static final class VolatileLoadOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<VolatileLoadOp> TYPE = LIRInstructionClass.create(VolatileLoadOp.class);
        protected final AArch64Kind kind;
        @LIRInstruction.State
        protected LIRFrameState state;
        @LIRInstruction.Def
        protected AllocatableValue result;
        @LIRInstruction.Use
        protected AllocatableValue address;

        public VolatileLoadOp(AArch64Kind kind, AllocatableValue result, AllocatableValue address, LIRFrameState state) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.kind = kind;
            this.result = result;
            this.address = address;
            this.state = state;
            if (state != null) {
                throw GraalError.shouldNotReachHere("Can't handle implicit null check");
            }
        }

        @Override
        protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int srcSize = this.kind.getSizeInBytes() * 8;
            int destSize = this.result.getPlatformKind().getSizeInBytes() * 8;
            if (this.kind.isInteger()) {
                masm.ldar(srcSize, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.address));
            } else {
                assert (srcSize == destSize);
                try (AArch64MacroAssembler.ScratchRegister r1 = masm.getScratchRegister();){
                    Register rscratch1 = r1.getRegister();
                    masm.ldar(srcSize, rscratch1, ValueUtil.asRegister((Value)this.address));
                    masm.fmov(destSize, ValueUtil.asRegister((Value)this.result), rscratch1);
                }
            }
        }

        public AArch64Kind getKind() {
            return this.kind;
        }
    }

    public static final class LoadOp
    extends MemOp {
        public static final LIRInstructionClass<LoadOp> TYPE = LIRInstructionClass.create(LoadOp.class);
        @LIRInstruction.Def
        protected AllocatableValue result;

        public LoadOp(AArch64Kind kind, AllocatableValue result, AArch64AddressValue address, LIRFrameState state) {
            super(TYPE, kind, address, state);
            this.result = result;
        }

        @Override
        protected void emitMemAccess(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64Address address = this.addressValue.toAddress();
            Register dst = ValueUtil.asRegister((Value)this.result);
            int destSize = this.result.getPlatformKind().getSizeInBytes() * 8;
            int srcSize = this.kind.getSizeInBytes() * 8;
            if (this.kind.isInteger()) {
                masm.ldr(srcSize, dst, address);
            } else {
                assert (srcSize == destSize);
                masm.fldr(srcSize, dst, address);
            }
        }
    }

    static abstract class MemOp
    extends AArch64LIRInstruction
    implements StandardOp.ImplicitNullCheck {
        protected final AArch64Kind kind;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AArch64AddressValue addressValue;
        @LIRInstruction.State
        protected LIRFrameState state;

        MemOp(LIRInstructionClass<? extends MemOp> c, AArch64Kind kind, AArch64AddressValue address, LIRFrameState state) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)c);
            this.kind = kind;
            this.addressValue = address;
            this.state = state;
        }

        protected abstract void emitMemAccess(CompilationResultBuilder var1, AArch64MacroAssembler var2);

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int prePosition = masm.position();
            this.emitMemAccess(crb, masm);
            if (this.state != null) {
                int implicitExceptionPosition = prePosition;
                if (this.kind.isInteger() && prePosition == masm.position() && masm.isImmLoadStoreMerged() && crb.isImplicitExceptionExist(implicitExceptionPosition = prePosition - 4)) {
                    return;
                }
                crb.recordImplicitException(implicitExceptionPosition, this.state);
            }
        }

        @Override
        public boolean makeNullCheckFor(Value value, LIRFrameState nullCheckState, int implicitNullCheckLimit) {
            int displacement = this.addressValue.getDisplacement();
            if (this.state == null && value.equals((Object)this.addressValue.getBase()) && this.addressValue.getOffset().equals((Object)Value.ILLEGAL) && displacement >= 0 && displacement < implicitNullCheckLimit) {
                this.state = nullCheckState;
                return true;
            }
            return false;
        }
    }

    public static class MembarOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<MembarOp> TYPE = LIRInstructionClass.create(MembarOp.class);
        private final int barriers;

        public MembarOp(int barriers) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.barriers = barriers;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            assert (this.barriers >= 1 && this.barriers <= 15);
            switch (this.barriers) {
                case 8: {
                    masm.dmb(AArch64Assembler.BarrierKind.STORE_STORE);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    masm.dmb(AArch64Assembler.BarrierKind.LOAD_LOAD);
                    break;
                }
                default: {
                    masm.dmb(AArch64Assembler.BarrierKind.ANY_ANY);
                }
            }
        }
    }

    public static class StackLoadAddressOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<StackLoadAddressOp> TYPE = LIRInstructionClass.create(StackLoadAddressOp.class);
        @LIRInstruction.Def
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.UNINITIALIZED})
        protected AllocatableValue slot;

        public StackLoadAddressOp(AllocatableValue result, AllocatableValue slot) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            assert (slot instanceof VirtualStackSlot || slot instanceof StackSlot);
            this.result = result;
            this.slot = slot;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            try (AArch64MacroAssembler.ScratchRegister addrReg = masm.getScratchRegister();){
                AArch64Address address = AArch64Move.loadStackSlotAddress(crb, masm, (StackSlot)this.slot, addrReg.getRegister());
                AArch64Kind kind = AArch64Kind.QWORD;
                masm.loadAddress(ValueUtil.asRegister((Value)this.result, (PlatformKind)kind), address, kind.getSizeInBytes());
            }
        }
    }

    public static class LoadDataOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<LoadDataOp> TYPE = LIRInstructionClass.create(LoadDataOp.class);
        @LIRInstruction.Def
        protected AllocatableValue result;
        private final DataPointerConstant data;

        public LoadDataOp(AllocatableValue result, DataPointerConstant data) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.result = result;
            this.data = data;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register dst = ValueUtil.asRegister((Value)this.result);
            crb.recordDataReferenceInCode(this.data);
            masm.adrpAdd(dst);
        }
    }

    public static class LoadAddressOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<LoadAddressOp> TYPE = LIRInstructionClass.create(LoadAddressOp.class);
        @LIRInstruction.Def
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AArch64AddressValue address;

        public LoadAddressOp(AllocatableValue result, AArch64AddressValue address) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.result = result;
            this.address = address;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register dst = ValueUtil.asRegister((Value)this.result);
            AArch64Address adr = this.address.toAddress();
            masm.loadAddress(dst, adr, this.address.getScaleFactor());
        }
    }

    @Opcode(value="MOVE")
    public static class Move
    extends AArch64LIRInstruction
    implements StandardOp.ValueMoveOp {
        public static final LIRInstructionClass<Move> TYPE = LIRInstructionClass.create(Move.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue input;

        public Move(AllocatableValue result, AllocatableValue input) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
            assert (!ValueUtil.isStackSlot((Value)result) || !ValueUtil.isStackSlot((Value)input));
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64Move.move(crb, masm, this.getResult(), (Value)this.getInput());
        }

        @Override
        public AllocatableValue getInput() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }

    public static class LoadInlineConstant
    extends AArch64LIRInstruction
    implements StandardOp.LoadConstantOp {
        public static final LIRInstructionClass<LoadInlineConstant> TYPE = LIRInstructionClass.create(LoadInlineConstant.class);
        private JavaConstant constant;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        AllocatableValue result;

        public LoadInlineConstant(JavaConstant constant, AllocatableValue result) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.constant = constant;
            this.result = result;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.result)) {
                AArch64Move.const2reg(crb, masm, (Value)this.result, this.constant);
            } else if (ValueUtil.isStackSlot((Value)this.result)) {
                StackSlot slot = ValueUtil.asStackSlot((Value)this.result);
                AArch64Move.const2stack(crb, masm, (Value)slot, this.constant);
            }
        }

        @Override
        public Constant getConstant() {
            return this.constant;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }
}

