/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public enum AArch64ArithmeticOp {
    NEG,
    NOT,
    ADD(ARMv8ConstantCategory.ARITHMETIC),
    ADDS(ARMv8ConstantCategory.ARITHMETIC),
    SUB(ARMv8ConstantCategory.ARITHMETIC),
    SUBS(ARMv8ConstantCategory.ARITHMETIC),
    MUL,
    MULVS,
    MNEG,
    DIV,
    SMULH,
    UMULH,
    SMULL,
    SMNEGL,
    MADD,
    MSUB,
    FMADD,
    SMADDL,
    SMSUBL,
    REM,
    UDIV,
    UREM,
    AND(ARMv8ConstantCategory.LOGICAL),
    ANDS(ARMv8ConstantCategory.LOGICAL),
    OR(ARMv8ConstantCategory.LOGICAL),
    XOR(ARMv8ConstantCategory.LOGICAL),
    BIC,
    ORN,
    EON,
    SHL(ARMv8ConstantCategory.SHIFT),
    LSHR(ARMv8ConstantCategory.SHIFT),
    ASHR(ARMv8ConstantCategory.SHIFT),
    ROR(ARMv8ConstantCategory.SHIFT),
    RORV(ARMv8ConstantCategory.SHIFT),
    ABS,
    FADD,
    FSUB,
    FMUL,
    FDIV,
    FNEG,
    FABS,
    FRINTM,
    FRINTN,
    FRINTP,
    FMAX,
    FMIN,
    SQRT;

    public final ARMv8ConstantCategory category;

    private AArch64ArithmeticOp(ARMv8ConstantCategory category) {
        this.category = category;
    }

    private AArch64ArithmeticOp() {
        this(ARMv8ConstantCategory.NONE);
    }

    public static class MultiplyAddSubOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<MultiplyAddSubOp> TYPE = LIRInstructionClass.create(MultiplyAddSubOp.class);
        @Opcode
        private final AArch64ArithmeticOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue src1;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue src2;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue src3;

        public MultiplyAddSubOp(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue src1, AllocatableValue src2, AllocatableValue src3) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.src1 = src1;
            this.src2 = src2;
            this.src3 = src3;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int size = this.result.getPlatformKind().getSizeInBytes() * 8;
            switch (this.op) {
                case MADD: {
                    masm.madd(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), ValueUtil.asRegister((Value)this.src3));
                    break;
                }
                case MSUB: {
                    masm.msub(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), ValueUtil.asRegister((Value)this.src3));
                    break;
                }
                case FMADD: {
                    masm.fmadd(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), ValueUtil.asRegister((Value)this.src3));
                    break;
                }
                case SMADDL: {
                    assert (size == 64);
                    masm.smaddl(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), ValueUtil.asRegister((Value)this.src3));
                    break;
                }
                case SMSUBL: {
                    assert (size == 64);
                    masm.smsubl(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), ValueUtil.asRegister((Value)this.src3));
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere();
                }
            }
        }
    }

    public static class ExtendedAddSubShiftOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<ExtendedAddSubShiftOp> TYPE = LIRInstructionClass.create(ExtendedAddSubShiftOp.class);
        @Opcode
        private final AArch64ArithmeticOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue src1;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue src2;
        private final AArch64Assembler.ExtendType extendType;
        private final int shiftAmt;

        public ExtendedAddSubShiftOp(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue src1, AllocatableValue src2, AArch64Assembler.ExtendType extendType, int shiftAmt) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.src1 = src1;
            this.src2 = src2;
            this.extendType = extendType;
            this.shiftAmt = shiftAmt;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int size = this.result.getPlatformKind().getSizeInBytes() * 8;
            switch (this.op) {
                case ADD: {
                    masm.add(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.extendType, this.shiftAmt);
                    break;
                }
                case SUB: {
                    masm.sub(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.extendType, this.shiftAmt);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere();
                }
            }
        }
    }

    public static class BinaryShiftOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<BinaryShiftOp> TYPE = LIRInstructionClass.create(BinaryShiftOp.class);
        @Opcode
        private final AArch64ArithmeticOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue src1;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue src2;
        private final AArch64Assembler.ShiftType shiftType;
        private final int shiftAmt;

        public BinaryShiftOp(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue src1, AllocatableValue src2, AArch64Assembler.ShiftType shiftType, int shiftAmt) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.src1 = src1;
            this.src2 = src2;
            this.shiftType = shiftType;
            this.shiftAmt = shiftAmt;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int size = this.result.getPlatformKind().getSizeInBytes() * 8;
            switch (this.op) {
                case ADD: {
                    masm.add(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.shiftType, this.shiftAmt);
                    break;
                }
                case SUB: {
                    masm.sub(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.shiftType, this.shiftAmt);
                    break;
                }
                case AND: {
                    masm.and(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.shiftType, this.shiftAmt);
                    break;
                }
                case OR: {
                    masm.or(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.shiftType, this.shiftAmt);
                    break;
                }
                case XOR: {
                    masm.eor(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.shiftType, this.shiftAmt);
                    break;
                }
                case BIC: {
                    masm.bic(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.shiftType, this.shiftAmt);
                    break;
                }
                case ORN: {
                    masm.orn(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.shiftType, this.shiftAmt);
                    break;
                }
                case EON: {
                    masm.eon(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.shiftType, this.shiftAmt);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("op=" + this.op.name());
                }
            }
        }
    }

    public static class BinaryCompositeOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<BinaryCompositeOp> TYPE = LIRInstructionClass.create(BinaryCompositeOp.class);
        @Opcode
        private final AArch64ArithmeticOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue a;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue b;

        public BinaryCompositeOp(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue a, AllocatableValue b) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.a = a;
            this.b = b;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register src1 = ValueUtil.asRegister((Value)this.a);
            Register src2 = ValueUtil.asRegister((Value)this.b);
            int size = this.result.getPlatformKind().getSizeInBytes() * 8;
            switch (this.op) {
                case REM: {
                    masm.rem(size, dst, src1, src2);
                    break;
                }
                case UREM: {
                    masm.urem(size, dst, src1, src2);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere();
                }
            }
        }
    }

    public static class BinaryOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<BinaryOp> TYPE = LIRInstructionClass.create(BinaryOp.class);
        @Opcode
        private final AArch64ArithmeticOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue a;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue b;

        public BinaryOp(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue a, AllocatableValue b) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.a = a;
            this.b = b;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register src1 = ValueUtil.asRegister((Value)this.a);
            Register src2 = ValueUtil.asRegister((Value)this.b);
            int size = this.result.getPlatformKind().getSizeInBytes() * 8;
            switch (this.op) {
                case ADD: {
                    masm.add(size, dst, src1, src2);
                    break;
                }
                case ADDS: {
                    masm.adds(size, dst, src1, src2);
                    break;
                }
                case SUB: {
                    masm.sub(size, dst, src1, src2);
                    break;
                }
                case SUBS: {
                    masm.subs(size, dst, src1, src2);
                    break;
                }
                case MUL: {
                    masm.mul(size, dst, src1, src2);
                    break;
                }
                case UMULH: {
                    masm.umulh(size, dst, src1, src2);
                    break;
                }
                case SMULH: {
                    masm.smulh(size, dst, src1, src2);
                    break;
                }
                case MNEG: {
                    masm.mneg(size, dst, src1, src2);
                    break;
                }
                case SMULL: {
                    masm.smull(size, dst, src1, src2);
                    break;
                }
                case SMNEGL: {
                    masm.smnegl(size, dst, src1, src2);
                    break;
                }
                case DIV: {
                    masm.sdiv(size, dst, src1, src2);
                    break;
                }
                case UDIV: {
                    masm.udiv(size, dst, src1, src2);
                    break;
                }
                case AND: {
                    masm.and(size, dst, src1, src2);
                    break;
                }
                case ANDS: {
                    masm.ands(size, dst, src1, src2);
                    break;
                }
                case OR: {
                    masm.or(size, dst, src1, src2);
                    break;
                }
                case XOR: {
                    masm.eor(size, dst, src1, src2);
                    break;
                }
                case BIC: {
                    masm.bic(size, dst, src1, src2);
                    break;
                }
                case ORN: {
                    masm.orn(size, dst, src1, src2);
                    break;
                }
                case EON: {
                    masm.eon(size, dst, src1, src2);
                    break;
                }
                case SHL: {
                    masm.shl(size, dst, src1, src2);
                    break;
                }
                case LSHR: {
                    masm.lshr(size, dst, src1, src2);
                    break;
                }
                case ASHR: {
                    masm.ashr(size, dst, src1, src2);
                    break;
                }
                case RORV: {
                    masm.rorv(size, dst, src1, src2);
                    break;
                }
                case FADD: {
                    masm.fadd(size, dst, src1, src2);
                    break;
                }
                case FSUB: {
                    masm.fsub(size, dst, src1, src2);
                    break;
                }
                case FMUL: {
                    masm.fmul(size, dst, src1, src2);
                    break;
                }
                case FDIV: {
                    masm.fdiv(size, dst, src1, src2);
                    break;
                }
                case FMAX: {
                    masm.fmax(size, dst, src1, src2);
                    break;
                }
                case FMIN: {
                    masm.fmin(size, dst, src1, src2);
                    break;
                }
                case MULVS: {
                    masm.mulvs(size, dst, src1, src2);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("op=" + this.op.name());
                }
            }
        }
    }

    public static class BinaryConstOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<BinaryConstOp> TYPE = LIRInstructionClass.create(BinaryConstOp.class);
        @Opcode
        private final AArch64ArithmeticOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue a;
        private final JavaConstant b;

        public BinaryConstOp(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue a, JavaConstant b) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.a = a;
            this.b = b;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            assert (this.op.category != ARMv8ConstantCategory.NONE);
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register src = ValueUtil.asRegister((Value)this.a);
            int size = this.result.getPlatformKind().getSizeInBytes() * 8;
            switch (this.op) {
                case ADD: {
                    assert (AArch64MacroAssembler.isArithmeticImmediate(this.b.asLong()));
                    masm.add(size, dst, src, (int)this.b.asLong());
                    break;
                }
                case SUB: {
                    assert (AArch64MacroAssembler.isArithmeticImmediate(this.b.asLong()));
                    masm.sub(size, dst, src, (int)this.b.asLong());
                    break;
                }
                case ADDS: {
                    assert (AArch64MacroAssembler.isArithmeticImmediate(this.b.asLong()));
                    masm.adds(size, dst, src, (int)this.b.asLong());
                    break;
                }
                case SUBS: {
                    assert (AArch64MacroAssembler.isArithmeticImmediate(this.b.asLong()));
                    masm.subs(size, dst, src, (int)this.b.asLong());
                    break;
                }
                case AND: {
                    if (size == 32 && this.b.asLong() == 0xFFFFFFFFL) {
                        masm.mov(size, dst, src);
                        break;
                    }
                    masm.and(size, dst, src, this.b.asLong());
                    break;
                }
                case ANDS: {
                    masm.ands(size, dst, src, this.b.asLong());
                    break;
                }
                case OR: {
                    masm.or(size, dst, src, this.b.asLong());
                    break;
                }
                case XOR: {
                    masm.eor(size, dst, src, this.b.asLong());
                    break;
                }
                case SHL: {
                    masm.shl(size, dst, src, this.b.asLong());
                    break;
                }
                case LSHR: {
                    masm.lshr(size, dst, src, this.b.asLong());
                    break;
                }
                case ASHR: {
                    masm.ashr(size, dst, src, this.b.asLong());
                    break;
                }
                case ROR: {
                    masm.ror(size, dst, src, (int)this.b.asLong());
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("op=" + this.op.name());
                }
            }
        }
    }

    public static class UnaryOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<UnaryOp> TYPE = LIRInstructionClass.create(UnaryOp.class);
        @Opcode
        private final AArch64ArithmeticOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;

        public UnaryOp(AArch64ArithmeticOp opcode, AllocatableValue result, AllocatableValue x) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.result = result;
            this.x = x;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register src = ValueUtil.asRegister((Value)this.x);
            int size = this.result.getPlatformKind().getSizeInBytes() * 8;
            switch (this.opcode) {
                case NEG: {
                    masm.sub(size, dst, AArch64.zr, src);
                    break;
                }
                case FNEG: {
                    masm.fneg(size, dst, src);
                    break;
                }
                case NOT: {
                    masm.not(size, dst, src);
                    break;
                }
                case ABS: {
                    masm.cmp(size, src, 0);
                    masm.csneg(size, dst, src, AArch64Assembler.ConditionFlag.LT);
                    break;
                }
                case FABS: {
                    masm.fabs(size, dst, src);
                    break;
                }
                case FRINTM: {
                    masm.frintm(size, dst, src);
                    break;
                }
                case FRINTN: {
                    masm.frintn(size, dst, src);
                    break;
                }
                case FRINTP: {
                    masm.frintp(size, dst, src);
                    break;
                }
                case SQRT: {
                    masm.fsqrt(size, dst, src);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("op=" + this.opcode.name());
                }
            }
        }
    }

    public static enum ARMv8ConstantCategory {
        NONE,
        LOGICAL,
        ARITHMETIC,
        SHIFT;

    }
}

