/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterSaveLayout;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.InstructionValueProcedure;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.framemap.FrameMap;

public class StandardOp {

    public static final class StackMove
    extends LIRInstruction
    implements ValueMoveOp {
        public static final LIRInstructionClass<StackMove> TYPE = LIRInstructionClass.create(StackMove.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue input;

        public StackMove(AllocatableValue result, AllocatableValue input) {
            super(TYPE);
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb) {
            throw new GraalError(this + " should have been removed");
        }

        @Override
        public AllocatableValue getInput() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }

    @Opcode(value="SPILLREGISTERS")
    public static final class SpillRegistersOp
    extends LIRInstruction {
        public static final LIRInstructionClass<SpillRegistersOp> TYPE = LIRInstructionClass.create(SpillRegistersOp.class);

        public SpillRegistersOp() {
            super(TYPE);
        }

        @Override
        public boolean destroysCallerSavedRegisters() {
            return true;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb) {
        }
    }

    public static final class BindToRegisterOp
    extends LIRInstruction {
        public static final LIRInstructionClass<BindToRegisterOp> TYPE = LIRInstructionClass.create(BindToRegisterOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        private Value value;

        public BindToRegisterOp(Value value) {
            super(TYPE);
            this.value = value;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb) {
        }
    }

    @Opcode(value="BLACKHOLE")
    public static final class BlackholeOp
    extends LIRInstruction {
        public static final LIRInstructionClass<BlackholeOp> TYPE = LIRInstructionClass.create(BlackholeOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.CONST})
        private Value value;

        public BlackholeOp(Value value) {
            super(TYPE);
            this.value = value;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb) {
        }
    }

    public static final class NoOp
    extends LIRInstruction {
        public static final LIRInstructionClass<NoOp> TYPE = LIRInstructionClass.create(NoOp.class);
        final AbstractBlockBase<?> block;
        final int index;

        public NoOp(AbstractBlockBase<?> block, int index) {
            super(TYPE);
            this.block = block;
            this.index = index;
        }

        public void replace(LIR lir, LIRInstruction replacement) {
            ArrayList<LIRInstruction> instructions = lir.getLIRforBlock(this.block);
            assert (instructions.get(this.index).equals(this)) : String.format("Replacing the wrong instruction: %s instead of %s", instructions.get(this.index), this);
            instructions.set(this.index, replacement);
        }

        public void remove(LIR lir) {
            ArrayList<LIRInstruction> instructions = lir.getLIRforBlock(this.block);
            assert (instructions.get(this.index).equals(this)) : String.format("Removing the wrong instruction: %s instead of %s", instructions.get(this.index), this);
            instructions.remove(this.index);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb) {
            if (this.block != null) {
                throw new GraalError(this + " should have been replaced");
            }
        }
    }

    public static interface ZapRegistersOp {
    }

    public static interface RestoreRegistersOp {
    }

    public static abstract class SaveRegistersOp
    extends LIRInstruction {
        public static final LIRInstructionClass<SaveRegistersOp> TYPE = LIRInstructionClass.create(SaveRegistersOp.class);
        protected final Register[] savedRegisters;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.STACK})
        protected final AllocatableValue[] slots;

        protected SaveRegistersOp(LIRInstructionClass<? extends SaveRegistersOp> c, Register[] savedRegisters, AllocatableValue[] savedRegisterLocations) {
            super(c);
            assert (Arrays.asList(savedRegisterLocations).stream().allMatch(LIRValueUtil::isVirtualStackSlot));
            this.savedRegisters = savedRegisters;
            this.slots = savedRegisterLocations;
        }

        public int remove(EconomicSet<Register> doNotSave) {
            return SaveRegistersOp.prune(doNotSave, this.savedRegisters);
        }

        public RegisterSaveLayout getMap(FrameMap frameMap) {
            int total = 0;
            for (int i = 0; i < this.savedRegisters.length; ++i) {
                if (this.savedRegisters[i] == null) continue;
                ++total;
            }
            Register[] keys = new Register[total];
            int[] values = new int[total];
            if (total != 0) {
                int mapIndex = 0;
                for (int i = 0; i < this.savedRegisters.length; ++i) {
                    if (this.savedRegisters[i] == null) continue;
                    keys[mapIndex] = this.savedRegisters[i];
                    assert (ValueUtil.isStackSlot((Value)this.slots[i])) : "not a StackSlot: " + this.slots[i];
                    StackSlot slot = ValueUtil.asStackSlot((Value)this.slots[i]);
                    values[mapIndex] = SaveRegistersOp.indexForStackSlot(frameMap, slot);
                    ++mapIndex;
                }
                assert (mapIndex == total);
            }
            return new RegisterSaveLayout(keys, values);
        }

        public Register[] getSavedRegisters() {
            return this.savedRegisters;
        }

        public EconomicSet<Register> getSaveableRegisters() {
            EconomicSet registers = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
            for (Register r : this.savedRegisters) {
                registers.add((Object)r);
            }
            return registers;
        }

        public AllocatableValue[] getSlots() {
            return this.slots;
        }

        @Override
        public abstract void emitCode(CompilationResultBuilder var1);

        static int prune(EconomicSet<Register> toRemove, Register[] registers) {
            int pruned = 0;
            for (int i = 0; i < registers.length; ++i) {
                if (registers[i] == null || !toRemove.contains((Object)registers[i])) continue;
                registers[i] = null;
                ++pruned;
            }
            return pruned;
        }

        private static int indexForStackSlot(FrameMap frameMap, StackSlot slot) {
            assert (frameMap.offsetForStackSlot(slot) % frameMap.getTarget().wordSize == 0);
            int value = frameMap.offsetForStackSlot(slot) / frameMap.getTarget().wordSize;
            return value;
        }
    }

    public static interface LoadConstantOp
    extends MoveOp {
        public Constant getConstant();

        public static LoadConstantOp asLoadConstantOp(LIRInstruction op) {
            return (LoadConstantOp)((Object)op);
        }

        public static boolean isLoadConstantOp(LIRInstruction op) {
            return op.isLoadConstantOp();
        }

        default public boolean canRematerialize() {
            return this.getConstant() instanceof JavaConstant;
        }
    }

    public static interface ValueMoveOp
    extends MoveOp {
        public AllocatableValue getInput();

        public static ValueMoveOp asValueMoveOp(LIRInstruction op) {
            return (ValueMoveOp)((Object)op);
        }

        public static boolean isValueMoveOp(LIRInstruction op) {
            return op.isValueMoveOp();
        }
    }

    public static interface MoveOp {
        public AllocatableValue getResult();

        public static MoveOp asMoveOp(LIRInstruction op) {
            return (MoveOp)((Object)op);
        }

        public static boolean isMoveOp(LIRInstruction op) {
            return op.isMoveOp();
        }
    }

    public static interface BranchOp
    extends BlockEndOp {
    }

    public static class JumpOp
    extends LIRInstruction
    implements BlockEndOp {
        public static final LIRInstructionClass<JumpOp> TYPE = LIRInstructionClass.create(JumpOp.class);
        public static final EnumSet<LIRInstruction.OperandFlag> outgoingFlags = EnumSet.of(LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.CONST, LIRInstruction.OperandFlag.OUTGOING);
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.CONST, LIRInstruction.OperandFlag.OUTGOING})
        private Value[] outgoingValues;
        private final LabelRef destination;

        public JumpOp(LabelRef destination) {
            this(TYPE, destination);
        }

        protected JumpOp(LIRInstructionClass<? extends JumpOp> c, LabelRef destination) {
            super(c);
            this.destination = destination;
            this.outgoingValues = Value.NO_VALUES;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb) {
            if (!crb.isSuccessorEdge(this.destination)) {
                crb.asm.jmp(this.destination.label());
            }
        }

        public LabelRef destination() {
            return this.destination;
        }

        public void setPhiValues(Value[] values) {
            assert (this.outgoingValues.length == 0);
            assert (values != null);
            this.outgoingValues = values;
        }

        public int getPhiSize() {
            return this.outgoingValues.length;
        }

        public Value getOutgoingValue(int idx) {
            assert (this.checkRange(idx));
            return this.outgoingValues[idx];
        }

        public void clearOutgoingValues() {
            this.outgoingValues = Value.NO_VALUES;
        }

        private boolean checkRange(int idx) {
            return idx < this.outgoingValues.length;
        }
    }

    public static final class LabelOp
    extends LIRInstruction
    implements LabelHoldingOp {
        public static final LIRInstructionClass<LabelOp> TYPE = LIRInstructionClass.create(LabelOp.class);
        public static final EnumSet<LIRInstruction.OperandFlag> incomingFlags = EnumSet.of(LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        private Value[] incomingValues;
        private final Label label;
        private final boolean align;
        private int numbPhis;

        public LabelOp(Label label, boolean align) {
            super(TYPE);
            this.label = label;
            this.align = align;
            this.incomingValues = Value.NO_VALUES;
            this.numbPhis = 0;
        }

        public void setPhiValues(Value[] values) {
            this.setIncomingValues(values);
            this.setNumberOfPhis(values.length);
        }

        private void setNumberOfPhis(int numPhis) {
            assert (this.numbPhis == 0);
            this.numbPhis = numPhis;
        }

        public int getPhiSize() {
            return this.numbPhis;
        }

        public void setIncomingValues(Value[] values) {
            assert (this.incomingValues.length == 0);
            assert (values != null);
            this.incomingValues = values;
        }

        public int getIncomingSize() {
            return this.incomingValues.length;
        }

        public Value getIncomingValue(int idx) {
            assert (this.checkRange(idx));
            return this.incomingValues[idx];
        }

        public void clearIncomingValues() {
            this.incomingValues = Value.NO_VALUES;
        }

        public void addIncomingValues(Value[] values) {
            if (this.incomingValues.length == 0) {
                this.setIncomingValues(values);
                return;
            }
            int t = this.incomingValues.length + values.length;
            Value[] newArray = new Value[t];
            System.arraycopy(this.incomingValues, 0, newArray, 0, this.incomingValues.length);
            System.arraycopy(values, 0, newArray, this.incomingValues.length, values.length);
            this.incomingValues = newArray;
        }

        private boolean checkRange(int idx) {
            return idx < this.incomingValues.length;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb) {
            if (this.align) {
                crb.asm.align(GraalOptions.LoopHeaderAlignment.getValue(crb.getOptions()));
            }
            crb.asm.bind(this.label);
        }

        @Override
        public Label getLabel() {
            return this.label;
        }

        public boolean isPhiIn() {
            return this.getPhiSize() > 0;
        }

        public void forEachIncomingValue(InstructionValueProcedure proc) {
            for (int i = 0; i < this.incomingValues.length; ++i) {
                this.incomingValues[i] = proc.doValue(this, this.incomingValues[i], LIRInstruction.OperandMode.DEF, incomingFlags);
            }
        }
    }

    public static interface LabelHoldingOp {
        public Label getLabel();
    }

    public static interface ImplicitNullCheck {
        public boolean makeNullCheckFor(Value var1, LIRFrameState var2, int var3);
    }

    public static interface NullCheck {
        public Value getCheckedValue();

        public LIRFrameState getState();
    }

    public static interface BlockEndOp {
    }
}

