/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.java.BciBlockMapping;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.LocalLiveness;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.util.GraphUtil;

public final class FrameStateBuilder
implements IntrinsicContext.SideEffectsState {
    private static final ValueNode[] EMPTY_ARRAY = new ValueNode[0];
    private static final MonitorIdNode[] EMPTY_MONITOR_ARRAY = new MonitorIdNode[0];
    private final BytecodeParser parser;
    private final GraphBuilderTool tool;
    private final Bytecode code;
    private int stackSize;
    protected final ValueNode[] locals;
    protected final ValueNode[] stack;
    private ValueNode[] lockedObjects;
    private boolean canVerifyKind;
    private boolean rethrowException;
    private MonitorIdNode[] monitorIds;
    private final StructuredGraph graph;
    private final boolean clearNonLiveLocals;
    private FrameState outerFrameState;
    private NodeSourcePosition outerSourcePosition;
    private List<StateSplit> sideEffects;

    public FrameStateBuilder(GraphBuilderTool tool, ResolvedJavaMethod method, StructuredGraph graph) {
        this(tool, new ResolvedJavaMethodBytecode(method), graph, false);
    }

    public FrameStateBuilder(GraphBuilderTool tool, Bytecode code, StructuredGraph graph, boolean shouldRetainLocalVariables) {
        this.tool = tool;
        this.parser = tool instanceof BytecodeParser ? (BytecodeParser)tool : null;
        this.code = code;
        this.locals = FrameStateBuilder.allocateArray(code.getMaxLocals());
        this.stack = FrameStateBuilder.allocateArray(Math.max(1, code.getMaxStackSize()));
        this.lockedObjects = FrameStateBuilder.allocateArray(0);
        assert (graph != null);
        this.monitorIds = EMPTY_MONITOR_ARRAY;
        this.graph = graph;
        this.clearNonLiveLocals = !shouldRetainLocalVariables;
        this.canVerifyKind = true;
    }

    public void disableKindVerification() {
        this.canVerifyKind = false;
    }

    public void initializeFromArgumentsArray(ValueNode[] arguments) {
        int javaIndex = 0;
        int index = 0;
        if (!this.getMethod().isStatic()) {
            this.locals[javaIndex] = arguments[index];
            javaIndex = 1;
            index = 1;
        }
        Signature sig = this.getMethod().getSignature();
        int max = sig.getParameterCount(false);
        for (int i = 0; i < max; ++i) {
            JavaKind kind = sig.getParameterKind(i);
            this.locals[javaIndex] = arguments[index];
            ++javaIndex;
            if (kind.needsTwoSlots()) {
                this.locals[javaIndex] = FrameState.TWO_SLOT_MARKER;
                ++javaIndex;
            }
            ++index;
        }
    }

    public void initializeForMethodStart(Assumptions assumptions, boolean eagerResolve, GraphBuilderConfiguration.Plugins plugins) {
        int javaIndex = 0;
        int index = 0;
        ResolvedJavaMethod method = this.getMethod();
        ResolvedJavaType originalType = method.getDeclaringClass();
        if (!method.isStatic()) {
            FloatingNode receiver = null;
            StampPair receiverStamp = null;
            if (plugins != null) {
                receiverStamp = plugins.getOverridingStamp(this.tool, (JavaType)originalType, true);
            }
            if (receiverStamp == null) {
                receiverStamp = StampFactory.forDeclaredType(assumptions, (JavaType)originalType, true);
            }
            if (plugins != null) {
                ParameterPlugin plugin;
                ParameterPlugin[] parameterPluginArray = plugins.getParameterPlugins();
                int n = parameterPluginArray.length;
                for (int i = 0; i < n && (receiver = (plugin = parameterPluginArray[i]).interceptParameter(this.tool, index, receiverStamp)) == null; ++i) {
                }
            }
            if (receiver == null) {
                receiver = new ParameterNode(javaIndex, receiverStamp);
            }
            this.locals[javaIndex] = this.graph.addOrUniqueWithInputs(receiver);
            javaIndex = 1;
            index = 1;
        }
        Signature sig = method.getSignature();
        int max = sig.getParameterCount(false);
        ResolvedJavaType accessingClass = originalType;
        for (int i = 0; i < max; ++i) {
            JavaType type = sig.getParameterType(i, accessingClass);
            if (eagerResolve) {
                type = type.resolve(accessingClass);
            }
            JavaKind kind = type.getJavaKind();
            StampPair stamp = null;
            if (plugins != null) {
                stamp = plugins.getOverridingStamp(this.tool, type, false);
            }
            if (stamp == null) {
                stamp = kind.getStackKind() != kind ? StampPair.createSingle(StampFactory.forKind(JavaKind.Int)) : StampFactory.forDeclaredType(assumptions, type, false);
            }
            FloatingNode param = null;
            if (plugins != null) {
                ParameterPlugin plugin;
                ParameterPlugin[] parameterPluginArray = plugins.getParameterPlugins();
                int n = parameterPluginArray.length;
                for (int j = 0; j < n && (param = (plugin = parameterPluginArray[j]).interceptParameter(this.tool, index, stamp)) == null; ++j) {
                }
            }
            if (param == null) {
                param = new ParameterNode(index, stamp);
            }
            this.locals[javaIndex] = this.graph.addOrUniqueWithInputs(param);
            ++javaIndex;
            if (kind.needsTwoSlots()) {
                this.locals[javaIndex] = FrameState.TWO_SLOT_MARKER;
                ++javaIndex;
            }
            ++index;
        }
    }

    private FrameStateBuilder(FrameStateBuilder other) {
        this.parser = other.parser;
        this.tool = other.tool;
        this.code = other.code;
        this.stackSize = other.stackSize;
        this.locals = (ValueNode[])other.locals.clone();
        this.stack = (ValueNode[])other.stack.clone();
        this.lockedObjects = other.lockedObjects.length == 0 ? other.lockedObjects : (ValueNode[])other.lockedObjects.clone();
        this.rethrowException = other.rethrowException;
        this.canVerifyKind = other.canVerifyKind;
        assert (this.locals.length == this.code.getMaxLocals());
        assert (this.stack.length == Math.max(1, this.code.getMaxStackSize()));
        assert (other.graph != null);
        this.graph = other.graph;
        this.clearNonLiveLocals = other.clearNonLiveLocals;
        MonitorIdNode[] monitorIdNodeArray = this.monitorIds = other.monitorIds.length == 0 ? other.monitorIds : (MonitorIdNode[])other.monitorIds.clone();
        assert (this.lockedObjects.length == this.monitorIds.length);
        if (other.sideEffects != null) {
            this.sideEffects = new ArrayList<StateSplit>();
            this.sideEffects.addAll(other.sideEffects);
        }
    }

    private static ValueNode[] allocateArray(int length) {
        return length == 0 ? EMPTY_ARRAY : new ValueNode[length];
    }

    public ResolvedJavaMethod getMethod() {
        return this.code.getMethod();
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("[locals: [");
        for (i = 0; i < this.locals.length; ++i) {
            sb.append(i == 0 ? "" : ",").append(this.locals[i] == null ? "_" : (this.locals[i] == FrameState.TWO_SLOT_MARKER ? "#" : this.locals[i].toString(Verbosity.Id)));
        }
        sb.append("] stack: [");
        for (i = 0; i < this.stackSize; ++i) {
            sb.append(i == 0 ? "" : ",").append(this.stack[i] == null ? "_" : (this.stack[i] == FrameState.TWO_SLOT_MARKER ? "#" : this.stack[i].toString(Verbosity.Id)));
        }
        sb.append("] locks: [");
        for (i = 0; i < this.lockedObjects.length; ++i) {
            sb.append(i == 0 ? "" : ",").append(this.lockedObjects[i].toString(Verbosity.Id)).append(" / ").append(this.monitorIds[i].toString(Verbosity.Id));
        }
        sb.append("]");
        if (this.rethrowException) {
            sb.append(" rethrowException");
        }
        sb.append("]");
        return sb.toString();
    }

    public FrameState create(int bci, StateSplit forStateSplit) {
        if (this.parser != null && this.parser.parsingIntrinsic()) {
            NodeSourcePosition sourcePosition = this.parser.getGraph().trackNodeSourcePosition() ? this.createBytecodePosition(bci) : null;
            return this.parser.intrinsicContext.createFrameState(this.parser.getGraph(), this, forStateSplit, sourcePosition);
        }
        return this.create(bci, this.parser != null ? this.parser.getNonIntrinsicAncestor() : null, false, null, null);
    }

    public FrameState create(int bci, BytecodeParser parent, boolean duringCall, JavaKind[] pushedSlotKinds, ValueNode[] pushedValues) {
        if (this.outerFrameState == null && parent != null) {
            assert (!parent.parsingIntrinsic()) : "must already have the next non-intrinsic ancestor";
            this.outerFrameState = parent.getFrameStateBuilder().create(parent.bci(), parent.getNonIntrinsicAncestor(), true, null, null);
        }
        if (bci == -4 && parent != null) {
            return this.outerFrameState.duplicateModified(this.graph, this.outerFrameState.bci, true, false, JavaKind.Void, new JavaKind[]{JavaKind.Object}, new ValueNode[]{this.stack[0]});
        }
        if (bci == -6) {
            throw GraalError.shouldNotReachHere();
        }
        if (bci == -4) {
            assert (this.outerFrameState == null);
            this.clearLocals();
        }
        return this.graph.add(new FrameState(this.outerFrameState, this.code, bci, this.locals, this.stack, this.stackSize, pushedSlotKinds, pushedValues, this.lockedObjects, Arrays.asList(this.monitorIds), this.rethrowException, duringCall));
    }

    public NodeSourcePosition createBytecodePosition(int bci) {
        BytecodeParser parent = this.parser.getParent();
        NodeSourcePosition position = this.create(bci, parent);
        return position;
    }

    private NodeSourcePosition create(int bci, BytecodeParser parent) {
        if (this.outerSourcePosition == null && parent != null) {
            this.outerSourcePosition = parent.getFrameStateBuilder().createBytecodePosition(parent.bci());
        }
        if (bci == -4 && parent != null) {
            return FrameState.toSourcePosition(this.outerFrameState);
        }
        if (bci == -6) {
            throw GraalError.shouldNotReachHere();
        }
        if (this.parser.intrinsicContext != null && (parent == null || parent.intrinsicContext != this.parser.intrinsicContext)) {
            NodeSourcePosition original = new NodeSourcePosition(this.outerSourcePosition, this.parser.intrinsicContext.getOriginalMethod(), -1);
            return NodeSourcePosition.substitution(original, this.code.getMethod(), bci);
        }
        return new NodeSourcePosition(this.outerSourcePosition, this.code.getMethod(), bci);
    }

    public FrameStateBuilder copy() {
        return new FrameStateBuilder(this);
    }

    private String incompatibilityErrorMessage(String reason, FrameStateBuilder other) {
        return String.format("Frame states being merged are incompatible: %s%n This frame state: %s%nOther frame state: %s%nParser context: %s", reason, this, other, this.parser);
    }

    public void checkCompatibleWith(FrameStateBuilder other) {
        int i;
        assert (this.code.equals(other.code) && this.graph == other.graph && this.localsSize() == other.localsSize()) : "Can only compare frame states of the same method";
        assert (this.lockedObjects.length == this.monitorIds.length && other.lockedObjects.length == other.monitorIds.length) : "mismatch between lockedObjects and monitorIds";
        if (this.rethrowException != other.rethrowException) {
            throw new GraalError(this.incompatibilityErrorMessage("mismatch in rethrowException flag", other));
        }
        if (this.stackSize() != other.stackSize()) {
            throw new GraalError(this.incompatibilityErrorMessage("mismatch in stack sizes", other));
        }
        for (i = 0; i < this.stackSize(); ++i) {
            ValueNode x = this.stack[i];
            ValueNode y = other.stack[i];
            assert (x != null && y != null);
            if (x == y || x != FrameState.TWO_SLOT_MARKER && !x.isDeleted() && y != FrameState.TWO_SLOT_MARKER && !y.isDeleted() && x.getStackKind() == y.getStackKind()) continue;
            throw new GraalError(this.incompatibilityErrorMessage("mismatch in stack types", other));
        }
        if (this.lockedObjects.length != other.lockedObjects.length) {
            throw new PermanentBailoutException(this.incompatibilityErrorMessage("unbalanced monitors - locked objects do not match", other));
        }
        for (i = 0; i < this.lockedObjects.length; ++i) {
            if (GraphUtil.originalValue(this.lockedObjects[i], false) != GraphUtil.originalValue(other.lockedObjects[i], false)) {
                throw new PermanentBailoutException(this.incompatibilityErrorMessage("unbalanced monitors - locked objects do not match", other));
            }
            if (this.monitorIds[i] == other.monitorIds[i]) continue;
            throw new PermanentBailoutException(this.incompatibilityErrorMessage("unbalanced monitors - monitors do not match", other));
        }
    }

    public void merge(AbstractMergeNode block, FrameStateBuilder other) {
        int i;
        this.checkCompatibleWith(other);
        for (i = 0; i < this.localsSize(); ++i) {
            this.locals[i] = this.merge(this.locals[i], other.locals[i], block);
        }
        for (i = 0; i < this.stackSize(); ++i) {
            this.stack[i] = this.merge(this.stack[i], other.stack[i], block);
        }
        for (i = 0; i < this.lockedObjects.length; ++i) {
            this.lockedObjects[i] = this.merge(this.lockedObjects[i], other.lockedObjects[i], block);
            assert (this.monitorIds[i] == other.monitorIds[i]);
        }
        if (this.sideEffects == null) {
            this.sideEffects = other.sideEffects;
        } else if (other.sideEffects != null) {
            this.sideEffects.addAll(other.sideEffects);
        }
    }

    private ValueNode merge(ValueNode currentValue, ValueNode otherValue, AbstractMergeNode block) {
        if (currentValue == null || currentValue.isDeleted()) {
            return null;
        }
        if (block.isPhiAtMerge(currentValue)) {
            if (otherValue == null || otherValue == FrameState.TWO_SLOT_MARKER || otherValue.isDeleted() || currentValue.getStackKind() != otherValue.getStackKind()) {
                ((PhiNode)currentValue).addInput(ConstantNode.defaultForKind(currentValue.getStackKind(), this.graph));
            } else {
                ((PhiNode)currentValue).addInput(otherValue);
            }
            return currentValue;
        }
        if (currentValue != otherValue) {
            if (currentValue == FrameState.TWO_SLOT_MARKER || otherValue == FrameState.TWO_SLOT_MARKER) {
                return null;
            }
            if (otherValue == null || otherValue.isDeleted() || currentValue.getStackKind() != otherValue.getStackKind()) {
                return null;
            }
            assert (!(block instanceof LoopBeginNode)) : String.format("Phi functions for loop headers are create eagerly for changed locals and all stack slots: %s != %s", currentValue, otherValue);
            return this.createValuePhi(currentValue, otherValue, block);
        }
        return currentValue;
    }

    private ValuePhiNode createValuePhi(ValueNode currentValue, ValueNode otherValue, AbstractMergeNode block) {
        ValuePhiNode phi = this.graph.addWithoutUnique(new ValuePhiNode(currentValue.stamp(NodeView.DEFAULT).unrestricted(), block));
        for (int i = 0; i < block.phiPredecessorCount(); ++i) {
            phi.addInput(currentValue);
        }
        phi.addInput(otherValue);
        assert (phi.valueCount() == block.phiPredecessorCount() + 1);
        return phi;
    }

    public void inferPhiStamps(AbstractMergeNode block) {
        int i;
        for (i = 0; i < this.localsSize(); ++i) {
            FrameStateBuilder.inferPhiStamp(block, this.locals[i]);
        }
        for (i = 0; i < this.stackSize(); ++i) {
            FrameStateBuilder.inferPhiStamp(block, this.stack[i]);
        }
        for (i = 0; i < this.lockedObjects.length; ++i) {
            FrameStateBuilder.inferPhiStamp(block, this.lockedObjects[i]);
        }
    }

    private static void inferPhiStamp(AbstractMergeNode block, ValueNode node) {
        if (block.isPhiAtMerge(node)) {
            node.inferStamp();
        }
    }

    public void insertLoopPhis(LocalLiveness liveness, int loopId, LoopBeginNode loopBegin, boolean forcePhis, boolean stampFromValueForForcedPhis) {
        int i;
        for (i = 0; i < this.localsSize(); ++i) {
            boolean changedInLoop = liveness.localIsChangedInLoop(loopId, i);
            if (!forcePhis && !changedInLoop) continue;
            this.locals[i] = this.createLoopPhi(loopBegin, this.locals[i], stampFromValueForForcedPhis && !changedInLoop);
        }
        for (i = 0; i < this.stackSize(); ++i) {
            this.stack[i] = this.createLoopPhi(loopBegin, this.stack[i], false);
        }
        for (i = 0; i < this.lockedObjects.length; ++i) {
            this.lockedObjects[i] = this.createLoopPhi(loopBegin, this.lockedObjects[i], false);
        }
    }

    public void insertLoopProxies(LoopExitNode loopExit, FrameStateBuilder loopEntryState) {
        ValueNode value;
        int i;
        DebugContext debug = this.graph.getDebug();
        for (i = 0; i < this.localsSize(); ++i) {
            value = this.locals[i];
            if (value == null || value == FrameState.TWO_SLOT_MARKER || loopEntryState.contains(value) && !loopExit.loopBegin().isPhiAtMerge(value)) continue;
            debug.log(" inserting proxy for %s", value);
            this.locals[i] = ProxyNode.forValue(value, loopExit);
        }
        for (i = 0; i < this.stackSize(); ++i) {
            value = this.stack[i];
            if (value == null || value == FrameState.TWO_SLOT_MARKER || loopEntryState.contains(value) && !loopExit.loopBegin().isPhiAtMerge(value)) continue;
            debug.log(" inserting proxy for %s", value);
            this.stack[i] = ProxyNode.forValue(value, loopExit);
        }
        for (i = 0; i < this.lockedObjects.length; ++i) {
            value = this.lockedObjects[i];
            if (value == null || loopEntryState.contains(value) && !loopExit.loopBegin().isPhiAtMerge(value)) continue;
            debug.log(" inserting proxy for %s", value);
            this.lockedObjects[i] = ProxyNode.forValue(value, loopExit);
        }
    }

    public void insertProxies(Function<ValueNode, ValueNode> proxyFunction) {
        ValueNode value;
        int i;
        DebugContext debug = this.graph.getDebug();
        for (i = 0; i < this.localsSize(); ++i) {
            value = this.locals[i];
            if (value == null || value == FrameState.TWO_SLOT_MARKER) continue;
            debug.log(" inserting proxy for %s", value);
            this.locals[i] = proxyFunction.apply(value);
        }
        for (i = 0; i < this.stackSize(); ++i) {
            value = this.stack[i];
            if (value == null || value == FrameState.TWO_SLOT_MARKER) continue;
            debug.log(" inserting proxy for %s", value);
            this.stack[i] = proxyFunction.apply(value);
        }
        for (i = 0; i < this.lockedObjects.length; ++i) {
            value = this.lockedObjects[i];
            if (value == null) continue;
            debug.log(" inserting proxy for %s", value);
            this.lockedObjects[i] = proxyFunction.apply(value);
        }
    }

    private ValueNode createLoopPhi(AbstractMergeNode block, ValueNode value, boolean stampFromValue) {
        if (value == null || value == FrameState.TWO_SLOT_MARKER) {
            return value;
        }
        assert (!block.isPhiAtMerge(value)) : "phi function for this block already created";
        ValuePhiNode phi = this.graph.addWithoutUnique(new ValuePhiNode(stampFromValue ? value.stamp(NodeView.DEFAULT) : value.stamp(NodeView.DEFAULT).unrestricted(), block));
        phi.addInput(value);
        return phi;
    }

    public void pushLock(ValueNode object, MonitorIdNode monitorId) {
        assert (object.isAlive() && object.getStackKind() == JavaKind.Object) : "unexpected value: " + object;
        this.lockedObjects = Arrays.copyOf(this.lockedObjects, this.lockedObjects.length + 1);
        this.monitorIds = Arrays.copyOf(this.monitorIds, this.monitorIds.length + 1);
        this.lockedObjects[this.lockedObjects.length - 1] = object;
        this.monitorIds[this.monitorIds.length - 1] = monitorId;
        assert (this.lockedObjects.length == this.monitorIds.length);
    }

    public ValueNode popLock() {
        ValueNode valueNode;
        try {
            valueNode = this.lockedObjects[this.lockedObjects.length - 1];
        }
        catch (Throwable throwable) {
            this.lockedObjects = this.lockedObjects.length == 1 ? EMPTY_ARRAY : Arrays.copyOf(this.lockedObjects, this.lockedObjects.length - 1);
            MonitorIdNode[] monitorIdNodeArray = this.monitorIds = this.monitorIds.length == 1 ? EMPTY_MONITOR_ARRAY : Arrays.copyOf(this.monitorIds, this.monitorIds.length - 1);
            assert (this.lockedObjects.length == this.monitorIds.length);
            throw throwable;
        }
        this.lockedObjects = this.lockedObjects.length == 1 ? EMPTY_ARRAY : Arrays.copyOf(this.lockedObjects, this.lockedObjects.length - 1);
        MonitorIdNode[] monitorIdNodeArray = this.monitorIds = this.monitorIds.length == 1 ? EMPTY_MONITOR_ARRAY : Arrays.copyOf(this.monitorIds, this.monitorIds.length - 1);
        assert (this.lockedObjects.length == this.monitorIds.length);
        return valueNode;
    }

    public MonitorIdNode peekMonitorId() {
        return this.monitorIds[this.monitorIds.length - 1];
    }

    public int lockDepth(boolean includeParents) {
        int depth = this.lockedObjects.length;
        assert (depth == this.monitorIds.length);
        if (includeParents && this.parser.getParent() != null) {
            depth += this.parser.getParent().frameState.lockDepth(true);
        }
        return depth;
    }

    public boolean contains(ValueNode value) {
        int i;
        for (i = 0; i < this.localsSize(); ++i) {
            if (this.locals[i] != value) continue;
            return true;
        }
        for (i = 0; i < this.stackSize(); ++i) {
            if (this.stack[i] != value) continue;
            return true;
        }
        assert (this.lockedObjects.length == this.monitorIds.length);
        for (i = 0; i < this.lockedObjects.length; ++i) {
            if (this.lockedObjects[i] != value && this.monitorIds[i] != value) continue;
            return true;
        }
        return false;
    }

    public void clearNonLiveLocals(BciBlockMapping.BciBlock block, LocalLiveness liveness, boolean liveIn) {
        boolean isOSREntryBlock;
        boolean bl = isOSREntryBlock = this.graph.isOSR() && this.getMethod().equals(this.graph.method()) && this.graph.getEntryBCI() == block.startBci;
        if (!this.clearNonLiveLocals && !isOSREntryBlock) {
            return;
        }
        if (liveIn) {
            for (int i = 0; i < this.locals.length; ++i) {
                if (liveness.localIsLiveIn(block, i)) continue;
                if (this.locals[i] == FrameState.TWO_SLOT_MARKER) {
                    this.locals[i - 1] = null;
                }
                this.locals[i] = null;
            }
        } else {
            for (int i = 0; i < this.locals.length; ++i) {
                if (liveness.localIsLiveOut(block, i)) continue;
                if (this.locals[i] == FrameState.TWO_SLOT_MARKER) {
                    this.locals[i - 1] = null;
                }
                this.locals[i] = null;
            }
        }
    }

    public void clearLocals() {
        for (int i = 0; i < this.locals.length; ++i) {
            this.locals[i] = null;
        }
    }

    public boolean rethrowException() {
        return this.rethrowException;
    }

    public void setRethrowException(boolean b) {
        this.rethrowException = b;
    }

    public int localsSize() {
        return this.locals.length;
    }

    public int stackSize() {
        return this.stackSize;
    }

    private boolean verifyKind(JavaKind slotKind, ValueNode x) {
        assert (x != null);
        assert (x != FrameState.TWO_SLOT_MARKER);
        assert (slotKind.getSlotCount() > 0);
        if (this.canVerifyKind) assert (x.getStackKind() == slotKind.getStackKind());
        return true;
    }

    public ValueNode loadLocal(int i, JavaKind slotKind) {
        ValueNode x = this.locals[i];
        assert (this.verifyKind(slotKind, x));
        assert (!slotKind.needsTwoSlots() ? i == this.locals.length - 1 || this.locals[i + 1] != FrameState.TWO_SLOT_MARKER : this.locals[i + 1] == FrameState.TWO_SLOT_MARKER);
        return x;
    }

    public void storeLocal(int i, JavaKind slotKind, ValueNode x) {
        assert (this.verifyKind(slotKind, x));
        if (this.locals[i] == FrameState.TWO_SLOT_MARKER) {
            this.locals[i - 1] = null;
        }
        this.locals[i] = x;
        if (slotKind.needsTwoSlots()) {
            if (i < this.locals.length - 2 && this.locals[i + 2] == FrameState.TWO_SLOT_MARKER) {
                this.locals[i + 2] = null;
            }
            this.locals[i + 1] = FrameState.TWO_SLOT_MARKER;
        } else if (i < this.locals.length - 1 && this.locals[i + 1] == FrameState.TWO_SLOT_MARKER) {
            this.locals[i + 1] = null;
        }
    }

    public void push(JavaKind slotKind, ValueNode x) {
        assert (this.verifyKind(slotKind, x));
        this.xpush(x);
        if (slotKind.needsTwoSlots()) {
            this.xpush(FrameState.TWO_SLOT_MARKER);
        }
    }

    public void pushReturn(JavaKind slotKind, ValueNode x) {
        if (slotKind != JavaKind.Void) {
            this.push(slotKind, x);
        }
    }

    public ValueNode pop(JavaKind slotKind) {
        if (slotKind.needsTwoSlots()) {
            ValueNode s = this.xpop();
            assert (s == FrameState.TWO_SLOT_MARKER) : s;
        }
        ValueNode x = this.xpop();
        assert (this.verifyKind(slotKind, x));
        return x;
    }

    private void xpush(ValueNode x) {
        assert (x != null);
        this.stack[this.stackSize++] = x;
    }

    private ValueNode xpop() {
        ValueNode result = this.stack[--this.stackSize];
        assert (result != null);
        return result;
    }

    private ValueNode xpeek() {
        ValueNode result = this.stack[this.stackSize - 1];
        assert (result != null);
        return result;
    }

    public ValueNode peekObject() {
        ValueNode x = this.xpeek();
        assert (this.verifyKind(JavaKind.Object, x));
        return x;
    }

    public ValueNode[] popArguments(int argSize) {
        ValueNode[] result = FrameStateBuilder.allocateArray(argSize);
        for (int i = argSize - 1; i >= 0; --i) {
            ValueNode x = this.xpop();
            if (x == FrameState.TWO_SLOT_MARKER) {
                x = this.xpop();
            }
            assert (x != null && x != FrameState.TWO_SLOT_MARKER) : x;
            result[i] = x;
        }
        return result;
    }

    public void clearStack() {
        this.stackSize = 0;
    }

    public void stackOp(int opcode) {
        switch (opcode) {
            case 87: {
                ValueNode w1 = this.xpop();
                assert (w1 != FrameState.TWO_SLOT_MARKER);
                break;
            }
            case 88: {
                this.xpop();
                ValueNode w2 = this.xpop();
                assert (w2 != FrameState.TWO_SLOT_MARKER);
                break;
            }
            case 89: {
                ValueNode w1 = this.xpeek();
                assert (w1 != FrameState.TWO_SLOT_MARKER);
                this.xpush(w1);
                break;
            }
            case 90: {
                ValueNode w1 = this.xpop();
                ValueNode w2 = this.xpop();
                assert (w1 != FrameState.TWO_SLOT_MARKER);
                this.xpush(w1);
                this.xpush(w2);
                this.xpush(w1);
                break;
            }
            case 91: {
                ValueNode w1 = this.xpop();
                ValueNode w2 = this.xpop();
                ValueNode w3 = this.xpop();
                assert (w1 != FrameState.TWO_SLOT_MARKER);
                this.xpush(w1);
                this.xpush(w3);
                this.xpush(w2);
                this.xpush(w1);
                break;
            }
            case 92: {
                ValueNode w1 = this.xpop();
                ValueNode w2 = this.xpop();
                this.xpush(w2);
                this.xpush(w1);
                this.xpush(w2);
                this.xpush(w1);
                break;
            }
            case 93: {
                ValueNode w1 = this.xpop();
                ValueNode w2 = this.xpop();
                ValueNode w3 = this.xpop();
                this.xpush(w2);
                this.xpush(w1);
                this.xpush(w3);
                this.xpush(w2);
                this.xpush(w1);
                break;
            }
            case 94: {
                ValueNode w1 = this.xpop();
                ValueNode w2 = this.xpop();
                ValueNode w3 = this.xpop();
                ValueNode w4 = this.xpop();
                this.xpush(w2);
                this.xpush(w1);
                this.xpush(w4);
                this.xpush(w3);
                this.xpush(w2);
                this.xpush(w1);
                break;
            }
            case 95: {
                ValueNode w1 = this.xpop();
                ValueNode w2 = this.xpop();
                assert (w1 != FrameState.TWO_SLOT_MARKER);
                assert (w2 != FrameState.TWO_SLOT_MARKER);
                this.xpush(w1);
                this.xpush(w2);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }

    public int hashCode() {
        int result = FrameStateBuilder.hashCode(this.locals, this.locals.length);
        result *= 13;
        return result += FrameStateBuilder.hashCode(this.stack, this.stackSize);
    }

    private static int hashCode(Object[] a, int length) {
        int result = 1;
        for (int i = 0; i < length; ++i) {
            Object element = a[i];
            result = 31 * result + (element == null ? 0 : System.identityHashCode(element));
        }
        return result;
    }

    private static boolean equals(ValueNode[] a, ValueNode[] b, int length) {
        for (int i = 0; i < length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object otherObject) {
        if (otherObject instanceof FrameStateBuilder) {
            FrameStateBuilder other = (FrameStateBuilder)otherObject;
            if (!other.code.equals(this.code)) {
                return false;
            }
            if (other.stackSize != this.stackSize) {
                return false;
            }
            if (other.parser != this.parser) {
                return false;
            }
            if (other.tool != this.tool) {
                return false;
            }
            if (other.rethrowException != this.rethrowException) {
                return false;
            }
            if (other.graph != this.graph) {
                return false;
            }
            if (other.locals.length != this.locals.length) {
                return false;
            }
            return FrameStateBuilder.equals(other.locals, this.locals, this.locals.length) && FrameStateBuilder.equals(other.stack, this.stack, this.stackSize) && FrameStateBuilder.equals(other.lockedObjects, this.lockedObjects, this.lockedObjects.length) && FrameStateBuilder.equals(other.monitorIds, this.monitorIds, this.monitorIds.length);
        }
        return false;
    }

    @Override
    public boolean isAfterSideEffect() {
        return this.sideEffects != null;
    }

    @Override
    public Iterable<StateSplit> sideEffects() {
        return this.sideEffects;
    }

    @Override
    public void addSideEffect(StateSplit sideEffect) {
        assert (sideEffect != null);
        assert (sideEffect.hasSideEffect());
        if (this.sideEffects == null) {
            this.sideEffects = new ArrayList<StateSplit>(4);
        }
        this.sideEffects.add(sideEffect);
    }

    public void replaceValue(ValueNode oldValue, ValueNode newValue) {
        int i;
        for (i = 0; i < this.locals.length; ++i) {
            if (this.locals[i] != oldValue) continue;
            this.locals[i] = newValue;
        }
        for (i = 0; i < this.stack.length; ++i) {
            if (this.stack[i] != oldValue) continue;
            this.stack[i] = newValue;
        }
    }

    public FrameState createInitialIntrinsicFrameState(ResolvedJavaMethod original) {
        ValueNode[] newLocals;
        if (original.getMaxLocals() == this.localsSize() || original.isNative()) {
            newLocals = new ValueNode[original.getMaxLocals()];
            for (int i = 0; i < newLocals.length; ++i) {
                ValueNode node = this.locals[i];
                if (node == FrameState.TWO_SLOT_MARKER) {
                    node = null;
                }
                newLocals[i] = node;
            }
        } else {
            newLocals = new ValueNode[original.getMaxLocals()];
            int parameterCount = original.getSignature().getParameterCount(!original.isStatic());
            for (int i = 0; i < parameterCount; ++i) {
                ValueNode param = this.locals[i];
                if (param == FrameState.TWO_SLOT_MARKER) {
                    param = null;
                }
                newLocals[i] = param;
                assert (param == null || param instanceof ParameterNode || param.isConstant());
            }
        }
        assert (this.stackSize == 0);
        ValueNode[] newStack = new ValueNode[]{};
        ValueNode[] locks = new ValueNode[]{};
        assert (this.monitorIds.length == 0);
        FrameState stateAfterStart = this.graph.add(new FrameState(null, new ResolvedJavaMethodBytecode(original), 0, newLocals, newStack, this.stackSize, null, null, locks, Collections.emptyList(), false, false));
        return stateAfterStart;
    }
}

