/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.sparc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARC;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotMarkId;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.sparc.SPARCCall;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;
import org.graalvm.compiler.nodes.CallTargetNode;

@Opcode(value="CALL_DIRECT")
final class SPARCHotspotDirectVirtualCallOp
extends SPARCCall.DirectCallOp {
    public static final LIRInstructionClass<SPARCHotspotDirectVirtualCallOp> TYPE = LIRInstructionClass.create(SPARCHotspotDirectVirtualCallOp.class);
    public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(8);
    private final CallTargetNode.InvokeKind invokeKind;
    private final GraalHotSpotVMConfig config;

    SPARCHotspotDirectVirtualCallOp(ResolvedJavaMethod target, Value result, Value[] parameters, Value[] temps, LIRFrameState state, CallTargetNode.InvokeKind invokeKind, GraalHotSpotVMConfig config) {
        super((LIRInstructionClass<? extends SPARCCall.DirectCallOp>)TYPE, SIZE, target, result, parameters, temps, state);
        this.invokeKind = invokeKind;
        this.config = config;
        assert (invokeKind.isIndirect());
    }

    @Override
    public void emitCallPrefixCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        crb.recordMark(this.invokeKind == CallTargetNode.InvokeKind.Virtual ? HotSpotMarkId.INVOKEVIRTUAL : HotSpotMarkId.INVOKEINTERFACE);
        Register scratchRegister = SPARC.g5;
        masm.setx(this.config.nonOopBits, scratchRegister, true);
        if (this.config.supportsMethodHandleDeoptimizationEntry() && this.config.isMethodHandleCall((HotSpotResolvedJavaMethod)this.callTarget)) {
            crb.setNeedsMHDeoptHandler();
            masm.mov(SPARC.sp, SPARC.l7);
        }
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        try (CompilationResultBuilder.CallContext callContext = crb.openCallContext(this.invokeKind.isDirect());){
            super.emitCode(crb, masm);
        }
    }
}

