/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.sparc;

import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.hotspot.HotSpotCompressedNullConstant;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import jdk.vm.ci.sparc.SPARC;
import jdk.vm.ci.sparc.SPARCKind;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.sparc.SPARCArithmeticLIRGenerator;
import org.graalvm.compiler.core.sparc.SPARCLIRGenerator;
import org.graalvm.compiler.core.sparc.SPARCLIRKindTool;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotDebugInfoBuilder;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerationResult;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.HotSpotLockStack;
import org.graalvm.compiler.hotspot.debug.BenchmarkCounters;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.hotspot.sparc.SPARCDeoptimizeOp;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotCRuntimeCallEpilogueOp;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotCRuntimeCallPrologueOp;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotCounterOp;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotDeoptimizeCallerOp;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotDeoptimizeWithExceptionCallerOp;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotMove;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotMoveFactory;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotReturnOp;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotSafepointOp;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotStrategySwitchOp;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotUnwindOp;
import org.graalvm.compiler.hotspot.stubs.Stub;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.SwitchStrategy;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.sparc.SPARCAddressValue;
import org.graalvm.compiler.lir.sparc.SPARCControlFlow;
import org.graalvm.compiler.lir.sparc.SPARCFrameMapBuilder;
import org.graalvm.compiler.lir.sparc.SPARCImmediateAddressValue;
import org.graalvm.compiler.lir.sparc.SPARCMove;
import org.graalvm.compiler.lir.sparc.SPARCPrefetchOp;
import org.graalvm.compiler.lir.sparc.SPARCSaveRegistersOp;

public class SPARCHotSpotLIRGenerator
extends SPARCLIRGenerator
implements HotSpotLIRGenerator {
    final GraalHotSpotVMConfig config;
    private HotSpotDebugInfoBuilder debugInfoBuilder;
    private StackSlot deoptimizationRescueSlot;
    private AllocatableValue safepointAddressValue;

    public SPARCHotSpotLIRGenerator(HotSpotProviders providers, GraalHotSpotVMConfig config, LIRGenerationResult lirGenRes) {
        this(providers, config, lirGenRes, new SPARCLIRGenerator.ConstantTableBaseProvider());
    }

    private SPARCHotSpotLIRGenerator(HotSpotProviders providers, GraalHotSpotVMConfig config, LIRGenerationResult lirGenRes, SPARCLIRGenerator.ConstantTableBaseProvider constantTableBaseProvider) {
        this(new SPARCLIRKindTool(), new SPARCArithmeticLIRGenerator(), new SPARCHotSpotMoveFactory(constantTableBaseProvider), providers, config, lirGenRes, constantTableBaseProvider);
    }

    public SPARCHotSpotLIRGenerator(LIRKindTool lirKindTool, SPARCArithmeticLIRGenerator arithmeticLIRGen, LIRGeneratorTool.MoveFactory moveFactory, HotSpotProviders providers, GraalHotSpotVMConfig config, LIRGenerationResult lirGenRes, SPARCLIRGenerator.ConstantTableBaseProvider constantTableBaseProvider) {
        super(lirKindTool, arithmeticLIRGen, moveFactory, providers, lirGenRes, constantTableBaseProvider);
        assert (config.basicLockSize == 8);
        this.config = config;
    }

    @Override
    public HotSpotProviders getProviders() {
        return (HotSpotProviders)super.getProviders();
    }

    @Override
    public VirtualStackSlot getLockSlot(int lockDepth) {
        return this.getLockStack().makeLockSlot(lockDepth);
    }

    private HotSpotLockStack getLockStack() {
        assert (this.debugInfoBuilder != null && this.debugInfoBuilder.lockStack() != null);
        return this.debugInfoBuilder.lockStack();
    }

    @Override
    public boolean needOnlyOopMaps() {
        return this.getStub() != null;
    }

    public Stub getStub() {
        return this.getResult().getStub();
    }

    @Override
    public HotSpotLIRGenerationResult getResult() {
        return (HotSpotLIRGenerationResult)super.getResult();
    }

    @Override
    public void beforeRegisterAllocation() {
        super.beforeRegisterAllocation();
        boolean hasDebugInfo = this.getResult().getLIR().hasDebugInfo();
        if (hasDebugInfo) {
            this.getResult().setDeoptimizationRescueSlot(((SPARCFrameMapBuilder)this.getResult().getFrameMapBuilder()).allocateDeoptimizationRescueSlot());
        }
        this.getResult().setMaxInterpreterFrameSize(this.debugInfoBuilder.maxInterpreterFrameSize());
    }

    @Override
    public Variable emitForeignCall(ForeignCallLinkage linkage, LIRFrameState state, Value ... args) {
        Variable result;
        HotSpotForeignCallLinkage hotspotLinkage = (HotSpotForeignCallLinkage)linkage;
        LIRFrameState debugInfo = null;
        if (hotspotLinkage.needsDebugInfo()) {
            debugInfo = state;
            assert (debugInfo != null || this.getStub() != null);
        }
        if (linkage.destroysRegisters() || hotspotLinkage.needsJavaFrameAnchor()) {
            HotSpotRegistersProvider registers = this.getProviders().getRegisters();
            Register thread = registers.getThreadRegister();
            Variable threadTemp = this.newVariable(LIRKind.value((PlatformKind)SPARCKind.XWORD));
            Register stackPointer = registers.getStackPointerRegister();
            Variable spScratch = this.newVariable(LIRKind.value(this.target().arch.getWordKind()));
            this.append(new SPARCHotSpotCRuntimeCallPrologueOp(this.config.threadLastJavaSpOffset(), thread, stackPointer, (Value)threadTemp, spScratch));
            result = super.emitForeignCall(hotspotLinkage, debugInfo, args);
            this.append(new SPARCHotSpotCRuntimeCallEpilogueOp(this.config.threadLastJavaSpOffset(), this.config.threadLastJavaPcOffset(), this.config.threadJavaFrameAnchorFlagsOffset(), thread, (Value)threadTemp));
        } else {
            result = super.emitForeignCall(hotspotLinkage, debugInfo, args);
        }
        return result;
    }

    @Override
    public void emitReturn(JavaKind javaKind, Value input) {
        AllocatableValue operand = Value.ILLEGAL;
        if (input != null) {
            operand = this.resultOperandFor(javaKind, input.getValueKind());
            this.emitMove(operand, input);
        }
        Register thread = this.getProviders().getRegisters().getThreadRegister();
        this.append(new SPARCHotSpotReturnOp((Value)operand, this.getStub() != null, this.config, thread, (Value)this.getSafepointAddressValue(), this.getResult().requiresReservedStackAccessCheck()));
    }

    @Override
    public void emitTailcall(Value[] args, Value address) {
        throw GraalError.unimplemented();
    }

    @Override
    public void emitUnwind(Value exception) {
        ForeignCallLinkage linkage = this.getForeignCalls().lookupForeignCall(HotSpotBackend.UNWIND_EXCEPTION_TO_CALLER);
        CallingConvention linkageCc = linkage.getOutgoingCallingConvention();
        assert (linkageCc.getArgumentCount() == 2);
        RegisterValue exceptionParameter = (RegisterValue)linkageCc.getArgument(0);
        this.emitMove((AllocatableValue)exceptionParameter, exception);
        this.append(new SPARCHotSpotUnwindOp(exceptionParameter));
    }

    private void moveDeoptValuesToThread(Value actionAndReason, Value speculation) {
        this.moveValueToThread(actionAndReason, this.config.pendingDeoptimizationOffset);
        this.moveValueToThread(speculation, this.config.pendingFailedSpeculationOffset);
    }

    private void moveValueToThread(Value v, int offset) {
        LIRKind wordKind = LIRKind.value(this.target().arch.getWordKind());
        RegisterValue thread = this.getProviders().getRegisters().getThreadRegister().asValue((ValueKind)wordKind);
        SPARCImmediateAddressValue pendingDeoptAddress = new SPARCImmediateAddressValue(wordKind, (AllocatableValue)thread, offset);
        this.append(new SPARCMove.StoreOp(v.getPlatformKind(), pendingDeoptAddress, this.load(v), null));
    }

    @Override
    public void emitDeoptimize(Value actionAndReason, Value speculation, LIRFrameState state) {
        this.moveDeoptValuesToThread(actionAndReason, speculation);
        this.append(new SPARCDeoptimizeOp(state, this.target().arch.getWordKind()));
    }

    @Override
    public void emitDeoptimizeCaller(DeoptimizationAction action, DeoptimizationReason reason) {
        Value actionAndReason = this.emitJavaConstant(this.getMetaAccess().encodeDeoptActionAndReason(action, reason, 0));
        Value speculation = this.emitJavaConstant(this.getMetaAccess().encodeSpeculation(SpeculationLog.NO_SPECULATION));
        this.moveDeoptValuesToThread(actionAndReason, speculation);
        this.append(new SPARCHotSpotDeoptimizeCallerOp());
    }

    @Override
    public void emitDeoptimizeWithExceptionInCaller(Value exception) {
        Register thread = this.getProviders().getRegisters().getThreadRegister();
        this.append(new SPARCHotSpotDeoptimizeWithExceptionCallerOp(this.config, exception, thread));
    }

    @Override
    public Variable emitLogicCompareAndSwap(LIRKind accessKind, Value address, Value expectedValue, Value newValue, Value trueValue, Value falseValue, boolean useBarriers) {
        ValueKind kind = newValue.getValueKind();
        assert (kind.equals(expectedValue.getValueKind()));
        SPARCKind memKind = (SPARCKind)kind.getPlatformKind();
        Variable result = this.newVariable(newValue.getValueKind());
        this.append(new SPARCMove.CompareAndSwapOp(result, this.asAllocatable(address), this.asAllocatable(expectedValue), this.asAllocatable(newValue)));
        return this.emitConditionalMove((PlatformKind)memKind, expectedValue, (Value)result, Condition.EQ, true, trueValue, falseValue);
    }

    public Variable emitValueCompareAndSwap(LIRKind accessKind, Value address, Value expectedValue, Value newValue, boolean useBarriers) {
        ValueKind kind = newValue.getValueKind();
        assert (kind.equals(expectedValue.getValueKind()));
        Variable result = this.newVariable(newValue.getValueKind());
        this.append(new SPARCMove.CompareAndSwapOp(result, this.asAllocatable(address), this.asAllocatable(expectedValue), this.asAllocatable(newValue)));
        return result;
    }

    @Override
    public void emitPrefetchAllocate(Value address) {
        SPARCAddressValue addr = this.asAddressValue(address);
        this.append(new SPARCPrefetchOp(addr, SPARCAssembler.Fcn.SeveralWritesAndPossiblyReads));
    }

    public StackSlot getDeoptimizationRescueSlot() {
        return this.deoptimizationRescueSlot;
    }

    @Override
    public void emitCompareBranch(PlatformKind cmpKind, Value x, Value y, Condition cond, boolean unorderedIsTrue, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
        Object localX = x;
        Object localY = y;
        if (localX instanceof HotSpotObjectConstant) {
            localX = this.load((Value)localX);
        }
        if (localY instanceof HotSpotObjectConstant) {
            localY = this.load((Value)localY);
        }
        super.emitCompareBranch(cmpKind, (Value)localX, (Value)localY, cond, unorderedIsTrue, trueDestination, falseDestination, trueDestinationProbability);
    }

    @Override
    protected boolean emitCompare(SPARCKind cmpKind, Value a, Value b) {
        Constant c;
        Object localA = a;
        Object localB = b;
        if (LIRValueUtil.isConstantValue(a)) {
            c = LIRValueUtil.asConstant(a);
            if (HotSpotCompressedNullConstant.COMPRESSED_NULL.equals(c)) {
                localA = SPARC.g0.asValue((ValueKind)LIRKind.value((PlatformKind)SPARCKind.WORD));
            } else if (c instanceof HotSpotObjectConstant) {
                localA = this.load((Value)localA);
            }
        }
        if (LIRValueUtil.isConstantValue(b)) {
            c = LIRValueUtil.asConstant(b);
            if (HotSpotCompressedNullConstant.COMPRESSED_NULL.equals(c)) {
                localB = SPARC.g0.asValue((ValueKind)LIRKind.value((PlatformKind)SPARCKind.WORD));
            } else if (c instanceof HotSpotObjectConstant) {
                localB = this.load((Value)localB);
            }
        }
        return super.emitCompare(cmpKind, (Value)localA, (Value)localB);
    }

    @Override
    public Value emitCompress(Value pointer, CompressEncoding encoding, boolean nonNull) {
        LIRKind inputKind = (LIRKind)pointer.getValueKind(LIRKind.class);
        assert (inputKind.getPlatformKind() == SPARCKind.XWORD) : inputKind;
        if (inputKind.isReference(0)) {
            Variable result = this.newVariable(LIRKind.compressedReference((PlatformKind)SPARCKind.WORD));
            this.append(new SPARCHotSpotMove.CompressPointer(result, this.asAllocatable(pointer), (AllocatableValue)this.getProviders().getRegisters().getHeapBaseRegister().asValue(), encoding, nonNull));
            return result;
        }
        Variable result = this.newVariable(LIRKind.value((PlatformKind)SPARCKind.WORD));
        AllocatableValue base = Value.ILLEGAL;
        if (encoding.hasBase()) {
            base = this.emitLoadConstant(LIRKind.value((PlatformKind)SPARCKind.XWORD), (Constant)JavaConstant.forLong((long)encoding.getBase()));
        }
        this.append(new SPARCHotSpotMove.CompressPointer(result, this.asAllocatable(pointer), base, encoding, nonNull));
        return result;
    }

    @Override
    public Value emitUncompress(Value pointer, CompressEncoding encoding, boolean nonNull) {
        LIRKind inputKind = (LIRKind)pointer.getValueKind(LIRKind.class);
        assert (inputKind.getPlatformKind() == SPARCKind.WORD);
        if (inputKind.isReference(0)) {
            Variable result = this.newVariable(LIRKind.reference((PlatformKind)SPARCKind.XWORD));
            this.append(new SPARCHotSpotMove.UncompressPointer(result, this.asAllocatable(pointer), (AllocatableValue)this.getProviders().getRegisters().getHeapBaseRegister().asValue(), encoding, nonNull));
            return result;
        }
        Variable result = this.newVariable(LIRKind.value((PlatformKind)SPARCKind.XWORD));
        AllocatableValue base = Value.ILLEGAL;
        if (encoding.hasBase()) {
            base = this.emitLoadConstant(LIRKind.value((PlatformKind)SPARCKind.XWORD), (Constant)JavaConstant.forLong((long)encoding.getBase()));
        }
        this.append(new SPARCHotSpotMove.UncompressPointer(result, this.asAllocatable(pointer), base, encoding, nonNull));
        return result;
    }

    protected SPARCSaveRegistersOp emitSaveRegisters(Register[] savedRegisters, AllocatableValue[] savedRegisterLocations) {
        SPARCSaveRegistersOp save = new SPARCSaveRegistersOp(savedRegisters, savedRegisterLocations);
        this.append(save);
        return save;
    }

    @Override
    public void emitNullCheck(Value address, LIRFrameState state) {
        PlatformKind kind = address.getPlatformKind();
        if (kind == SPARCKind.WORD) {
            CompressEncoding encoding = this.config.getOopEncoding();
            Value uncompressed = this.emitUncompress(address, encoding, false);
            this.append(new SPARCMove.NullCheckOp(this.asAddressValue(uncompressed), state));
        } else {
            super.emitNullCheck(address, state);
        }
    }

    @Override
    public LIRInstruction createBenchmarkCounter(String name, String group, Value increment) {
        if (BenchmarkCounters.enabled) {
            return new SPARCHotSpotCounterOp(name, group, increment, this.getProviders().getRegisters(), this.config);
        }
        throw GraalError.shouldNotReachHere("BenchmarkCounters are not enabled!");
    }

    @Override
    public LIRInstruction createMultiBenchmarkCounter(String[] names, String[] groups, Value[] increments) {
        if (BenchmarkCounters.enabled) {
            return new SPARCHotSpotCounterOp(names, groups, increments, this.getProviders().getRegisters(), this.config);
        }
        throw GraalError.shouldNotReachHere("BenchmarkCounters are not enabled!");
    }

    public AllocatableValue getSafepointAddressValue() {
        if (this.safepointAddressValue == null) {
            this.safepointAddressValue = SPARCHotSpotSafepointOp.getSafepointAddressValue(this);
        }
        return this.safepointAddressValue;
    }

    @Override
    protected SPARCControlFlow.StrategySwitchOp createStrategySwitchOp(AllocatableValue base, SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, Variable key, Variable scratchValue) {
        return new SPARCHotSpotStrategySwitchOp((Value)base, strategy, keyTargets, defaultTarget, key, scratchValue);
    }

    public void setDebugInfoBuilder(HotSpotDebugInfoBuilder debugInfoBuilder) {
        this.debugInfoBuilder = debugInfoBuilder;
    }

    @Override
    public StandardOp.ZapRegistersOp createZapRegisters(Register[] zappedRegisters, JavaConstant[] zapValues) {
        throw GraalError.unimplemented();
    }

    @Override
    public LIRInstruction createZapArgumentSpace(StackSlot[] zappedStack, JavaConstant[] zapValues) {
        throw GraalError.unimplemented();
    }
}

