/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.sparc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.sparc.SPARCAddress;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotCounterOp;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="BenchMarkCounter")
public class SPARCHotSpotCounterOp
extends HotSpotCounterOp {
    public static final LIRInstructionClass<SPARCHotSpotCounterOp> TYPE = LIRInstructionClass.create(SPARCHotSpotCounterOp.class);
    private int[] counterPatchOffsets;

    public SPARCHotSpotCounterOp(String name, String group, Value increment, HotSpotRegistersProvider registers, GraalHotSpotVMConfig config) {
        super(TYPE, name, group, increment, registers, config);
        this.counterPatchOffsets = new int[1];
    }

    public SPARCHotSpotCounterOp(String[] names, String[] groups, Value[] increments, HotSpotRegistersProvider registers, GraalHotSpotVMConfig config) {
        super(TYPE, names, groups, increments, registers, config);
        this.counterPatchOffsets = new int[names.length];
    }

    @Override
    public void emitCode(CompilationResultBuilder crb) {
        SPARCMacroAssembler masm = (SPARCMacroAssembler)crb.asm;
        TargetDescription target = crb.target;
        SPARCAddress countersArrayAddr = new SPARCAddress(this.thread, this.config.jvmciCountersThreadOffset);
        try (SPARCMacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
            Register countersArrayReg = scratch.getRegister();
            masm.ldx(countersArrayAddr, countersArrayReg);
            IncrementEmitter emitter = new IncrementEmitter(countersArrayReg, masm);
            this.forEachCounter(emitter, target);
        }
    }

    private void emitIncrement(int counterIndex, SPARCMacroAssembler masm, SPARCAddress counterAddr, Value increment) {
        try (SPARCMacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
            Register counterReg = scratch.getRegister();
            masm.ldx(counterAddr, counterReg);
            this.counterPatchOffsets[counterIndex] = masm.position();
            if (LIRValueUtil.isJavaConstant(increment)) {
                masm.add(counterReg, SPARCHotSpotCounterOp.asInt(LIRValueUtil.asJavaConstant(increment)), counterReg);
            } else {
                masm.add(counterReg, ValueUtil.asRegister((Value)increment), counterReg);
            }
            masm.stx(counterReg, counterAddr);
        }
    }

    @Override
    public void patchCounterIncrement(Assembler asm, int[] increment) {
        for (int i = 0; i < increment.length; ++i) {
            int inst = this.counterPatchOffsets[i];
            ((SPARCAssembler)asm).patchAddImmediate(inst, increment[i]);
        }
    }

    public int[] getCounterPatchOffsets() {
        return this.counterPatchOffsets;
    }

    private class IncrementEmitter
    implements HotSpotCounterOp.CounterProcedure {
        private int lastDisplacement = 0;
        private final Register countersArrayReg;
        private final SPARCMacroAssembler masm;

        IncrementEmitter(Register countersArrayReg, SPARCMacroAssembler masm) {
            this.countersArrayReg = countersArrayReg;
            this.masm = masm;
        }

        @Override
        public void apply(int counterIndex, Value increment, int displacement) {
            SPARCAddress counterAddr;
            int relativeDisplacement = displacement - this.lastDisplacement;
            if (SPARCAssembler.isSimm13(relativeDisplacement)) {
                counterAddr = new SPARCAddress(this.countersArrayReg, relativeDisplacement);
            } else {
                try (SPARCMacroAssembler.ScratchRegister scratch = this.masm.getScratchRegister();){
                    Register tempOffsetRegister = scratch.getRegister();
                    this.masm.setx(relativeDisplacement, tempOffsetRegister, false);
                    this.masm.add(this.countersArrayReg, tempOffsetRegister, this.countersArrayReg);
                }
                this.lastDisplacement = displacement;
                counterAddr = new SPARCAddress(this.countersArrayReg, 0);
            }
            SPARCHotSpotCounterOp.this.emitIncrement(counterIndex, this.masm, counterAddr, increment);
        }
    }
}

