/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements.aot;

import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.Constant;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.meta.HotSpotConstantLoadAction;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.aot.EncodedSymbolNode;
import org.graalvm.compiler.hotspot.nodes.aot.InitializeKlassNode;
import org.graalvm.compiler.hotspot.nodes.aot.InitializeKlassStubCall;
import org.graalvm.compiler.hotspot.nodes.aot.LoadConstantIndirectlyNode;
import org.graalvm.compiler.hotspot.nodes.aot.LoadMethodCountersIndirectlyNode;
import org.graalvm.compiler.hotspot.nodes.aot.ResolveConstantNode;
import org.graalvm.compiler.hotspot.nodes.aot.ResolveConstantStubCall;
import org.graalvm.compiler.hotspot.nodes.aot.ResolveDynamicConstantNode;
import org.graalvm.compiler.hotspot.nodes.aot.ResolveDynamicStubCall;
import org.graalvm.compiler.hotspot.nodes.aot.ResolveMethodAndLoadCountersNode;
import org.graalvm.compiler.hotspot.nodes.aot.ResolveMethodAndLoadCountersStubCall;
import org.graalvm.compiler.hotspot.nodes.type.MethodPointerStamp;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.hotspot.word.MethodCountersPointer;
import org.graalvm.compiler.hotspot.word.MethodPointer;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public class ResolveConstantSnippets
implements Snippets {
    @Snippet
    public static Object resolveObjectConstant(Object constant) {
        Object result = LoadConstantIndirectlyNode.loadObject(constant);
        if (BranchProbabilityNode.probability(0.0010000000000000009, result == null)) {
            result = ResolveConstantStubCall.resolveObject(constant, EncodedSymbolNode.encode(constant));
        }
        return result;
    }

    @Snippet
    public static Object resolveDynamicConstant(Object constant) {
        Object result = LoadConstantIndirectlyNode.loadObject(constant);
        if (BranchProbabilityNode.probability(0.0010000000000000009, result == null)) {
            result = ResolveDynamicStubCall.resolveInvoke(constant);
        }
        return result;
    }

    @Snippet
    public static KlassPointer resolveKlassConstant(KlassPointer constant) {
        KlassPointer result = LoadConstantIndirectlyNode.loadKlass(constant);
        if (BranchProbabilityNode.probability(0.0010000000000000009, result.isNull())) {
            result = ResolveConstantStubCall.resolveKlass(constant, EncodedSymbolNode.encode(constant));
        }
        return result;
    }

    @Snippet
    public static MethodCountersPointer resolveMethodAndLoadCounters(MethodPointer method, KlassPointer klassHint) {
        MethodCountersPointer result = LoadMethodCountersIndirectlyNode.loadMethodCounters(method);
        if (BranchProbabilityNode.probability(0.0010000000000000009, result.isNull())) {
            result = ResolveMethodAndLoadCountersStubCall.resolveMethodAndLoadCounters(method, klassHint, EncodedSymbolNode.encode(method));
        }
        return result;
    }

    @Snippet
    public static KlassPointer initializeKlass(KlassPointer constant) {
        KlassPointer result = LoadConstantIndirectlyNode.loadKlass(constant, HotSpotConstantLoadAction.INITIALIZE);
        if (BranchProbabilityNode.probability(0.0010000000000000009, result.isNull())) {
            result = InitializeKlassStubCall.initializeKlass(constant, EncodedSymbolNode.encode(constant));
        }
        return result;
    }

    @Snippet
    public static KlassPointer pureInitializeKlass(KlassPointer constant) {
        KlassPointer result = LoadConstantIndirectlyNode.loadKlass(constant, HotSpotConstantLoadAction.INITIALIZE);
        if (BranchProbabilityNode.probability(0.0010000000000000009, result.isNull())) {
            result = ResolveConstantStubCall.resolveKlass(constant, EncodedSymbolNode.encode(constant), HotSpotConstantLoadAction.INITIALIZE);
        }
        return result;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo resolveObjectConstant = this.snippet(ResolveConstantSnippets.class, "resolveObjectConstant", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo resolveDynamicConstant = this.snippet(ResolveConstantSnippets.class, "resolveDynamicConstant", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo resolveKlassConstant = this.snippet(ResolveConstantSnippets.class, "resolveKlassConstant", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo resolveMethodAndLoadCounters = this.snippet(ResolveConstantSnippets.class, "resolveMethodAndLoadCounters", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo initializeKlass = this.snippet(ResolveConstantSnippets.class, "initializeKlass", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo pureInitializeKlass = this.snippet(ResolveConstantSnippets.class, "pureInitializeKlass", new LocationIdentity[0]);

        public Templates(OptionValues options, Iterable<DebugHandlersFactory> factories, HotSpotProviders providers, TargetDescription target) {
            super(options, factories, providers, providers.getSnippetReflection(), target);
        }

        public void lower(ResolveDynamicConstantNode resolveConstantNode, LoweringTool tool) {
            StructuredGraph graph = resolveConstantNode.graph();
            ValueNode value = resolveConstantNode.value();
            assert (value.isConstant()) : "Expected a constant: " + value;
            SnippetTemplate.SnippetInfo snippet = this.resolveDynamicConstant;
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("constant", value);
            SnippetTemplate template = this.template(resolveConstantNode, args);
            template.instantiate(this.providers.getMetaAccess(), resolveConstantNode, SnippetTemplate.DEFAULT_REPLACER, args);
            assert (resolveConstantNode.hasNoUsages());
            if (!resolveConstantNode.isDeleted()) {
                GraphUtil.killWithUnusedFloatingInputs(resolveConstantNode);
            }
        }

        public void lower(ResolveConstantNode resolveConstantNode, LoweringTool tool) {
            StructuredGraph graph = resolveConstantNode.graph();
            ValueNode value = resolveConstantNode.value();
            assert (value.isConstant()) : "Expected a constant: " + value;
            Constant constant = value.asConstant();
            SnippetTemplate.SnippetInfo snippet = null;
            if (constant instanceof HotSpotMetaspaceConstant) {
                HotSpotMetaspaceConstant hotspotMetaspaceConstant = (HotSpotMetaspaceConstant)constant;
                if (hotspotMetaspaceConstant.asResolvedJavaType() != null) {
                    if (resolveConstantNode.action() == HotSpotConstantLoadAction.RESOLVE) {
                        snippet = this.resolveKlassConstant;
                    } else {
                        assert (resolveConstantNode.action() == HotSpotConstantLoadAction.INITIALIZE);
                        snippet = this.pureInitializeKlass;
                    }
                }
            } else if (constant instanceof HotSpotObjectConstant) {
                snippet = this.resolveObjectConstant;
                HotSpotObjectConstant hotspotObjectConstant = (HotSpotObjectConstant)constant;
                assert (hotspotObjectConstant.isInternedString());
            }
            if (snippet == null) {
                throw new GraalError("Unsupported constant type: " + constant);
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("constant", value);
            SnippetTemplate template = this.template(resolveConstantNode, args);
            template.instantiate(this.providers.getMetaAccess(), resolveConstantNode, SnippetTemplate.DEFAULT_REPLACER, args);
            assert (resolveConstantNode.hasNoUsages());
            if (!resolveConstantNode.isDeleted()) {
                GraphUtil.killWithUnusedFloatingInputs(resolveConstantNode);
            }
        }

        public void lower(InitializeKlassNode initializeKlassNode, LoweringTool tool) {
            StructuredGraph graph = initializeKlassNode.graph();
            ValueNode value = initializeKlassNode.value();
            assert (value.isConstant()) : "Expected a constant: " + value;
            Constant constant = value.asConstant();
            if (constant instanceof HotSpotMetaspaceConstant) {
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.initializeKlass, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("constant", value);
                SnippetTemplate template = this.template(initializeKlassNode, args);
                template.instantiate(this.providers.getMetaAccess(), initializeKlassNode, SnippetTemplate.DEFAULT_REPLACER, args);
                assert (initializeKlassNode.hasNoUsages());
                if (!initializeKlassNode.isDeleted()) {
                    GraphUtil.killWithUnusedFloatingInputs(initializeKlassNode);
                }
            } else {
                throw new GraalError("Unsupported constant type: " + constant);
            }
        }

        public void lower(ResolveMethodAndLoadCountersNode resolveMethodAndLoadCountersNode, LoweringTool tool) {
            StructuredGraph graph = resolveMethodAndLoadCountersNode.graph();
            ConstantNode method = ConstantNode.forConstant(MethodPointerStamp.methodNonNull(), resolveMethodAndLoadCountersNode.getMethod().getEncoding(), tool.getMetaAccess(), graph);
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.resolveMethodAndLoadCounters, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("method", method);
            args.add("klassHint", resolveMethodAndLoadCountersNode.getHub());
            SnippetTemplate template = this.template(resolveMethodAndLoadCountersNode, args);
            template.instantiate(this.providers.getMetaAccess(), resolveMethodAndLoadCountersNode, SnippetTemplate.DEFAULT_REPLACER, args);
            assert (resolveMethodAndLoadCountersNode.hasNoUsages());
            if (!resolveMethodAndLoadCountersNode.isDeleted()) {
                GraphUtil.killWithUnusedFloatingInputs(resolveMethodAndLoadCountersNode);
            }
        }
    }
}

