/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.nodes.CurrentJavaThreadNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;

@ClassSubstitution(value=Thread.class)
public class ThreadSubstitutions {
    @MethodSubstitution(isStatic=false, optional=true)
    public static boolean isInterrupted(Thread thisObject, boolean clearInterrupted) {
        Word javaThread = CurrentJavaThreadNode.get();
        Object thread = javaThread.readObject(HotSpotReplacementsUtil.threadObjectOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.JAVA_THREAD_THREAD_OBJECT_LOCATION);
        if (thisObject == thread) {
            boolean interrupted;
            Word osThread = (Word)javaThread.readWord(HotSpotReplacementsUtil.osThreadOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.JAVA_THREAD_OSTHREAD_LOCATION);
            boolean bl = interrupted = osThread.readInt(HotSpotReplacementsUtil.osThreadInterruptedOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), LocationIdentity.any()) != 0;
            if (!interrupted || !clearInterrupted) {
                return interrupted;
            }
        }
        return ThreadSubstitutions.isInterrupted(thisObject, clearInterrupted);
    }
}

