/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import java.util.EnumMap;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.nodes.java.DynamicNewArrayNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyCallNode;
import org.graalvm.word.LocationIdentity;

public class ObjectCloneSnippets
implements Snippets {
    @Snippet
    public static boolean[] booleanArrayClone(boolean[] src) {
        boolean[] result = (boolean[])NewArrayNode.newUninitializedArray(Boolean.TYPE, src.length);
        ArrayCopyCallNode.disjointArraycopy(src, 0, result, 0, src.length, JavaKind.Boolean, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    @Snippet
    public static byte[] byteArrayClone(byte[] src) {
        byte[] result = (byte[])NewArrayNode.newUninitializedArray(Byte.TYPE, src.length);
        ArrayCopyCallNode.disjointArraycopy(src, 0, result, 0, src.length, JavaKind.Byte, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    @Snippet
    public static short[] shortArrayClone(short[] src) {
        short[] result = (short[])NewArrayNode.newUninitializedArray(Short.TYPE, src.length);
        ArrayCopyCallNode.disjointArraycopy(src, 0, result, 0, src.length, JavaKind.Short, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    @Snippet
    public static char[] charArrayClone(char[] src) {
        char[] result = (char[])NewArrayNode.newUninitializedArray(Character.TYPE, src.length);
        ArrayCopyCallNode.disjointArraycopy(src, 0, result, 0, src.length, JavaKind.Char, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    @Snippet
    public static int[] intArrayClone(int[] src) {
        int[] result = (int[])NewArrayNode.newUninitializedArray(Integer.TYPE, src.length);
        ArrayCopyCallNode.disjointArraycopy(src, 0, result, 0, src.length, JavaKind.Int, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    @Snippet
    public static float[] floatArrayClone(float[] src) {
        float[] result = (float[])NewArrayNode.newUninitializedArray(Float.TYPE, src.length);
        ArrayCopyCallNode.disjointArraycopy(src, 0, result, 0, src.length, JavaKind.Float, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    @Snippet
    public static long[] longArrayClone(long[] src) {
        long[] result = (long[])NewArrayNode.newUninitializedArray(Long.TYPE, src.length);
        ArrayCopyCallNode.disjointArraycopy(src, 0, result, 0, src.length, JavaKind.Long, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    @Snippet
    public static double[] doubleArrayClone(double[] src) {
        double[] result = (double[])NewArrayNode.newUninitializedArray(Double.TYPE, src.length);
        ArrayCopyCallNode.disjointArraycopy(src, 0, result, 0, src.length, JavaKind.Double, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    @Snippet
    public static Object[] objectArrayClone(Object[] src) {
        Object[] result = (Object[])DynamicNewArrayNode.newArray(GraalDirectives.guardingNonNull(src.getClass().getComponentType()), src.length, JavaKind.Object);
        ArrayCopyCallNode.disjointUninitializedArraycopy(src, 0, result, 0, src.length, JavaKind.Object, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        final EnumMap<JavaKind, SnippetTemplate.SnippetInfo> arrayCloneMethods = new EnumMap(JavaKind.class);

        public Templates(OptionValues options, Iterable<DebugHandlersFactory> factories, HotSpotProviders providers, TargetDescription target) {
            super(options, factories, providers, providers.getSnippetReflection(), target);
            this.arrayCloneMethods.put(JavaKind.Boolean, this.snippet(ObjectCloneSnippets.class, "booleanArrayClone", new LocationIdentity[0]));
            this.arrayCloneMethods.put(JavaKind.Byte, this.snippet(ObjectCloneSnippets.class, "byteArrayClone", new LocationIdentity[0]));
            this.arrayCloneMethods.put(JavaKind.Char, this.snippet(ObjectCloneSnippets.class, "charArrayClone", new LocationIdentity[0]));
            this.arrayCloneMethods.put(JavaKind.Short, this.snippet(ObjectCloneSnippets.class, "shortArrayClone", new LocationIdentity[0]));
            this.arrayCloneMethods.put(JavaKind.Int, this.snippet(ObjectCloneSnippets.class, "intArrayClone", new LocationIdentity[0]));
            this.arrayCloneMethods.put(JavaKind.Float, this.snippet(ObjectCloneSnippets.class, "floatArrayClone", new LocationIdentity[0]));
            this.arrayCloneMethods.put(JavaKind.Long, this.snippet(ObjectCloneSnippets.class, "longArrayClone", new LocationIdentity[0]));
            this.arrayCloneMethods.put(JavaKind.Double, this.snippet(ObjectCloneSnippets.class, "doubleArrayClone", new LocationIdentity[0]));
            this.arrayCloneMethods.put(JavaKind.Object, this.snippet(ObjectCloneSnippets.class, "objectArrayClone", new LocationIdentity[0]));
        }
    }
}

