/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.Constant;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.core.common.type.DataPointerConstant;

public final class EncodedSymbolConstant
extends DataPointerConstant {
    private final Constant constant;
    private byte[] bytes;

    public EncodedSymbolConstant(Constant constant) {
        super(1);
        this.constant = constant;
    }

    public int getSerializedSize() {
        return this.getEncodedConstant().length;
    }

    public void serialize(ByteBuffer buffer) {
        buffer.put(this.getEncodedConstant());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] toUTF8String(String s) {
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
            DataOutputStream stream = new DataOutputStream(bytes);
            stream.writeUTF(s);
            byte[] byArray = bytes.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new PermanentBailoutException(e, "String conversion failed: %s", s);
        }
    }

    private static byte[] encodeConstant(Constant constant) {
        assert (constant != null);
        if (constant instanceof HotSpotObjectConstant) {
            return EncodedSymbolConstant.toUTF8String((String)((HotSpotObjectConstant)constant).asObject(String.class));
        }
        if (constant instanceof HotSpotMetaspaceConstant) {
            HotSpotMetaspaceConstant metaspaceConstant = (HotSpotMetaspaceConstant)constant;
            HotSpotResolvedObjectType klass = metaspaceConstant.asResolvedJavaType();
            if (klass != null) {
                return EncodedSymbolConstant.toUTF8String(klass.getName());
            }
            HotSpotResolvedJavaMethod method = metaspaceConstant.asResolvedJavaMethod();
            if (method != null) {
                byte[] methodName = EncodedSymbolConstant.toUTF8String(method.getName());
                byte[] signature = EncodedSymbolConstant.toUTF8String(method.getSignature().toMethodDescriptor());
                byte[] result = new byte[methodName.length + signature.length];
                int resultPos = 0;
                System.arraycopy(methodName, 0, result, resultPos, methodName.length);
                System.arraycopy(signature, 0, result, resultPos += methodName.length, signature.length);
                assert ((resultPos += signature.length) == result.length);
                return result;
            }
        }
        throw new PermanentBailoutException("Encoding of constant %s failed", constant);
    }

    public byte[] getEncodedConstant() {
        if (this.bytes == null) {
            this.bytes = EncodedSymbolConstant.encodeConstant(this.constant);
        }
        return this.bytes;
    }

    public String toValueString() {
        return "encoded symbol\"" + this.constant.toValueString() + "\"";
    }
}

