/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.hotspot.nodes.type.KlassPointerStamp;
import org.graalvm.compiler.hotspot.replacements.HubGetClassNode;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ConvertNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.extended.GetClassNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.spi.Lowerable;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
@Node.NodeIntrinsicFactory
public final class ClassGetHubNode
extends FloatingNode
implements Lowerable,
Canonicalizable,
ConvertNode {
    public static final NodeClass<ClassGetHubNode> TYPE = NodeClass.create(ClassGetHubNode.class);
    @Node.Input
    protected ValueNode clazz;

    public ClassGetHubNode(ValueNode clazz) {
        super((NodeClass<? extends FloatingNode>)TYPE, (Stamp)KlassPointerStamp.klass());
        this.clazz = clazz;
    }

    public static ValueNode create(ValueNode clazz, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection) {
        return ClassGetHubNode.canonical(null, metaAccess, constantReflection, false, KlassPointerStamp.klass(), clazz);
    }

    public static boolean intrinsify(GraphBuilderContext b, ValueNode clazz) {
        ValueNode clazzValue = ClassGetHubNode.create(clazz, b.getMetaAccess(), b.getConstantReflection());
        b.push(JavaKind.Object, b.append(clazzValue));
        return true;
    }

    public static ValueNode canonical(ClassGetHubNode classGetHubNode, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection, boolean allUsagesAvailable, Stamp stamp, ValueNode clazz) {
        ClassGetHubNode self = classGetHubNode;
        if (allUsagesAvailable && self != null && self.hasNoUsages()) {
            return null;
        }
        if (clazz.isConstant() && !clazz.isNullConstant() && metaAccess != null) {
            ResolvedJavaType exactType = constantReflection.asJavaType(clazz.asConstant());
            assert (exactType != null) : classGetHubNode.toString(Verbosity.Debugger);
            if (exactType.isPrimitive()) {
                return ConstantNode.forConstant(stamp, (Constant)JavaConstant.NULL_POINTER, metaAccess);
            }
            return ConstantNode.forConstant(stamp, constantReflection.asObjectHub(exactType), metaAccess);
        }
        if (clazz instanceof GetClassNode) {
            GetClassNode getClass = (GetClassNode)clazz;
            return new LoadHubNode(KlassPointerStamp.klassNonNull(), getClass.getObject());
        }
        if (clazz instanceof HubGetClassNode) {
            return ((HubGetClassNode)clazz).getHub();
        }
        if (self == null) {
            self = new ClassGetHubNode(clazz);
        }
        return self;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        return ClassGetHubNode.canonical(this, tool.getMetaAccess(), tool.getConstantReflection(), tool.allUsagesAvailable(), this.stamp(NodeView.DEFAULT), this.clazz);
    }

    @Node.NodeIntrinsic
    public static native KlassPointer readClass(Class<?> var0);

    @Node.NodeIntrinsic(value=PiNode.class)
    public static native KlassPointer piCastNonNull(Object var0, GuardingNode var1);

    @Override
    public ValueNode getValue() {
        return this.clazz;
    }

    @Override
    public Constant convert(Constant c, ConstantReflectionProvider constantReflection) {
        ResolvedJavaType exactType = constantReflection.asJavaType(c);
        if (exactType.isPrimitive()) {
            return JavaConstant.NULL_POINTER;
        }
        return constantReflection.asObjectHub(exactType);
    }

    @Override
    public Constant reverse(Constant c, ConstantReflectionProvider constantReflection) {
        assert (!c.equals(JavaConstant.NULL_POINTER));
        ResolvedJavaType objectType = constantReflection.asJavaType(c);
        return constantReflection.asJavaClass(objectType);
    }

    @Override
    public boolean isLossless() {
        return false;
    }

    @Override
    public boolean mayNullCheckSkipConversion() {
        return false;
    }

    @Override
    public boolean preservesOrder(CanonicalCondition op, Constant value, ConstantReflectionProvider constantReflection) {
        assert (op == CanonicalCondition.EQ);
        ResolvedJavaType exactType = constantReflection.asJavaType(value);
        return !exactType.isPrimitive();
    }
}

