/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes.profiling;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.hotspot.nodes.profiling.ProfileNode;
import org.graalvm.compiler.hotspot.nodes.profiling.ProfileWithNotificationNode;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;

@NodeInfo
public class ProfileBranchNode
extends ProfileWithNotificationNode {
    public static final NodeClass<ProfileBranchNode> TYPE = NodeClass.create(ProfileBranchNode.class);
    @Node.OptionalInput
    ValueNode branchCondition;
    protected int bci;
    protected int targetBci;

    public ProfileBranchNode(ResolvedJavaMethod method, int freqLog, int probabilityLog, ConditionalNode branchCondition, int bci, int targetBci) {
        super(TYPE, method, freqLog, probabilityLog);
        assert (targetBci <= bci);
        this.branchCondition = branchCondition;
        this.bci = bci;
        this.targetBci = targetBci;
    }

    public ProfileBranchNode(ResolvedJavaMethod method, int freqLog, int probabilityLog, int bci, int targetBci) {
        super(TYPE, method, freqLog, probabilityLog);
        assert (targetBci <= bci);
        this.branchCondition = null;
        this.bci = bci;
        this.targetBci = targetBci;
    }

    public int bci() {
        return this.bci;
    }

    public int targetBci() {
        return this.targetBci;
    }

    public ValueNode branchCondition() {
        return this.branchCondition;
    }

    public boolean hasCondition() {
        return this.branchCondition != null;
    }

    @Override
    protected boolean canBeMergedWith(ProfileNode p) {
        if (p instanceof ProfileBranchNode) {
            ProfileBranchNode that = (ProfileBranchNode)p;
            return this.method.equals(that.method) && this.bci == that.bci;
        }
        return false;
    }

    public static NodeIterable<ProfileBranchNode> getProfileBranchNodes(StructuredGraph graph) {
        return graph.getNodes().filter(ProfileBranchNode.class);
    }
}

